/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.savageandravage.common.block.RunedGloomyTilesBlock;
import com.minecraftabnormals.savageandravage.common.entity.ITracksHits;
import com.minecraftabnormals.savageandravage.core.registry.SRBlocks;
import com.minecraftabnormals.savageandravage.core.registry.SREffects;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class RunePrisonEntity
extends Entity {
    private static final DataParameter<Integer> TICKS_TILL_REMOVE = EntityDataManager.func_187226_a(RunePrisonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> BLOCK_POS = EntityDataManager.func_187226_a(RunePrisonEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private final boolean fromTrap;
    private UUID casterUUID = null;
    private int casterID = 0;
    private int currentFrame = 0;
    private boolean isBackwardsFrameCycle = false;

    public RunePrisonEntity(EntityType<? extends RunePrisonEntity> type, World world) {
        super(type, world);
        this.fromTrap = false;
    }

    public RunePrisonEntity(World world, BlockPos position, int ticksTillRemove, boolean fromTrap) {
        super((EntityType)SREntities.RUNE_PRISON.get(), world);
        this.setBlockPos(position);
        this.fromTrap = fromTrap;
        this.setTicksTillRemove(ticksTillRemove);
    }

    public <T extends Entity> RunePrisonEntity(World world, BlockPos position, int ticksTillRemove, boolean fromTrap, T caster) {
        this(world, position, ticksTillRemove, fromTrap);
        this.setCaster(caster);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BLOCK_POS, Optional.empty());
        this.field_70180_af.func_187214_a(TICKS_TILL_REMOVE, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setTicksTillRemove(compound.func_74762_e("TicksTillRemove"));
        if (compound.func_150297_b("GloomyTilePosition", 10)) {
            this.setBlockPos(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("GloomyTilePosition")));
        }
        if (compound.func_186855_b("CasterUUID")) {
            this.casterUUID = compound.func_186857_a("CasterID");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("TicksTillRemove", this.getTicksTillRemove());
        if (this.getBlockPos() != null) {
            compound.func_218657_a("GloomyTilePosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.getBlockPos()));
        }
        if (this.casterUUID != null) {
            compound.func_186854_a("CasterUUID", this.casterUUID);
        }
    }

    @Nullable
    public ITracksHits getCaster() {
        if (this.casterUUID != null && this.field_70170_p instanceof ServerWorld) {
            return (ITracksHits)((ServerWorld)this.field_70170_p).func_217461_a(this.casterUUID);
        }
        return this.casterID != 0 ? (ITracksHits)this.field_70170_p.func_73045_a(this.casterID) : null;
    }

    public void setCaster(@Nullable Entity caster) {
        this.casterID = caster == null ? 0 : caster.func_145782_y();
        this.casterUUID = caster == null ? null : caster.func_110124_au();
    }

    public int getTicksTillRemove() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_TILL_REMOVE);
    }

    public void setTicksTillRemove(int tickCount) {
        this.field_70180_af.func_187227_b(TICKS_TILL_REMOVE, (Object)tickCount);
    }

    @Nullable
    public BlockPos getBlockPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BLOCK_POS)).orElse(null);
    }

    private void setBlockPos(@Nullable BlockPos positionIn) {
        this.field_70180_af.func_187227_b(BLOCK_POS, Optional.ofNullable(positionIn));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_201670_d() && this.getTicksTillRemove() % 5 == 0) {
            if (!this.isBackwardsFrameCycle) {
                ++this.currentFrame;
                if (this.currentFrame == 4) {
                    this.isBackwardsFrameCycle = true;
                }
            } else {
                --this.currentFrame;
                if (this.currentFrame == 0) {
                    this.isBackwardsFrameCycle = false;
                }
            }
        }
        if (this.getTicksTillRemove() > 0) {
            this.setTicksTillRemove(this.getTicksTillRemove() - 1);
        }
        for (LivingEntity livingEntity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ())) {
            if (!livingEntity.func_184603_cC()) continue;
            livingEntity.func_195064_c(new EffectInstance((Effect)SREffects.WEIGHT.get(), 60, 2));
            if (this.getCaster() == null) continue;
            this.getCaster().onTrackedHit(this, (Entity)livingEntity);
        }
        if (this.getTicksTillRemove() == 0) {
            this.func_70106_y();
            BlockPos pos = this.getBlockPos();
            if (pos != null && this.fromTrap && this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof RunedGloomyTilesBlock) {
                this.field_70170_p.func_175656_a(pos, ((Block)SRBlocks.GLOOMY_TILES.get()).func_176223_P());
            }
        }
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

