/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.savageandravage.common.entity.CreepieEntity;
import com.minecraftabnormals.savageandravage.common.entity.SporeCloudEntity;
import com.minecraftabnormals.savageandravage.common.item.CreeperSporesItem;
import com.minecraftabnormals.savageandravage.core.registry.SRItems;
import com.minecraftabnormals.savageandravage.core.registry.SRSounds;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class GrieferEntity
extends AbstractIllagerEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> KICKING = EntityDataManager.func_187226_a(GrieferEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> APESHIT_MODE = EntityDataManager.func_187226_a(GrieferEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final EntityPredicate distance = new EntityPredicate().func_221013_a(10.0);
    public int creeperSporeStacks;
    public int kickTicks;
    public int kickCoolDown;

    public GrieferEntity(EntityType<? extends GrieferEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AbstractRaiderEntity.FindTargetGoal((AbstractRaiderEntity)this, (AbstractIllagerEntity)this, 10.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new KickGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleePhaseGoal(this, 0.9, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackWithSporesGoal(this, 0.9, 200));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true){

            public boolean func_75250_a() {
                return !(this.field_75441_b.func_184614_ca().func_77973_b() instanceof CreeperSporesItem) && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 15.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(KICKING, (Object)false);
        this.field_70180_af.func_187214_a(APESHIT_MODE, (Object)false);
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        return this.func_213656_en() ? AbstractIllagerEntity.ArmPose.CELEBRATING : AbstractIllagerEntity.ArmPose.NEUTRAL;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219686_is;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219688_iu;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219689_iv;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SRItems.GRIEFER_SPAWN_EGG.get());
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219687_it;
    }

    public void func_70636_d() {
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isKicking()) {
            ((LivingEntity)entityIn).func_233627_a_(1.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.kickTicks = 10;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            this.func_70625_a(entityIn, 90.0f, 90.0f);
        }
        return super.func_70652_k(entityIn);
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            this.kickTicks = 10;
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        if (this.isApeshit() && this.creeperSporeStacks <= 0 && damageSrc.func_76346_g() == this.func_70638_az() && this.func_70638_az() != null) {
            this.creeperSporeStacks = MathHelper.func_76123_f((float)(this.field_110153_bc / 2.0f));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.kickTicks = compound.func_74762_e("KickTicks");
        this.creeperSporeStacks = compound.func_74762_e("CreeperSporeStacks");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("KickTicks", this.kickTicks);
        compound.func_74768_a("CreeperSporeStacks", this.creeperSporeStacks);
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public void kick(LivingEntity entity) {
        this.setKicking(true);
        this.func_70652_k((Entity)entity);
        this.kickCoolDown = 30;
    }

    public boolean isKicking() {
        return (Boolean)this.field_70180_af.func_187225_a(KICKING);
    }

    public boolean isApeshit() {
        return (Boolean)this.field_70180_af.func_187225_a(APESHIT_MODE);
    }

    public void setKicking(boolean shouldSetKicking) {
        this.field_70180_af.func_187227_b(KICKING, (Object)shouldSetKicking);
    }

    public void becomeApeshit(boolean shouldBecomeApeshit) {
        this.field_70180_af.func_187227_b(APESHIT_MODE, (Object)shouldBecomeApeshit);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        this.creeperSporeStacks = 3 + this.field_70146_Z.nextInt(3);
        return spawnDataIn;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SRItems.CREEPER_SPORES.get()));
        this.giveArmorOnRandom(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)SRItems.GRIEFER_HELMET.get()));
        this.giveArmorOnRandom(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)SRItems.GRIEFER_CHESTPLATE.get()));
        this.giveArmorOnRandom(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)SRItems.GRIEFER_LEGGINGS.get()));
        this.giveArmorOnRandom(EquipmentSlotType.FEET, new ItemStack((IItemProvider)SRItems.GRIEFER_BOOTS.get()));
    }

    private void giveArmorOnRandom(EquipmentSlotType slot, ItemStack stack) {
        float chance;
        ItemStack itemstack = this.func_184582_a(slot);
        float f = chance = this.func_213630_eb() ? 1.0f : 0.1f;
        if (itemstack.func_190926_b() && this.field_70146_Z.nextFloat() < chance) {
            this.func_184201_a(slot, stack);
        }
    }

    public void func_213660_a(int arg0, boolean arg1) {
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.field_70170_p.func_217374_a(CreepieEntity.class, this.distance, (LivingEntity)this, this.func_174813_aQ().func_72314_b(10.0, 4.0, 10.0)).size() < 5 && this.func_184614_ca().func_77973_b() instanceof CreeperSporesItem) {
            SporeCloudEntity creeperSpores = new SporeCloudEntity(this.field_70170_p, (LivingEntity)this);
            double distance = target.func_226278_cu_() - 1.0;
            double d1 = target.func_226277_ct_() - this.func_226277_ct_();
            double d2 = distance - creeperSpores.func_226278_cu_();
            double d3 = target.func_226281_cx_() - this.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
            creeperSpores.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
            creeperSpores.setCloudSize(creeperSpores.field_70170_p.field_73012_v.nextInt(50) == 0 ? 0 : 1 + creeperSpores.field_70170_p.field_73012_v.nextInt(3));
            this.func_184609_a(this.func_184600_cs());
            this.func_184185_a((SoundEvent)SRSounds.ENTITY_CREEPER_SPORES_THROW.get(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_217376_c((Entity)creeperSpores);
            this.func_70625_a((Entity)target, 30.0f, 30.0f);
            --this.creeperSporeStacks;
        }
    }

    public static class AttackWithSporesGoal
    extends Goal {
        private final GrieferEntity griefer;
        private int rangedAttackTime = -1;
        private final double entityMoveSpeed;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private boolean strafingClockwise;
        private int seeTime;
        private int strafeTime;

        public AttackWithSporesGoal(GrieferEntity attacker, double moveSpeed, int maxAttackTime) {
            this(attacker, moveSpeed, maxAttackTime, maxAttackTime);
        }

        public AttackWithSporesGoal(GrieferEntity attacker, double moveSpeed, int p_i1650_4_, int maxAttackTime) {
            this.griefer = attacker;
            this.entityMoveSpeed = moveSpeed;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = 15.0f;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.griefer.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.griefer.creeperSporeStacks > 0;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !this.griefer.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            if (this.griefer.isApeshit()) {
                this.griefer.becomeApeshit(false);
            }
            if (this.griefer.creeperSporeStacks > 0) {
                this.griefer.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)SRItems.CREEPER_SPORES.get()));
            }
        }

        public void func_75251_c() {
            this.griefer.func_213395_q(false);
            this.griefer.func_70624_b(null);
            this.griefer.func_70661_as();
            this.rangedAttackTime = -1;
            if (this.griefer.isKicking()) {
                this.griefer.setKicking(false);
            }
        }

        private boolean isWalkable() {
            PathNavigator pathnavigator = this.griefer.func_70661_as();
            NodeProcessor nodeprocessor = pathnavigator.func_189566_q();
            return nodeprocessor.func_186330_a((IBlockReader)this.griefer.field_70170_p, MathHelper.func_76128_c((double)(this.griefer.func_226277_ct_() + 1.0)), MathHelper.func_76128_c((double)this.griefer.func_226278_cu_()), MathHelper.func_76128_c((double)(this.griefer.func_226281_cx_() + 1.0))) == PathNodeType.WALKABLE;
        }

        public void func_75246_d() {
            LivingEntity attackTarget = this.griefer.func_70638_az();
            if (attackTarget != null) {
                double distance = this.griefer.func_70032_d((Entity)attackTarget);
                boolean canSee = this.griefer.func_70635_at().func_75522_a((Entity)attackTarget);
                this.griefer.func_213395_q(true);
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if (distance <= 15.0) {
                    this.griefer.func_70661_as().func_75499_g();
                } else {
                    this.griefer.func_70661_as().func_75497_a((Entity)attackTarget, this.entityMoveSpeed);
                }
                if (this.griefer.func_70681_au().nextDouble() < 0.3 && this.strafeTime <= 0) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.strafeTime > 0) {
                    if (this.isWalkable()) {
                        this.griefer.func_70605_aq().func_188488_a(0.0f, (float)(this.strafingClockwise ? this.entityMoveSpeed : -this.entityMoveSpeed));
                    } else {
                        this.griefer.func_191989_p(1.0f);
                        this.griefer.func_184646_p(0.0f);
                        this.griefer.func_70661_as().func_75499_g();
                    }
                }
                this.griefer.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
                this.griefer.func_70625_a((Entity)attackTarget, 30.0f, 30.0f);
                if (--this.rangedAttackTime == 0 || this.seeTime == 3) {
                    if (!canSee) {
                        return;
                    }
                    float f = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                    float distanceFactor = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                    this.griefer.func_82196_d(attackTarget, distanceFactor);
                    this.strafeTime = 50;
                    this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
                } else if (this.rangedAttackTime < 0) {
                    float f2 = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                    this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
                }
            }
        }
    }

    public static class MeleePhaseGoal
    extends MeleeAttackGoal {
        private final GrieferEntity griefer;

        public MeleePhaseGoal(GrieferEntity griefer, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)griefer, speedIn, useLongMemory);
            this.griefer = griefer;
        }

        public boolean func_75250_a() {
            return this.griefer.creeperSporeStacks == 0 && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.griefer.creeperSporeStacks == 0 && super.func_75253_b();
        }

        public void func_75249_e() {
            this.griefer.becomeApeshit(true);
            if (this.griefer.creeperSporeStacks == 0) {
                this.griefer.func_184611_a(this.griefer.func_184600_cs(), ItemStack.field_190927_a);
            }
            super.func_75249_e();
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double distance = this.func_179512_a(enemy);
            int i = this.griefer.field_70170_p.field_73012_v.nextInt(3);
            if (distToEnemySqr <= distance && this.field_234037_i_ <= 0) {
                this.field_234037_i_ = 60;
                switch (i) {
                    case 0: {
                        this.griefer.func_184609_a(Hand.MAIN_HAND);
                        break;
                    }
                    case 1: {
                        this.griefer.func_184609_a(Hand.OFF_HAND);
                        break;
                    }
                    case 2: {
                        this.griefer.kick(enemy);
                    }
                }
                this.griefer.func_70625_a((Entity)enemy, 30.0f, 30.0f);
                this.griefer.func_70652_k((Entity)enemy);
                enemy.func_233627_a_(1.5f, (double)MathHelper.func_76126_a((float)(this.griefer.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.griefer.field_70177_z * ((float)Math.PI / 180)))));
            }
        }
    }

    public static class KickGoal
    extends Goal {
        private final GrieferEntity griefer;

        public KickGoal(GrieferEntity griefer) {
            this.griefer = griefer;
        }

        public boolean func_75250_a() {
            LivingEntity entity = this.griefer.func_70638_az();
            return this.griefer.func_70638_az() != null && entity != null && (double)entity.func_70032_d((Entity)this.griefer) <= 2.5 && !this.griefer.isKicking() && this.griefer.kickTicks <= 0 && this.griefer.kickCoolDown == 0 && this.griefer.creeperSporeStacks > 0;
        }

        public void func_75249_e() {
            LivingEntity entity = this.griefer.func_70638_az();
            if (entity != null) {
                this.griefer.kick(entity);
            }
        }

        public void func_75251_c() {
            this.griefer.kickTicks = 0;
            this.griefer.setKicking(false);
        }
    }
}

