/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.savageandravage.core.SRConfig;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import com.minecraftabnormals.savageandravage.core.registry.SRTriggers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class BurningBannerEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Integer> TICKS_TILL_REMOVE = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Optional<BlockPos>> BLOCK_POS = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    public static final DataParameter<Optional<UUID>> OFFENDER_UUID = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final double[] ROTATED_VERTICES = new double[3];
    private AxisAlignedBB burningBox;
    private double burningBoxRotation;

    public BurningBannerEntity(EntityType<? extends BurningBannerEntity> type, World world) {
        super(type, world);
        this.burningBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.burningBoxRotation = 0.0;
    }

    public BurningBannerEntity(World world, BlockPos pos, @Nullable PlayerEntity player) {
        super((EntityType)SREntities.BURNING_BANNER.get(), world);
        this.setBannerPosition(pos);
        if (player != null) {
            this.setOffenderId(player.func_110124_au());
        }
        BlockState state = world.func_180495_p(pos);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() - (state.func_177230_c() instanceof WallBannerBlock ? 1 : 0), (double)pos.func_177952_p() + 0.5);
        this.burningBox = BurningBannerEntity.getBurningBox(state);
        this.burningBoxRotation = BurningBannerEntity.getBurningBoxRotation(state);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BLOCK_POS, Optional.empty());
        this.field_70180_af.func_187214_a(OFFENDER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(TICKS_TILL_REMOVE, (Object)110);
    }

    public void func_70071_h_() {
        this.setTicksTillRemove(this.getTicksTillRemove() - 1);
        int ticksRemaining = this.getTicksTillRemove();
        BlockPos bannerPos = this.getBannerPosition();
        if (bannerPos == null || ticksRemaining <= 0) {
            this.func_70106_y();
            return;
        }
        if (ticksRemaining > 10 && !(this.field_70170_p.func_175625_s(bannerPos) instanceof BannerTileEntity)) {
            this.extinguishFire();
            return;
        }
        if (this.field_70170_p.func_201670_d()) {
            for (int i = 0; i < 5; ++i) {
                double randomPositionX = this.burningBox.func_197745_a(Direction.Axis.X) + (double)this.field_70170_p.func_201674_k().nextFloat() * this.burningBox.func_216364_b();
                double randomPositionY = this.burningBox.func_197745_a(Direction.Axis.Y) + (double)this.field_70170_p.func_201674_k().nextFloat() * this.burningBox.func_216360_c();
                double randomPositionZ = this.burningBox.func_197745_a(Direction.Axis.Z) + (double)this.field_70170_p.func_201674_k().nextFloat() * this.burningBox.func_216362_d();
                double[] rotatedPosition = BurningBannerEntity.rotate(randomPositionX, randomPositionY, randomPositionZ, this.burningBoxRotation);
                randomPositionX = (double)bannerPos.func_177958_n() + rotatedPosition[0];
                randomPositionY = (double)bannerPos.func_177956_o() + rotatedPosition[1];
                randomPositionZ = (double)bannerPos.func_177952_p() + rotatedPosition[2];
                if (ticksRemaining > 10) {
                    if (this.field_70146_Z.nextInt(5) == 2) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, randomPositionX, randomPositionY, randomPositionZ, 0.0, 0.0, 0.0);
                    }
                    if (this.field_70146_Z.nextInt(5) != 3) continue;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, randomPositionX, randomPositionY, randomPositionZ, 0.0, 0.0, 0.0);
                    continue;
                }
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, randomPositionX, randomPositionY, randomPositionZ, 0.0, 0.0, 0.0);
            }
        } else if (this.getTicksTillRemove() > 10) {
            this.func_184185_a(this.field_70170_p.func_175625_s(bannerPos) instanceof BannerTileEntity ? SoundEvents.field_187643_bs : SoundEvents.field_187646_bt, 2.0f, this.field_70170_p.func_201674_k().nextFloat() * 0.4f + 0.8f);
        } else if (this.getTicksTillRemove() == 10) {
            this.func_184185_a(SoundEvents.field_187646_bt, 2.0f, this.field_70170_p.func_201674_k().nextFloat() * 0.4f + 0.8f);
            PlayerEntity offender = this.getOffender();
            if (offender != null && BurningBannerEntity.isOminousBanner((IBlockReader)this.field_70170_p, bannerPos) && ((ServerWorld)this.field_70170_p).func_217475_c_(bannerPos) == null) {
                SRTriggers.BURN_OMINOUS_BANNER.trigger((ServerPlayerEntity)offender);
                if (((Boolean)SRConfig.COMMON.noBadOmenOnDeath.get()).booleanValue() && !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                    EffectInstance effect = offender.func_70660_b(Effects.field_220309_E);
                    if (effect != null) {
                        offender.func_184596_c(Effects.field_220309_E);
                    }
                    offender.func_195064_c(new EffectInstance(Effects.field_220309_E, 120000, MathHelper.func_76125_a((int)(effect == null ? 0 : effect.func_76458_c() + 1), (int)0, (int)4), false, false, true));
                }
            }
            this.field_70170_p.func_217377_a(bannerPos, false);
        }
    }

    public void extinguishFire() {
        this.func_184185_a(SoundEvents.field_187646_bt, 0.5f, this.field_70170_p.func_201674_k().nextFloat() * 0.4f + 0.8f);
        this.func_70106_y();
    }

    public void func_213323_x_() {
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Size", 0);
        compound.func_74768_a("TicksTillRemove", this.getTicksTillRemove());
        if (this.getBannerPosition() != null) {
            compound.func_218657_a("BannerPosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.getBannerPosition()));
        }
        if (this.getOffenderId() != null) {
            compound.func_186854_a("Offender", this.getOffenderId());
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setTicksTillRemove(compound.func_74762_e("TicksTillRemove"));
        if (compound.func_150297_b("BannerPosition", 10)) {
            this.setBannerPosition(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("BannerPosition")));
        }
        if (compound.func_186855_b("Offender")) {
            this.setOffenderId(compound.func_186857_a("Offender"));
        }
    }

    public int getTicksTillRemove() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_TILL_REMOVE);
    }

    public void setTicksTillRemove(int tickCount) {
        this.field_70180_af.func_187227_b(TICKS_TILL_REMOVE, (Object)tickCount);
    }

    @Nullable
    public BlockPos getBannerPosition() {
        return ((Optional)this.field_70180_af.func_187225_a(BLOCK_POS)).orElse(null);
    }

    private void setBannerPosition(@Nullable BlockPos positionIn) {
        this.field_70180_af.func_187227_b(BLOCK_POS, Optional.ofNullable(positionIn));
    }

    @Nullable
    public UUID getOffenderId() {
        return ((Optional)this.field_70180_af.func_187225_a(OFFENDER_UUID)).orElse(null);
    }

    public void setOffenderId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(OFFENDER_UUID, Optional.ofNullable(ownerId));
    }

    @Nullable
    public PlayerEntity getOffender() {
        UUID uuid = this.getOffenderId();
        return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
    }

    public AxisAlignedBB getBurningBox() {
        return this.burningBox;
    }

    public double getBurningBoxRotation() {
        return this.burningBoxRotation;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static boolean isOminousBanner(IBlockReader world, BlockPos pos) {
        BannerTileEntity banner;
        if (world.func_175625_s(pos) instanceof BannerTileEntity && (banner = (BannerTileEntity)Objects.requireNonNull(world.func_175625_s(pos))).func_200200_C_() instanceof TranslationTextComponent) {
            return ((TranslationTextComponent)banner.func_200200_C_()).func_150268_i().contains("block.minecraft.ominous_banner");
        }
        return false;
    }

    public static AxisAlignedBB getBurningBox(BlockState state) {
        return state.func_235901_b_((Property)WallBannerBlock.field_196290_a) ? new AxisAlignedBB(0.0625, -0.84375, 0.09375, 0.9375, 0.875, 0.25) : new AxisAlignedBB(0.0625, 0.15625, 0.53125, 0.9375, 1.84375, 0.6875);
    }

    public static double getBurningBoxRotation(BlockState state) {
        Direction direction = state.func_235901_b_((Property)WallBannerBlock.field_196290_a) ? (Direction)state.func_177229_b((Property)WallBannerBlock.field_196290_a) : null;
        return direction != null ? Math.toRadians(direction.func_185119_l()) : (double)((float)((double)((Integer)state.func_177229_b((Property)BannerBlock.field_176448_b)).intValue() / 8.0 * Math.PI));
    }

    public static double[] rotate(double x, double y, double z, double angle) {
        float cos = MathHelper.func_76134_b((float)((float)angle));
        float sin = MathHelper.func_76126_a((float)((float)angle));
        BurningBannerEntity.ROTATED_VERTICES[0] = 0.5 + (x - 0.5) * (double)cos - (z - 0.5) * (double)sin;
        BurningBannerEntity.ROTATED_VERTICES[1] = y;
        BurningBannerEntity.ROTATED_VERTICES[2] = 0.5 + (x - 0.5) * (double)sin + (z - 0.5) * (double)cos;
        return ROTATED_VERTICES;
    }

    public void writeSpawnData(PacketBuffer buf) {
        BlockPos bannerPos = this.getBannerPosition();
        buf.writeBoolean(bannerPos != null);
        if (bannerPos != null) {
            buf.func_179255_a(this.getBannerPosition());
        }
    }

    public void readSpawnData(PacketBuffer buf) {
        BlockPos bannerPos;
        BlockPos blockPos = bannerPos = buf.readBoolean() ? buf.func_179259_c() : null;
        if (bannerPos != null) {
            BlockState state = this.field_70170_p.func_180495_p(bannerPos);
            this.burningBox = BurningBannerEntity.getBurningBox(state);
            this.burningBoxRotation = BurningBannerEntity.getBurningBoxRotation(state);
        }
    }
}

