/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.pipeline;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.attribute.BufferVertexFormat;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.VertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.type.BlittableVertexType;
import me.jellysquid.mods.sodium.client.model.vertex.type.VertexType;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.vertex.VertexFormat;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
implements VertexBufferView,
VertexDrain {
    @Shadow
    private int field_227824_l_;
    @Shadow
    private ByteBuffer field_179001_a;
    @Shadow
    @Final
    private static Logger field_187316_a;
    @Shadow
    private VertexFormat field_179011_q;
    @Shadow
    private int field_178997_d;

    @Shadow
    private static int func_216566_c(int amount) {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"popData"}, at=@At(value="INVOKE", target="Ljava/nio/Buffer;limit(I)Ljava/nio/Buffer;"))
    public Buffer debugGetNextBuffer(Buffer buffer, int newLimit) {
        this.ensureBufferCapacity(newLimit);
        buffer = this.field_179001_a;
        buffer.limit(newLimit);
        return buffer;
    }

    @Override
    public boolean ensureBufferCapacity(int bytes) {
        if (this.field_179011_q == null) {
            return false;
        }
        if (this.field_227824_l_ + (bytes += this.field_179011_q.func_177338_f()) <= this.field_179001_a.capacity()) {
            return false;
        }
        int newSize = this.field_179001_a.capacity() + MixinBufferBuilder.func_216566_c(bytes);
        field_187316_a.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)this.field_179001_a.capacity(), (Object)newSize);
        this.field_179001_a.position(0);
        ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)newSize);
        byteBuffer.put(this.field_179001_a);
        byteBuffer.rewind();
        this.field_179001_a = byteBuffer;
        return true;
    }

    @Override
    public ByteBuffer getDirectBuffer() {
        return this.field_179001_a;
    }

    @Override
    public int getWriterPosition() {
        return this.field_227824_l_;
    }

    @Override
    public BufferVertexFormat getVertexFormat() {
        return BufferVertexFormat.from(this.field_179011_q);
    }

    @Override
    public void flush(int vertexCount, BufferVertexFormat format) {
        if (BufferVertexFormat.from(this.field_179011_q) != format) {
            throw new IllegalStateException("Mis-matched vertex format (expected: [" + format + "], currently using: [" + this.field_179011_q + "])");
        }
        this.field_178997_d += vertexCount;
        this.field_227824_l_ += vertexCount * format.getStride();
    }

    @Override
    public <T extends VertexSink> T createSink(VertexType<T> factory) {
        BlittableVertexType<T> blittable = factory.asBlittable();
        if (blittable != null && blittable.getBufferVertexFormat() == this.getVertexFormat()) {
            return blittable.createBufferWriter(this, SodiumClientMod.isDirectMemoryAccessEnabled());
        }
        return factory.createFallbackWriter((IVertexBuilder)this);
    }
}

