/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import me.jellysquid.mods.sodium.client.gl.compat.LegacyFogHelper;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;

public abstract class ChunkShaderFogComponent {
    public abstract void setup();

    private static void setupColorUniform(int index) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buf = stack.mallocFloat(4);
            LegacyFogHelper.getFogColor(buf);
            GlStateManager.func_227715_e_((int)index, (FloatBuffer)buf);
        }
    }

    public static class Linear
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogLength;
        private final int uFogEnd;

        public Linear(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogLength = program.getUniformLocation("u_FogLength");
            this.uFogEnd = program.getUniformLocation("u_FogEnd");
        }

        @Override
        public void setup() {
            ChunkShaderFogComponent.setupColorUniform(this.uFogColor);
            float end = LegacyFogHelper.getFogEnd();
            float start = LegacyFogHelper.getFogStart();
            GL20C.glUniform1f((int)this.uFogLength, (float)(end - start));
            GL20C.glUniform1f((int)this.uFogEnd, (float)end);
        }
    }

    public static class Exp2
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogDensity;

        public Exp2(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogDensity = program.getUniformLocation("u_FogDensity");
        }

        @Override
        public void setup() {
            ChunkShaderFogComponent.setupColorUniform(this.uFogColor);
            GL20C.glUniform1f((int)this.uFogDensity, (float)LegacyFogHelper.getFogDensity());
        }
    }

    public static class None
    extends ChunkShaderFogComponent {
        public None(ChunkProgram program) {
        }

        @Override
        public void setup() {
        }
    }
}

