/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.format.sfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.render.chunk.format.DefaultModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import org.lwjgl.system.MemoryUtil;

public class SFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink {
    public SFPModelVertexBufferWriterUnsafe(VertexBufferView backingBuffer) {
        super(backingBuffer, DefaultModelVertexFormats.MODEL_VERTEX_SFP);
    }

    @Override
    public void writeQuad(float x, float y, float z, int color, float u, float v, int light) {
        long i = this.writePointer;
        MemoryUtil.memPutFloat((long)i, (float)x);
        MemoryUtil.memPutFloat((long)(i + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(i + 8L), (float)z);
        MemoryUtil.memPutInt((long)(i + 12L), (int)color);
        MemoryUtil.memPutFloat((long)(i + 16L), (float)u);
        MemoryUtil.memPutFloat((long)(i + 20L), (float)v);
        MemoryUtil.memPutInt((long)(i + 24L), (int)SFPModelVertexBufferWriterUnsafe.encodeLightMapTexCoord(light));
        this.advance();
    }

    private static int encodeLightMapTexCoord(int light) {
        int sl = light >> 16 & 0xFF;
        sl = (sl << 8) + 2048;
        int bl = light & 0xFF;
        bl = (bl << 8) + 2048;
        return sl << 16 | bl;
    }
}

