/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayDeque;
import java.util.Collection;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.compat.FlywheelCompat;
import me.jellysquid.mods.sodium.client.gl.compat.LegacyFogHelper;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderColumn;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkCuller;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkFaceFlags;
import me.jellysquid.mods.sodium.client.render.chunk.cull.graph.ChunkGraphCuller;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.IdTable;
import me.jellysquid.mods.sodium.common.util.collections.FutureDequeDrain;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;

public class ChunkRenderManager<T extends ChunkGraphicsState>
implements ChunkStatusListener {
    private static final double NEARBY_CHUNK_DISTANCE = Math.pow(48.0, 2.0);
    private static final float FOG_PLANE_MIN_DISTANCE = (float)Math.pow(8.0, 2.0);
    private static final float FOG_PLANE_OFFSET = 12.0f;
    private final ChunkBuilder<T> builder;
    private final ChunkRenderBackend<T> backend;
    private final Long2ObjectOpenHashMap<ChunkRenderColumn<T>> columns = new Long2ObjectOpenHashMap();
    private final IdTable<ChunkRenderContainer<T>> renders = new IdTable(16384);
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> importantRebuildQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> rebuildQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> unloadQueue = new ObjectArrayFIFOQueue();
    private final ChunkRenderList<T>[] chunkRenderLists = new ChunkRenderList[BlockRenderPass.COUNT];
    private final ObjectList<ChunkRenderContainer<T>> tickableChunks = new ObjectArrayList();
    private final ObjectList<TileEntity> visibleBlockEntities = new ObjectArrayList();
    private final SodiumWorldRenderer renderer;
    private final ClientWorld world;
    private final ChunkCuller culler;
    private final boolean useBlockFaceCulling;
    private float cameraX;
    private float cameraY;
    private float cameraZ;
    private boolean dirty;
    private int visibleChunkCount;
    private boolean useFogCulling;
    private double fogRenderCutoff;

    public ChunkRenderManager(SodiumWorldRenderer renderer, ChunkRenderBackend<T> backend, BlockRenderPassManager renderPassManager, ClientWorld world, int renderDistance) {
        this.backend = backend;
        this.renderer = renderer;
        this.world = world;
        this.builder = new ChunkBuilder<T>(backend.getVertexType(), this.backend);
        this.builder.init(world, renderPassManager);
        this.dirty = true;
        for (int i = 0; i < this.chunkRenderLists.length; ++i) {
            this.chunkRenderLists[i] = new ChunkRenderList();
        }
        this.culler = new ChunkGraphCuller((World)world, renderDistance);
        this.useBlockFaceCulling = SodiumClientMod.options().advanced.useBlockFaceCulling;
    }

    public void update(ActiveRenderInfo camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.reset();
        this.unloadPending();
        this.setup(camera);
        this.iterateChunks(camera, frustum, frame, spectator);
        this.dirty = false;
    }

    private void setup(ActiveRenderInfo camera) {
        float dist;
        Vector3d cameraPos = camera.func_216785_c();
        this.cameraX = (float)cameraPos.field_72450_a;
        this.cameraY = (float)cameraPos.field_72448_b;
        this.cameraZ = (float)cameraPos.field_72449_c;
        this.useFogCulling = false;
        if (SodiumClientMod.options().advanced.useFogOcclusion && (dist = LegacyFogHelper.getFogCutoff() + 12.0f) != 0.0f) {
            this.useFogCulling = true;
            this.fogRenderCutoff = Math.max(FOG_PLANE_MIN_DISTANCE, dist * dist);
        }
    }

    private void iterateChunks(ActiveRenderInfo camera, FrustumExtended frustum, int frame, boolean spectator) {
        IntArrayList list = this.culler.computeVisible(camera, frustum, frame, spectator);
        IntListIterator it = list.iterator();
        while (it.hasNext()) {
            ChunkRenderContainer<T> render = this.renders.get(it.nextInt());
            this.addChunk(render);
        }
    }

    private void addChunk(ChunkRenderContainer<T> render) {
        if (render.needsRebuild() && render.canRebuild()) {
            if (render.needsImportantRebuild()) {
                this.importantRebuildQueue.enqueue(render);
            } else {
                this.rebuildQueue.enqueue(render);
            }
        }
        if (this.useFogCulling && render.getSquaredDistanceXZ(this.cameraX, this.cameraZ) >= this.fogRenderCutoff) {
            return;
        }
        if (!render.isEmpty()) {
            this.addChunkToRenderLists(render);
            this.addEntitiesToRenderLists(render);
        }
    }

    private void addChunkToRenderLists(ChunkRenderContainer<T> render) {
        int visibleFaces = this.computeVisibleFaces(render) & render.getFacesWithData();
        if (visibleFaces == 0) {
            return;
        }
        boolean added = false;
        ChunkGraphicsState[] states = render.getGraphicsStates();
        for (int i = 0; i < states.length; ++i) {
            ChunkGraphicsState state = states[i];
            if (state == null) continue;
            ChunkRenderList<ChunkGraphicsState> list = this.chunkRenderLists[i];
            list.add(state, visibleFaces);
            added = true;
        }
        if (added) {
            if (render.isTickable()) {
                this.tickableChunks.add(render);
            }
            ++this.visibleChunkCount;
        }
    }

    private int computeVisibleFaces(ChunkRenderContainer<T> render) {
        if (!this.useBlockFaceCulling) {
            return ChunkFaceFlags.ALL;
        }
        ChunkRenderBounds bounds = render.getBounds();
        int visibleFaces = ChunkFaceFlags.UNASSIGNED;
        if (this.cameraY > bounds.y1) {
            visibleFaces |= ChunkFaceFlags.UP;
        }
        if (this.cameraY < bounds.y2) {
            visibleFaces |= ChunkFaceFlags.DOWN;
        }
        if (this.cameraX > bounds.x1) {
            visibleFaces |= ChunkFaceFlags.EAST;
        }
        if (this.cameraX < bounds.x2) {
            visibleFaces |= ChunkFaceFlags.WEST;
        }
        if (this.cameraZ > bounds.z1) {
            visibleFaces |= ChunkFaceFlags.SOUTH;
        }
        if (this.cameraZ < bounds.z2) {
            visibleFaces |= ChunkFaceFlags.NORTH;
        }
        return visibleFaces;
    }

    private void addEntitiesToRenderLists(ChunkRenderContainer<T> render) {
        Collection<TileEntity> blockEntities = render.getData().getBlockEntities();
        if (!blockEntities.isEmpty()) {
            this.visibleBlockEntities.addAll(blockEntities);
            FlywheelCompat.filterBlockEntityList(this.visibleBlockEntities);
        }
    }

    public ChunkRenderContainer<T> getRender(int x, int y, int z) {
        ChunkRenderColumn column = (ChunkRenderColumn)this.columns.get(ChunkPos.func_77272_a((int)x, (int)z));
        if (column == null) {
            return null;
        }
        return column.getRender(y);
    }

    private void reset() {
        this.rebuildQueue.clear();
        this.importantRebuildQueue.clear();
        this.visibleBlockEntities.clear();
        for (ChunkRenderList<T> list : this.chunkRenderLists) {
            list.reset();
        }
        this.tickableChunks.clear();
        this.visibleChunkCount = 0;
    }

    private void unloadPending() {
        while (!this.unloadQueue.isEmpty()) {
            ((ChunkRenderContainer)this.unloadQueue.dequeue()).delete();
        }
    }

    public Collection<TileEntity> getVisibleBlockEntities() {
        return this.visibleBlockEntities;
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.loadChunk(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.unloadChunk(x, z);
    }

    private void loadChunk(int x, int z) {
        ChunkRenderColumn column = new ChunkRenderColumn(x, z);
        ChunkRenderColumn prev = (ChunkRenderColumn)this.columns.put(ChunkPos.func_77272_a((int)x, (int)z), column);
        if (prev != null) {
            this.unloadSections(prev);
        }
        this.connectNeighborColumns(column);
        this.loadSections(column);
        this.dirty = true;
    }

    private void unloadChunk(int x, int z) {
        ChunkRenderColumn column = (ChunkRenderColumn)this.columns.remove(ChunkPos.func_77272_a((int)x, (int)z));
        if (column == null) {
            return;
        }
        this.disconnectNeighborColumns(column);
        this.unloadSections(column);
        this.dirty = true;
    }

    private void loadSections(ChunkRenderColumn<T> column) {
        int x = column.getX();
        int z = column.getZ();
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer<T> render = this.createChunkRender(column, x, y, z);
            column.setRender(y, render);
            this.culler.onSectionLoaded(x, y, z, render.getId());
        }
    }

    private void unloadSections(ChunkRenderColumn<T> column) {
        int x = column.getX();
        int z = column.getZ();
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer<T> render = column.getRender(y);
            if (render != null) {
                this.unloadQueue.enqueue(render);
                this.renders.remove(render.getId());
            }
            this.culler.onSectionUnloaded(x, y, z);
        }
    }

    private void connectNeighborColumns(ChunkRenderColumn<T> column) {
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkRenderColumn<T> adj = this.getAdjacentColumn(column, dir);
            if (adj != null) {
                adj.setAdjacentColumn(dir.func_176734_d(), column);
            }
            column.setAdjacentColumn(dir, adj);
        }
    }

    private void disconnectNeighborColumns(ChunkRenderColumn<T> column) {
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkRenderColumn adj = column.getAdjacentColumn(dir);
            if (adj != null) {
                adj.setAdjacentColumn(dir.func_176734_d(), null);
            }
            column.setAdjacentColumn(dir, null);
        }
    }

    private ChunkRenderColumn<T> getAdjacentColumn(ChunkRenderColumn<T> column, Direction dir) {
        return this.getColumn(column.getX() + dir.func_82601_c(), column.getZ() + dir.func_82599_e());
    }

    private ChunkRenderColumn<T> getColumn(int x, int z) {
        return (ChunkRenderColumn)this.columns.get(ChunkPos.func_77272_a((int)x, (int)z));
    }

    private ChunkRenderContainer<T> createChunkRender(ChunkRenderColumn<T> column, int x, int y, int z) {
        ChunkRenderContainer<T> render = new ChunkRenderContainer<T>(this.backend, this.renderer, x, y, z, column);
        if (ChunkSection.func_222628_a((ChunkSection)this.world.func_212866_a_(x, z).func_76587_i()[y])) {
            render.setData(ChunkRenderData.EMPTY);
        } else {
            render.scheduleRebuild(false);
        }
        render.setId(this.renders.add(render));
        return render;
    }

    public void renderLayer(MatrixStack matrixStack, BlockRenderPass pass, double x, double y, double z) {
        ChunkRenderList<T> chunkRenderList = this.chunkRenderLists[pass.ordinal()];
        ChunkRenderListIterator<T> iterator = chunkRenderList.iterator(pass.isTranslucent());
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.backend.begin(matrixStack);
        this.backend.render(commandList, iterator, new ChunkCameraContext(x, y, z));
        this.backend.end(matrixStack);
        commandList.flush();
    }

    public void tickVisibleRenders() {
        for (ChunkRenderContainer render : this.tickableChunks) {
            render.tick();
        }
    }

    public boolean isChunkVisible(int x, int y, int z) {
        return this.culler.isSectionVisible(x, y, z);
    }

    public void updateChunks() {
        ChunkRenderContainer render;
        ArrayDeque futures = new ArrayDeque();
        int budget = this.builder.getSchedulingBudget();
        int submitted = 0;
        while (!this.importantRebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.importantRebuildQueue.dequeue();
            if (render == null) continue;
            if (!this.isChunkPrioritized(render)) {
                this.builder.deferRebuild(render);
            } else {
                futures.add(this.builder.scheduleRebuildTaskAsync(render));
            }
            this.dirty = true;
            ++submitted;
        }
        while (submitted < budget && !this.rebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.rebuildQueue.dequeue();
            this.builder.deferRebuild(render);
            ++submitted;
        }
        this.dirty |= submitted > 0;
        this.dirty |= this.builder.performPendingUploads();
        if (!futures.isEmpty()) {
            this.backend.upload(RenderDevice.INSTANCE.createCommandList(), new FutureDequeDrain(futures));
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void restoreChunks(LongCollection chunks) {
        LongIterator it = chunks.iterator();
        while (it.hasNext()) {
            long pos = it.nextLong();
            this.loadChunk(ChunkPos.func_212578_a((long)pos), ChunkPos.func_212579_b((long)pos));
        }
    }

    public boolean isBuildComplete() {
        return this.builder.isBuildQueueEmpty();
    }

    public void destroy() {
        this.reset();
        for (ChunkRenderColumn column : this.columns.values()) {
            this.unloadSections(column);
        }
        this.columns.clear();
        this.builder.stopWorkers();
    }

    public int getTotalSections() {
        return this.columns.size() * 16;
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        ChunkRenderContainer<T> render = this.getRender(x, y, z);
        if (render != null) {
            boolean bl = important = important || this.isChunkPrioritized(render);
            if (render.scheduleRebuild(important)) {
                (render.needsImportantRebuild() ? this.importantRebuildQueue : this.rebuildQueue).enqueue(render);
            }
            this.dirty = true;
        }
        this.builder.onChunkDataChanged(x, y, z);
    }

    public boolean isChunkPrioritized(ChunkRenderContainer<T> render) {
        return render != null ? render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE : false;
    }

    public int getVisibleChunkCount() {
        return this.visibleChunkCount;
    }

    public void onChunkRenderUpdates(int x, int y, int z, ChunkRenderData data) {
        this.culler.onSectionStateChanged(x, y, z, data.getOcclusionData());
    }
}

