/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.world;

import com.therandomlabs.randompatches.RandomPatches;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="randompatches")
public final class DuplicateEntityUUIDFixHandler {
    private static final Random random = new Random();

    private DuplicateEntityUUIDFixHandler() {
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!RandomPatches.config().misc.bugFixes.fixDuplicateEntityUUIDs || event.getWorld().func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        Chunk chunk = (Chunk)event.getChunk();
        for (ClassInheritanceMultiMap entityList : chunk.func_177429_s()) {
            for (Entity entity : entityList) {
                UUID newUniqueID;
                UUID uniqueID;
                if (entity instanceof PlayerEntity || world.func_217461_a(uniqueID = entity.func_110124_au()) == entity) continue;
                while (world.func_217461_a(newUniqueID = MathHelper.func_180182_a((Random)random)) != null) {
                }
                entity.func_184221_a(uniqueID);
                if (!RandomPatches.config().misc.bugFixes.logFixedDuplicateEntityUUIDs) continue;
                RandomPatches.logger.info("Changing UUID of duplicate entity {} from {} to {}", (Object)entity.func_200600_R().getRegistryName(), (Object)uniqueID, (Object)newUniqueID);
            }
        }
    }
}

