/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.client;

import com.therandomlabs.randompatches.RPConfig;
import com.therandomlabs.randompatches.RandomPatches;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class RPWindowHandler {
    private static final StrSubstitutor titleSubstitutor = new StrSubstitutor((StrLookup)TitleLookup.access$100());
    private static @Nullable String activity;
    private static boolean enabled;

    private RPWindowHandler() {
    }

    public static void enable() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            enabled = true;
        }
    }

    public static void onConfigReload() {
        if (FMLEnvironment.dist == Dist.CLIENT && enabled) {
            Minecraft.func_71410_x().execute(RPWindowHandler::applySettings);
        }
    }

    public static String getWindowTitle() {
        if (FMLEnvironment.dist != Dist.CLIENT || !enabled) {
            return RPConfig.Window.DEFAULT_TITLE;
        }
        RPConfig.Window config = RandomPatches.config().client.window;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayNetHandler handler = mc.func_147114_u();
        if (handler == null || !handler.func_147298_b().func_150724_d()) {
            activity = null;
            return titleSubstitutor.replace(ModList.get() == null ? config.simpleTitle : config.title);
        }
        String activityKey = mc.func_71401_C() != null && !mc.func_71401_C().func_71344_c() ? "title.singleplayer" : (mc.func_181540_al() ? "title.multiplayer.realms" : (mc.func_71401_C() == null && (mc.func_147104_D() == null || !mc.func_147104_D().func_181041_d()) ? "title.multiplayer.other" : "title.multiplayer.lan"));
        activity = I18n.func_135052_a((String)activityKey, (Object[])new Object[0]);
        return titleSubstitutor.replace(config.titleWithActivity);
    }

    public static void updateWindowIcon(@Nullable InputStream vanillaIcon16, @Nullable InputStream vanillaIcon32) {
        if (FMLEnvironment.dist == Dist.CLIENT && enabled && RandomPatches.config().client.window.customIcon) {
            RPWindowHandler.updateWindowIcon(vanillaIcon16, vanillaIcon32, Minecraft.func_71410_x().func_228018_at_().func_198092_i());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWindowIcon(@Nullable InputStream vanillaIcon16, @Nullable InputStream vanillaIcon32, long window) {
        block37: {
            if (FMLEnvironment.dist != Dist.CLIENT || !enabled || !RandomPatches.config().client.window.customIcon) {
                return;
            }
            RPConfig.Window config = RandomPatches.config().client.window;
            Minecraft mc = Minecraft.func_71410_x();
            InputStream stream16 = null;
            InputStream stream32 = null;
            InputStream stream256 = null;
            try {
                try (MemoryStack stack = MemoryStack.stackPush();){
                    boolean image256Resized;
                    if (config.icon16.isEmpty()) {
                        VanillaPack vanillaPack = mc.func_195541_I().func_195746_a();
                        stream16 = vanillaIcon16 == null ? vanillaPack.func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_16x16.png")) : vanillaIcon16;
                        InputStream inputStream = stream32 = vanillaIcon32 == null ? vanillaPack.func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_32x32.png")) : vanillaIcon32;
                        if (Minecraft.field_142025_a) {
                            stream256 = vanillaPack.func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_256x256.png"));
                        }
                    } else {
                        stream16 = new FileInputStream(config.icon16);
                        stream32 = new FileInputStream(config.icon32);
                        if (Minecraft.field_142025_a) {
                            stream256 = new FileInputStream(config.icon256);
                        }
                    }
                    IntBuffer x = stack.mallocInt(1);
                    IntBuffer y = stack.mallocInt(1);
                    IntBuffer channels = stack.mallocInt(1);
                    GLFWImage.Buffer imageBuffer = GLFWImage.mallocStack((int)2, (MemoryStack)stack);
                    ByteBuffer image16 = RPWindowHandler.readImageToBuffer(stream16, x, y, channels, 16);
                    if (image16 == null) {
                        throw new IllegalStateException("Failed to load icon: " + STBImage.stbi_failure_reason());
                    }
                    boolean image16Resized = x.get(0) != 16 || y.get(0) != 16;
                    imageBuffer.position(0);
                    imageBuffer.width(16);
                    imageBuffer.height(16);
                    imageBuffer.pixels(image16);
                    ByteBuffer image32 = RPWindowHandler.readImageToBuffer(stream32, x, y, channels, 32);
                    if (image32 == null) {
                        throw new IllegalStateException("Failed to load icon: " + STBImage.stbi_failure_reason());
                    }
                    boolean image32Resized = x.get(0) != 32 || y.get(0) != 32;
                    imageBuffer.position(1);
                    imageBuffer.width(32);
                    imageBuffer.height(32);
                    imageBuffer.pixels(image32);
                    ByteBuffer image256 = null;
                    if (stream256 == null) {
                        image256Resized = false;
                    } else {
                        image256 = RPWindowHandler.readImageToBuffer(stream256, x, y, channels, 256);
                        if (image256 == null) {
                            throw new IllegalStateException("Failed to load icon: " + STBImage.stbi_failure_reason());
                        }
                        image256Resized = x.get(0) != 256 || y.get(0) != 256;
                        imageBuffer.position(2);
                        imageBuffer.width(256);
                        imageBuffer.height(256);
                        imageBuffer.pixels(image256);
                        imageBuffer.position(0);
                    }
                    imageBuffer.position(0);
                    GLFW.glfwSetWindowIcon((long)window, (GLFWImage.Buffer)imageBuffer);
                    if (image16Resized) {
                        MemoryUtil.memFree((Buffer)image16);
                    } else {
                        STBImage.stbi_image_free((ByteBuffer)image16);
                    }
                    if (image32Resized) {
                        MemoryUtil.memFree((Buffer)image32);
                    } else {
                        STBImage.stbi_image_free((ByteBuffer)image32);
                    }
                    if (Minecraft.field_142025_a) {
                        if (image256Resized) {
                            MemoryUtil.memFree((Buffer)image256);
                        } else {
                            STBImage.stbi_image_free((ByteBuffer)image256);
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)stream16);
            }
            catch (IOException ex) {
                RandomPatches.logger.error("Failed to load icon", (Throwable)ex);
                break block37;
            }
            finally {
                IOUtils.closeQuietly(stream16);
                IOUtils.closeQuietly(stream32);
                if (Minecraft.field_142025_a) {
                    IOUtils.closeQuietly(stream256);
                }
            }
            IOUtils.closeQuietly((InputStream)stream32);
            if (Minecraft.field_142025_a) {
                IOUtils.closeQuietly((InputStream)stream256);
            }
        }
    }

    private static void applySettings() {
        if (RandomPatches.config().client.window.customTitle) {
            Minecraft.func_71410_x().func_230150_b_();
        }
        RPWindowHandler.updateWindowIcon(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @Nullable ByteBuffer readImageToBuffer(InputStream stream, IntBuffer x, IntBuffer y, IntBuffer channels, int size) throws IOException {
        ByteBuffer resource = null;
        try {
            resource = TextureUtil.func_225684_a_((InputStream)stream);
            resource.rewind();
            ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)resource, (IntBuffer)x, (IntBuffer)y, (IntBuffer)channels, (int)4);
            if (image == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            int width = x.get(0);
            int height = y.get(0);
            if (width == size && height == size) {
                ByteBuffer byteBuffer = image;
                return byteBuffer;
            }
            ByteBuffer resized = MemoryUtil.memAlloc((int)(size * size * 4));
            STBImageResize.stbir_resize_uint8((ByteBuffer)image, (int)width, (int)height, (int)0, (ByteBuffer)resized, (int)size, (int)size, (int)0, (int)4);
            STBImage.stbi_image_free((ByteBuffer)image);
            ByteBuffer byteBuffer = resized;
            return byteBuffer;
        }
        finally {
            if (resource != null) {
                MemoryUtil.memFree((Buffer)resource);
            }
        }
    }

    private static final class TitleLookup
    extends StrLookup<String> {
        private static final TitleLookup INSTANCE = new TitleLookup();

        private TitleLookup() {
        }

        public @Nullable String lookup(String key) {
            if (key.equals("mcversion")) {
                return SharedConstants.func_215069_a().getName();
            }
            if (key.equals("activity")) {
                return activity;
            }
            if (key.equals("username")) {
                return Minecraft.func_71410_x().func_110432_I().func_111285_a();
            }
            if (key.equals("modsloaded") && ModList.get() != null) {
                return NumberFormat.getInstance().format(ModList.get().getMods().size());
            }
            if (key.startsWith("modversion:") && ModList.get() != null) {
                String modID = key.substring("modversion:".length());
                ModFileInfo fileInfo = ModList.get().getModFileById(modID);
                if (fileInfo == null) {
                    return null;
                }
                for (IModInfo modInfo : fileInfo.getMods()) {
                    if (!modID.equals(modInfo.getModId())) continue;
                    return modInfo.getVersion().toString();
                }
            }
            return null;
        }

        static /* synthetic */ TitleLookup access$100() {
            return INSTANCE;
        }
    }
}

