/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.personality.core.mixin.client;

import com.minecraftabnormals.personality.common.CommonEvents;
import com.minecraftabnormals.personality.core.Personality;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.animation.Animation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BipedModel.class})
public abstract class BipedModelMixin<T extends LivingEntity>
extends AgeableModel<T> {
    @Shadow
    public ModelRenderer field_178723_h;
    @Shadow
    public ModelRenderer field_178724_i;
    @Shadow
    public ModelRenderer field_178721_j;
    @Shadow
    public ModelRenderer field_178722_k;

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")})
    public void sitModel(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        PlayerEntity player;
        if (entityIn instanceof PlayerEntity && Personality.SYNCED_SITTING_PLAYERS.contains((player = (PlayerEntity)entityIn).func_110124_au())) {
            this.field_217113_d = true;
        }
    }

    @Inject(method={"setupAnim"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/entity/model/BipedModel;riding:Z", shift=At.Shift.BEFORE)})
    public void climbAnimation(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (entityIn instanceof PlayerEntity) {
            float f = !this.field_217113_d ? CommonEvents.getClimbingAnimationScale((PlayerEntity)entityIn, Animation.getPartialTickTime()) : 0.0f;
            float climbAnim = -f * (float)Math.PI / 2.0f;
            this.field_178723_h.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f + climbAnim * 1.4f;
            this.field_178724_i.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f + climbAnim * 1.4f;
            this.field_178723_h.field_78808_h = 0.0f;
            this.field_178724_i.field_78808_h = 0.0f;
            this.field_178723_h.field_78796_g = -climbAnim * 0.4f;
            this.field_178724_i.field_78796_g = climbAnim * 0.4f;
            this.field_178721_j.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + climbAnim * 0.5f;
            this.field_178722_k.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + climbAnim * 0.5f;
            this.field_178721_j.field_78796_g = 0.0f;
            this.field_178722_k.field_78796_g = 0.0f;
            this.field_178721_j.field_78808_h = 0.0f;
            this.field_178722_k.field_78808_h = 0.0f;
        }
    }
}

