/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.personality.common.network;

import com.minecraftabnormals.personality.common.network.handler.ClientNetHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageS2CSyncSit {
    private final UUID uuid;
    private final boolean sitting;

    public MessageS2CSyncSit(UUID uuid, boolean sitting) {
        this.uuid = uuid;
        this.sitting = sitting;
    }

    public static MessageS2CSyncSit deserialize(PacketBuffer buf) {
        return new MessageS2CSyncSit(buf.func_179253_g(), buf.readBoolean());
    }

    public static void handle(MessageS2CSyncSit message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> ClientNetHandler.handleSitSync(message, context));
            context.setPacketHandled(true);
        }
    }

    public void serialize(PacketBuffer buf) {
        buf.func_179252_a(this.uuid);
        buf.writeBoolean(this.sitting);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isSitting() {
        return this.sitting;
    }
}

