/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.lwjgl.opengl.GL11;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.packet.NetworkHandler;
import subaraki.paintings.packet.server.SPacketPainting;

public class PaintingScreen
extends Screen {
    final int START_X = 10;
    final int START_Y = 30;
    final int GAP = 5;
    private PaintingType[] resLocs;
    private final int entityID;
    private int scrollbarscroll = 0;

    public PaintingScreen(PaintingType[] resLocs, int entityID) {
        super((ITextComponent)new TranslationTextComponent("select.a.painting"));
        this.resLocs = resLocs;
        this.entityID = entityID;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.addButtons();
        this.scrollbarscroll = 0;
    }

    private void addButtons() {
        int END_X = this.field_230708_k_ - 30;
        int prevHeight = this.resLocs[0].func_200832_c();
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (PaintingType type : this.resLocs) {
            if (posx + type.func_200834_b() > END_X || prevHeight > type.func_200832_c()) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = type.func_200832_c();
            }
            this.func_230480_a_((Widget)new PaintingButton(posx, posy, type.func_200834_b(), type.func_200832_c(), (ITextComponent)new StringTextComponent(""), Button2 -> {
                NetworkHandler.NETWORK.sendToServer((Object)new SPacketPainting(type, this.entityID));
                this.func_231164_f_();
            }, type));
            posx += 5 + type.func_200834_b();
            ++index;
        }
        this.centerRow(rowstart, this.field_230710_m_.size() - 1);
    }

    private void centerRow(int start, int end) {
        int left = ((Widget)this.field_230710_m_.get((int)start)).field_230690_l_;
        int right = ((Widget)this.field_230710_m_.get((int)end)).field_230690_l_ + ((Widget)this.field_230710_m_.get(end)).func_230998_h_();
        int correction = (this.field_230708_k_ - 20 - (right - left)) / 2;
        for (int i = start; i <= end; ++i) {
            Widget widget = (Widget)this.field_230710_m_.get(i);
            if (!(widget instanceof PaintingButton)) continue;
            ((PaintingButton)widget).shiftX(correction);
        }
    }

    public void func_230430_a_(MatrixStack mat, int mouseX, int mouseY, float p_render_3_) {
        this.func_230446_a_(mat);
        PaintingScreen.func_238467_a_((MatrixStack)mat, (int)10, (int)30, (int)(this.field_230708_k_ - 10), (int)(this.field_230709_l_ - 30), (int)0x44444444);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MainWindow window = this.field_230706_i_.func_228018_at_();
        int scale = (int)window.func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(10 * scale), (int)(30 * scale), (int)(this.field_230708_k_ * scale), (int)((this.field_230709_l_ - 60) * scale));
        super.func_230430_a_(mat, mouseX, mouseY, p_render_3_);
        GL11.glDisable((int)3089);
        if (!this.field_230710_m_.isEmpty()) {
            this.drawFakeScrollBar(mat);
        }
        PaintingScreen.func_238472_a_((MatrixStack)mat, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)15, (int)0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawToolTips(mat, mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double mouseScroll) {
        Widget last = (Widget)this.field_230710_m_.get(this.field_230710_m_.size() - 1);
        Widget first = (Widget)this.field_230710_m_.get(0);
        int forsee_bottom_limit = (int)((double)(last.field_230691_m_ + last.func_238483_d_()) + mouseScroll * 16.0);
        int bottom_limit = this.field_230709_l_ - 30 - last.func_238483_d_();
        int forsee_top_limit = (int)((double)first.field_230691_m_ + mouseScroll * 16.0);
        int top_limit = 35;
        if (mouseScroll < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.func_231043_a_(mouseX, mouseY, mouseScroll);
        }
        if (mouseScroll > 0.0 && forsee_top_limit > top_limit) {
            return super.func_231043_a_(mouseX, mouseY, mouseScroll);
        }
        this.move(mouseScroll);
        return super.func_231043_a_(mouseX, mouseY, mouseScroll);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        amountY *= -1.0;
        Widget last = (Widget)this.field_230710_m_.get(this.field_230710_m_.size() - 1);
        Widget first = (Widget)this.field_230710_m_.get(0);
        int forsee_bottom_limit = (int)((double)(last.field_230691_m_ + last.func_238483_d_()) + (amountY /= 2.0) * 16.0);
        int bottom_limit = this.field_230709_l_ - 30 - last.func_238483_d_();
        int forsee_top_limit = (int)((double)first.field_230691_m_ + amountY * 16.0);
        int top_limit = 35;
        if (amountY < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.func_231045_a_(mouseX, mouseY, buttonID, amountX, amountY);
        }
        if (amountY > 0.0 && forsee_top_limit > top_limit) {
            return super.func_231045_a_(mouseX, mouseY, buttonID, amountX, amountY);
        }
        this.move(amountY);
        return super.func_231045_a_(mouseX, mouseY, buttonID, amountX, amountY);
    }

    private void move(double scroll) {
        this.scrollbarscroll = (int)((double)this.scrollbarscroll - scroll * 16.0);
        for (Widget button : this.field_230710_m_) {
            button.field_230691_m_ = (int)((double)button.field_230691_m_ + scroll * 16.0);
        }
    }

    private void drawToolTips(MatrixStack mat, int mouseX, int mouseY) {
        if (!ConfigData.show_painting_size) {
            return;
        }
        for (Widget guiButton : this.field_230710_m_) {
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).func_231047_b_(mouseX, mouseY)) continue;
            StringTextComponent text = new StringTextComponent(button.func_230998_h_() / 16 + "x" + button.func_238483_d_() / 16);
            HoverEvent hover = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)text);
            Style style = Style.field_240709_b_.func_240716_a_(hover);
            this.func_238653_a_(mat, style, this.field_230708_k_ / 2 - this.field_230712_o_.func_78256_a(text.func_150261_e()) - 4, this.field_230709_l_ - 7);
        }
    }

    private void drawFakeScrollBar(MatrixStack mat) {
        int top = ((Widget)this.field_230710_m_.get((int)0)).field_230691_m_;
        float containerSize = this.field_230709_l_ - 60;
        int bot = ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 1))).field_230691_m_ + ((Widget)this.field_230710_m_.get(this.field_230710_m_.size() - 1)).func_238483_d_();
        float totalSize = bot - top + 5;
        float percent = containerSize / totalSize * 100.0f;
        if (percent < 100.0f) {
            float sizeBar = containerSize / 100.0f * percent;
            float relativeScroll = (float)this.scrollbarscroll / 100.0f * percent;
            this.func_238468_a_(mat, this.field_230708_k_ - 10, 30, this.field_230708_k_, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
            this.func_238468_a_(mat, this.field_230708_k_ - 10, 30 + (int)relativeScroll, this.field_230708_k_, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
        }
    }
}

