/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.config;

import io.github.how_bout_no.outvoted.Outvoted;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.api.PatchouliAPI;

@Mod.EventBusSubscriber(modid="outvoted", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OutvotedConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        Outvoted.LOGGER.info(">> Outvoted " + event.getConfig().getType() + " Config Loaded");
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliAPI.get().setConfigFlag("outvoted:infvariant", ((Boolean)OutvotedConfig.COMMON.wildfirevariant.get()).booleanValue());
        }
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliAPI.get().setConfigFlag("outvoted:infvariant", ((Boolean)OutvotedConfig.COMMON.wildfirevariant.get()).booleanValue());
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue creativetab;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("General").push("general");
            this.creativetab = builder.define("Use Custom Creative Tab", true);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> max_enchants;
        public final ForgeConfigSpec.BooleanValue spawnwildfire;
        public final ForgeConfigSpec.BooleanValue spawnhunger;
        public final ForgeConfigSpec.BooleanValue spawnkraken;
        public final ForgeConfigSpec.DoubleValue healthwildfire;
        public final ForgeConfigSpec.DoubleValue healthhunger;
        public final ForgeConfigSpec.DoubleValue healthkraken;
        public final ForgeConfigSpec.IntValue ratewildfire;
        public final ForgeConfigSpec.IntValue ratehunger;
        public final ForgeConfigSpec.IntValue ratekraken;
        public final ForgeConfigSpec.BooleanValue wildfirevariant;
        public final ForgeConfigSpec.BooleanValue restrictwildfire;
        public final ForgeConfigSpec.IntValue fireballcount;
        public final ForgeConfigSpec.DoubleValue offsetangle;
        public final ForgeConfigSpec.DoubleValue maxdepressangle;
        public final ForgeConfigSpec.BooleanValue wildfiredofireballexplosion;
        public final ForgeConfigSpec.DoubleValue wildfirefireballexplosionpower;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Wildfire").push("wildfire");
            this.spawnwildfire = builder.comment("This will affect all Wildfire spawns (natural + spawner)").define("Natural Spawning", true);
            this.ratewildfire = builder.defineInRange("Wildfire Spawn Weight", 1, 1, 100);
            this.healthwildfire = builder.defineInRange("Max Health", 50.0, 1.0, Double.POSITIVE_INFINITY);
            this.wildfirevariant = builder.comment("Blue coloration to *both* Blazes and Wildfires in Soul Sand Valleys. Disabled by default to keep it vanilla. Does not affect Wildfire Helmet textures").define("Biome Variants", false);
            this.restrictwildfire = builder.comment("Restrict Wildfires to spawn only in Nether Wastes or not").define("Restrict Spawning", true);
            builder.comment("Attack Configuration").push("attack");
            this.fireballcount = builder.comment("Amount of fireballs per attack").defineInRange("Fireball Count", 17, 1, 360);
            this.offsetangle = builder.comment("Angle between fireballs in degrees").defineInRange("Fireball Spacing", 4.0, 1.0, 359.0);
            this.maxdepressangle = builder.comment("Maximum downwards angle in degrees wildfire can shoot fireballs. Prevents the Wildfire from shooting straight down").defineInRange("Fireball Max Depression", 50.0, 1.0, 89.0);
            this.wildfiredofireballexplosion = builder.comment("Determines whether Wildfire Fireball should explode").define("Explode", false);
            this.wildfirefireballexplosionpower = builder.comment("Sets Wildfire Fireball explosion radius").defineInRange("Explosion Radius", 0.5, 0.1, 4.0);
            builder.pop();
            builder.pop();
            builder.comment("Great Hunger").push("hunger");
            this.spawnhunger = builder.define("Natural Spawning", true);
            this.ratehunger = builder.defineInRange("Spawn Weight", 5, 1, 100);
            this.healthhunger = builder.defineInRange("Max Health", 20.0, 1.0, Double.POSITIVE_INFINITY);
            this.max_enchants = builder.define("Maximum Stored Enchantments", (Object)5);
            builder.pop();
            builder.comment("Monster of the Ocean Depths").push("kraken");
            this.spawnkraken = builder.define("Natural Spawning", true);
            this.ratekraken = builder.defineInRange("Spawn Weight", 2, 1, 100);
            this.healthkraken = builder.defineInRange("Max Health", 40.0, 1.0, Double.POSITIVE_INFINITY);
            builder.pop();
        }
    }
}

