/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.how_bout_no.outvoted.client.model.WildfireModel;
import io.github.how_bout_no.outvoted.config.OutvotedConfig;
import io.github.how_bout_no.outvoted.entity.WildfireEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class WildfireRenderer
extends GeoEntityRenderer<WildfireEntity> {
    private static final ResourceLocation NETHER = new ResourceLocation("outvoted", "textures/entity/wildfire.png");
    private static final ResourceLocation SOUL = new ResourceLocation("outvoted", "textures/entity/wildfire_soul.png");

    public WildfireRenderer(EntityRendererManager renderManager) {
        super(renderManager, (AnimatedGeoModel)new WildfireModel());
    }

    public RenderType getRenderType(WildfireEntity animatable, float partialTicks, MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228644_e_((ResourceLocation)this.getEntityTexture(animatable));
    }

    protected int getBlockLight(WildfireEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public ResourceLocation getEntityTexture(WildfireEntity entity) {
        if (entity.getVariant() == 0 || !((Boolean)OutvotedConfig.COMMON.wildfirevariant.get()).booleanValue()) {
            return NETHER;
        }
        return SOUL;
    }
}

