/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.core.data;

import com.sammy.omnis.OmnisHelper;
import com.sammy.omnis.core.registry.SoundRegistry;
import com.sammy.omnis.core.registry.block.BlockRegistry;
import com.sammy.omnis.core.registry.effects.EffectRegistry;
import com.sammy.omnis.core.registry.item.EnchantmentRegistry;
import com.sammy.omnis.core.registry.item.ItemRegistry;
import com.sammy.omnis.core.registry.misc.AttributeRegistry;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraftforge.common.data.LanguageProvider;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(DataGenerator gen) {
        super(gen, "omnis", "en_us");
    }

    protected void addTranslations() {
        HashSet blocks = new HashSet(BlockRegistry.BLOCKS.getEntries());
        HashSet items = new HashSet(ItemRegistry.ITEMS.getEntries());
        HashSet sounds = new HashSet(SoundRegistry.SOUNDS.getEntries());
        HashSet enchantments = new HashSet(EnchantmentRegistry.ENCHANTMENTS.getEntries());
        HashSet effects = new HashSet(EffectRegistry.EFFECTS.getEntries());
        HashSet attributes = new HashSet(AttributeRegistry.ATTRIBUTES.getEntries());
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem);
        OmnisHelper.takeAll(blocks, i -> i.get() instanceof WallTorchBlock);
        blocks.forEach(b -> {
            String name = ((Block)b.get()).func_149739_a().replaceFirst("block.omnis.", "");
            name = OmnisHelper.toTitleCase(this.specialBlockNameChanges(name), "_");
            this.add(((Block)b.get()).func_149739_a(), name);
        });
        items.forEach(i -> {
            if (!(i.get() instanceof BlockItem)) {
                String name = ((Item)i.get()).func_77658_a().replaceFirst("item.omnis.", "");
                name = OmnisHelper.toTitleCase(this.specialBlockNameChanges(name), "_");
                this.add(((Item)i.get()).func_77658_a(), name);
            }
        });
        sounds.forEach(s -> {
            String name = OmnisHelper.toTitleCase(s.getId().func_110623_a(), "_");
            this.add("omnis.subtitle." + s.getId().func_110623_a(), name);
        });
        enchantments.forEach(e -> {
            String name = OmnisHelper.toTitleCase(e.getId().func_110623_a(), "_");
            this.add(((Enchantment)e.get()).func_77320_a(), name);
        });
        effects.forEach(e -> {
            String name = OmnisHelper.toTitleCase(e.getId().func_110623_a(), "_");
            this.add("effect.omnis." + ((Effect)e.get()).getRegistryName().func_110623_a(), name);
        });
        attributes.forEach(a -> {
            String name = OmnisHelper.toTitleCase(a.getId().func_110623_a(), "_");
            this.add("attribute.name.omnis." + ((Attribute)a.get()).getRegistryName().func_110623_a(), name);
        });
        this.addTooltip("ravage", "Ravage");
        this.addTooltip("ravage_detailed", "Staggers and stuns enemies when attacking");
        this.addTooltip("arcane", "Arcane");
        this.addTooltip("arcane_detailed", "Deals both magic and physical damage with each swing");
        this.addTooltip("staggering", "Staggering");
        this.addTooltip("staggering_detailed", "Staggers healthy enemies\nStaggered enemies deal less damage and have decreased armor");
        this.addTooltip("stunning", "Stunning");
        this.addTooltip("stunning_detailed", "Stuns healthy enemies\nStunned enemies move slower and have decreased range");
        this.addTooltip("crushing", "Crushing");
        this.addTooltip("crushing_detailed", "Deals more damage to healthy enemies");
        this.addTooltip("sweeping", "Sweeping");
        this.addTooltip("sweeping_detailed", "Every hit causes a strong sweep attack");
        this.addTooltip("outlying", "Outlying");
        this.addTooltip("outlying_detailed", "Deals more damage to faraway enemies");
        this.addTooltip("curative", "Curative");
        this.addTooltip("curative_detailed", "Beneficial potion effects last longer, harmful effects are shorter.");
        this.addPotion("magic_proficiency", "Magic Proficiency");
        this.add("itemGroup.omnis", "Omnis");
    }

    public String func_200397_b() {
        return "Lang Entries";
    }

    public void addTooltip(String identifier, String tooltip) {
        this.add("omnis.tooltip." + identifier, tooltip);
    }

    public void addPotion(String identifier, String name) {
        this.add("item.minecraft.potion.effect." + identifier, "Potion of " + name);
        this.add("item.minecraft.potion.effect.long_" + identifier, "Potion of " + name);
        this.add("item.minecraft.potion.effect.strong_" + identifier, "Potion of " + name);
        this.add("item.minecraft.splash_potion.effect." + identifier, "Splash Potion of " + name);
        this.add("item.minecraft.splash_potion.effect.long_" + identifier, "Splash Potion of " + name);
        this.add("item.minecraft.splash_potion.effect.strong_" + identifier, "Splash Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect." + identifier, "Lingering Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect.long_" + identifier, "Lingering Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect.strong_" + identifier, "Lingering Potion of " + name);
        this.add("item.minecraft.tipped_arrow.effect." + identifier, "Arrow of " + name);
        this.add("item.minecraft.tipped_arrow.effect.long_" + identifier, "Arrow of " + name);
        this.add("item.minecraft.tipped_arrow.effect.strong_" + identifier, "Arrow of " + name);
    }

    public String specialBlockNameChanges(String name) {
        if (!name.endsWith("_bricks") && name.contains("bricks")) {
            name = name.replaceFirst("bricks", "brick");
        }
        if ((name.contains("_fence") || name.contains("_button")) && name.contains("planks")) {
            name = name.replaceFirst("_planks", "");
        }
        return name;
    }
}

