/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.core.data;

import com.sammy.omnis.OmnisHelper;
import com.sammy.omnis.common.items.gear.ModCombatItem;
import com.sammy.omnis.core.registry.item.ItemRegistry;
import java.util.HashSet;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");

    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "omnis", existingFileHelper);
    }

    protected void registerModels() {
        HashSet items = new HashSet(ItemRegistry.ITEMS.getEntries());
        items.remove(ItemRegistry.VEXWART);
        this.generatedItem(ItemRegistry.VEXWART);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof WallBlock).forEach(this::wallBlockItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof FenceBlock).forEach(this::fenceBlockItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof DoorBlock).forEach(this::generatedItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof TrapDoorBlock).forEach(this::trapdoorBlockItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof PressurePlateBlock).forEach(this::pressurePlateBlockItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof AbstractButtonBlock).forEach(this::buttonBlockItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof BushBlock && !(((BlockItem)i.get()).func_179223_d() instanceof DoublePlantBlock)).forEach(this::blockGeneratedItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof DoublePlantBlock).forEach(this::generatedItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof LanternBlock).forEach(this::generatedItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof TorchBlock).forEach(this::generatedItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem).forEach(this::blockItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof ToolItem).forEach(this::handheldItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof ModCombatItem).forEach(this::handheldItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof SwordItem).forEach(this::handheldItem);
        OmnisHelper.takeAll(items, i -> i.get() instanceof BowItem).forEach(this::handheldItem);
        items.forEach(this::generatedItem);
    }

    private void handheldItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", OmnisHelper.prefix("item/" + name));
    }

    private void generatedItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", OmnisHelper.prefix("item/" + name));
    }

    private void blockGeneratedItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", OmnisHelper.prefix("block/" + name));
    }

    private void essencePipeItem(RegistryObject<Item> i) {
        ((ItemModelBuilder)this.getBuilder("spirit_pipe")).parent((ModelFile)new ModelFile.UncheckedModelFile(OmnisHelper.prefix("block/spirit_pipe_core")));
    }

    private void blockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(OmnisHelper.prefix("block/" + name)));
    }

    private void trapdoorBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(OmnisHelper.prefix("block/" + name + "_bottom")));
    }

    private void fenceBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceInventory(name, OmnisHelper.prefix("block/" + baseName));
    }

    private void wallBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.wallInventory(name, OmnisHelper.prefix("block/" + baseName));
    }

    private void pressurePlateBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(OmnisHelper.prefix("block/" + name + "_up")));
    }

    private void buttonBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(OmnisHelper.prefix("block/" + name + "_inventory")));
    }

    public String func_200397_b() {
        return "Item Models";
    }
}

