/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.core.data;

import com.sammy.omnis.OmnisHelper;
import com.sammy.omnis.common.blocks.VexwartBlock;
import com.sammy.omnis.common.blocks.surge.SurgeBlock;
import com.sammy.omnis.common.blocks.surge.SurgeJetBlock;
import com.sammy.omnis.core.registry.block.BlockRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "omnis", exFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Block States";
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(BlockRegistry.BLOCKS.getEntries());
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof SurgeJetBlock).forEach(this::surgeJetBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof SurgeBlock).forEach(this::surgeBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof VexwartBlock).forEach(this::vexwartBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(this::grassBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof StairsBlock).forEach(this::stairsBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof RotatedPillarBlock).forEach(this::logBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof WallBlock).forEach(this::wallBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof FenceBlock).forEach(this::fenceBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof FenceGateBlock).forEach(this::fenceGateBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(this::doorBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof TrapDoorBlock).forEach(this::trapdoorBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof PressurePlateBlock).forEach(this::pressurePlateBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof AbstractButtonBlock).forEach(this::buttonBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(this::tallPlantBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(this::plantBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof LanternBlock).forEach(this::lanternBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof WallTorchBlock).forEach(this::wallTorchBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof TorchBlock).forEach(this::torchBlock);
        Collection<RegistryObject> slabs = OmnisHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock);
        blocks.forEach(this::basicBlock);
        slabs.forEach(this::slabBlock);
    }

    public void basicBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    public void surgeJetBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder empty = this.models().withExistingParent(name, new ResourceLocation("block/air"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$surgeJetBlock$19((ModelFile)empty, arg_0));
    }

    public void surgeBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder model = this.models().cubeBottomTop(name, OmnisHelper.prefix("block/" + name + "_side"), OmnisHelper.prefix("block/surge_block_bottom"), OmnisHelper.prefix("block/" + name + "_top"));
        this.directionalBlock((Block)blockRegistryObject.get(), (ModelFile)model);
    }

    public void emptyBlock(RegistryObject<Block> blockRegistryObject) {
        ModelFile.ExistingModelFile empty = this.models().getExistingFile(new ResourceLocation("block/air"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$emptyBlock$20((ModelFile)empty, arg_0));
    }

    public void trapdoorBlock(RegistryObject<Block> blockRegistryObject) {
        this.trapdoorBlock((TrapDoorBlock)blockRegistryObject.get(), this.blockTexture((Block)blockRegistryObject.get()), true);
    }

    public void torchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), OmnisHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$torchBlock$21((ModelFile)torch, arg_0));
    }

    public void wallTorchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), OmnisHelper.prefix("block/" + name.substring(5)));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)torch).rotationY(270).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)torch).rotationY(180).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)torch).rotationY(90).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)torch).addModel();
    }

    public void grassBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder file = this.models().cubeBottomTop(name, OmnisHelper.prefix("block/" + name + "_side"), new ResourceLocation("block/dirt"), OmnisHelper.prefix("block/" + name + "_top"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().modelForState().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).addModel();
    }

    public void doorBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        this.doorBlock((DoorBlock)blockRegistryObject.get(), OmnisHelper.prefix("block/" + name + "_bottom"), OmnisHelper.prefix("block/" + name + "_top"));
    }

    public void fenceGateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 11);
        this.fenceGateBlock((FenceGateBlock)blockRegistryObject.get(), OmnisHelper.prefix("block/" + baseName));
    }

    public void fenceBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceBlock((FenceBlock)blockRegistryObject.get(), OmnisHelper.prefix("block/" + baseName));
    }

    public void wallBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.wallBlock((WallBlock)blockRegistryObject.get(), OmnisHelper.prefix("block/" + baseName));
    }

    public void stairsBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock((StairsBlock)blockRegistryObject.get(), OmnisHelper.prefix("block/" + baseName));
    }

    public void pressurePlateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 15);
        ModelBuilder pressurePlateDown = ((BlockModelBuilder)this.models().withExistingParent(name + "_down", new ResourceLocation("block/pressure_plate_down"))).texture("texture", OmnisHelper.prefix("block/" + baseName));
        ModelBuilder pressurePlateUp = ((BlockModelBuilder)this.models().withExistingParent(name + "_up", new ResourceLocation("block/pressure_plate_up"))).texture("texture", OmnisHelper.prefix("block/" + baseName));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)pressurePlateDown).addModel()).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)pressurePlateUp).addModel();
    }

    public void lanternBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder lantern = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/template_lantern"))).texture("lantern", OmnisHelper.prefix("block/" + name));
        ModelBuilder hangingLantern = ((BlockModelBuilder)this.models().withExistingParent(name + "_hanging", new ResourceLocation("block/template_hanging_lantern"))).texture("lantern", OmnisHelper.prefix("block/" + name));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)hangingLantern).addModel()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)lantern).addModel();
    }

    public void buttonBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 7);
        ModelBuilder buttom = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/button"))).texture("texture", OmnisHelper.prefix("block/" + baseName));
        ModelBuilder buttonPressed = ((BlockModelBuilder)this.models().withExistingParent(name + "_pressed", new ResourceLocation("block/button_pressed"))).texture("texture", OmnisHelper.prefix("block/" + baseName));
        Function<BlockState, ModelFile> modelFunc = arg_0 -> ModBlockStateProvider.lambda$buttonBlock$22((ModelFile)buttom, arg_0);
        Function<BlockState, ModelFile> pressedModelFunc = arg_0 -> ModBlockStateProvider.lambda$buttonBlock$23((ModelFile)buttonPressed, arg_0);
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((Boolean)s.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? (ModelFile)pressedModelFunc.apply((BlockState)s) : (ModelFile)modelFunc.apply((BlockState)s)).uvLock(((AttachFace)s.func_177229_b((Property)BlockStateProperties.field_208158_K)).equals((Object)AttachFace.WALL)).rotationX(((AttachFace)s.func_177229_b((Property)BlockStateProperties.field_208158_K)).ordinal() * 90).rotationY(((int)((Direction)s.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180 + (s.func_177229_b((Property)BlockStateProperties.field_208158_K) == AttachFace.CEILING ? 180 : 0)) % 360).build());
        ((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", new ResourceLocation("block/button_inventory"))).texture("texture", OmnisHelper.prefix("block/" + baseName));
    }

    public void vexwartBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder stage0 = ((BlockModelBuilder)this.models().withExistingParent(name + "_0", new ResourceLocation("block/crop"))).texture("crop", OmnisHelper.prefix("block/" + name + "_0"));
        ModelBuilder stage1 = ((BlockModelBuilder)this.models().withExistingParent(name + "_1", new ResourceLocation("block/crop"))).texture("crop", OmnisHelper.prefix("block/" + name + "_1"));
        ModelBuilder stage2 = ((BlockModelBuilder)this.models().withExistingParent(name + "_2", new ResourceLocation("block/crop"))).texture("crop", OmnisHelper.prefix("block/" + name + "_2"));
        ModelBuilder stage3 = ((BlockModelBuilder)this.models().withExistingParent(name + "_3", new ResourceLocation("block/crop"))).texture("crop", OmnisHelper.prefix("block/" + name + "_3"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)VexwartBlock.field_176486_a, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)stage0).addModel()).partialState().with((Property)VexwartBlock.field_176486_a, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)stage1).addModel()).partialState().with((Property)VexwartBlock.field_176486_a, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)stage2).addModel()).partialState().with((Property)VexwartBlock.field_176486_a, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)stage3).addModel();
    }

    public void tallPlantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder bottom = ((BlockModelBuilder)this.models().withExistingParent(name + "_bottom", new ResourceLocation("block/cross"))).texture("cross", OmnisHelper.prefix("block/" + name + "_bottom"));
        ModelBuilder top = ((BlockModelBuilder)this.models().withExistingParent(name + "_top", new ResourceLocation("block/cross"))).texture("cross", OmnisHelper.prefix("block/" + name + "_top"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)bottom).addModel()).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)top).addModel();
    }

    public void plantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder cross = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/cross"))).texture("cross", OmnisHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$plantBlock$25((ModelFile)cross, arg_0));
    }

    public void slabBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), OmnisHelper.prefix(baseName), OmnisHelper.prefix("block/" + baseName));
    }

    public void logBlock(RegistryObject<Block> blockRegistryObject) {
        this.logBlock((RotatedPillarBlock)blockRegistryObject.get());
    }

    public void woodBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name + "_log";
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), OmnisHelper.prefix("block/" + baseName), OmnisHelper.prefix("block/" + baseName));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$plantBlock$25(ModelFile cross, BlockState s) {
        return ConfiguredModel.builder().modelFile(cross).build();
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$23(ModelFile buttonPressed, BlockState $) {
        return buttonPressed;
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$22(ModelFile buttom, BlockState $) {
        return buttom;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$21(ModelFile torch, BlockState s) {
        return ConfiguredModel.builder().modelFile(torch).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$emptyBlock$20(ModelFile empty, BlockState s) {
        return ConfiguredModel.builder().modelFile(empty).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$surgeJetBlock$19(ModelFile empty, BlockState s) {
        return ConfiguredModel.builder().modelFile(empty).build();
    }
}

