/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.common.items.equipment.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.sammy.omnis.client.model.ModelRavagedMetalArmor;
import com.sammy.omnis.core.registry.item.ArmorTierRegistry;
import com.sammy.omnis.core.registry.misc.AttributeRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.LazyValue;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class HauntedSteelArmorItem
extends ArmorItem {
    private LazyValue<Object> model;

    public HauntedSteelArmorItem(EquipmentSlotType slot, Item.Properties builder) {
        super((IArmorMaterial)ArmorTierRegistry.ArmorTierEnum.HAUNTED_ARMOR, slot, builder);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.model = (LazyValue)DistExecutor.runForDist(() -> () -> new LazyValue(() -> new ModelRavagedMetalArmor(slot)), () -> () -> null);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
        UUID uuid = field_185084_n[slot.func_188454_b()];
        attributeBuilder.putAll(this.field_234656_m_);
        attributeBuilder.put((Object)AttributeRegistry.MAGIC_RESISTANCE.get(), (Object)new AttributeModifier(uuid, "Armor magic resistance", 1.0, AttributeModifier.Operation.ADDITION));
        return slot == this.field_77881_a ? attributeBuilder.build() : ImmutableMultimap.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A original) {
        return (A)((BipedModel)this.model.func_179281_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "omnis:textures/armor/haunted_armor.png";
    }
}

