/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis;

import com.sammy.omnis.core.registry.block.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class OmnisHelper {
    public static boolean areWeOnClient(World world) {
        return world.field_72995_K;
    }

    public static boolean areWeOnServer(World world) {
        return !OmnisHelper.areWeOnClient(world);
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation("omnis", path);
    }

    public static <T> ArrayList<T> toArrayList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    public static <T> ArrayList<T> toArrayList(Stream<T> items) {
        return items.collect(Collectors.toCollection(ArrayList::new));
    }

    public static void updateState(World worldIn, BlockPos pos) {
        OmnisHelper.updateState(worldIn.func_180495_p(pos), worldIn, pos);
    }

    public static void updateState(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_184138_a(pos, state, state, 2);
    }

    public static void updateAndNotifyState(World worldIn, BlockPos pos) {
        OmnisHelper.updateAndNotifyState(worldIn.func_180495_p(pos), worldIn, pos);
    }

    public static void updateAndNotifyState(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_184138_a(pos, state, state, 2);
        state.func_235734_a_((IWorld)worldIn, pos, 2);
    }

    public static CompoundNBT writeBlockPos(CompoundNBT compoundNBT, BlockPos pos) {
        compoundNBT.func_74768_a("X", pos.func_177958_n());
        compoundNBT.func_74768_a("Y", pos.func_177956_o());
        compoundNBT.func_74768_a("Z", pos.func_177952_p());
        return compoundNBT;
    }

    public static CompoundNBT writeBlockPos(CompoundNBT compoundNBT, BlockPos pos, String extra) {
        compoundNBT.func_74768_a(extra + "X", pos.func_177958_n());
        compoundNBT.func_74768_a(extra + "Y", pos.func_177956_o());
        compoundNBT.func_74768_a(extra + "Z", pos.func_177952_p());
        return compoundNBT;
    }

    public static BlockPos readBlockPos(CompoundNBT tag) {
        return new BlockPos(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
    }

    public static BlockPos readBlockPos(CompoundNBT tag, String extra) {
        return new BlockPos(tag.func_74762_e(extra + "X"), tag.func_74762_e(extra + "Y"), tag.func_74762_e(extra + "Z"));
    }

    public static Vector3d randPos(BlockPos pos, Random rand, double min, double max) {
        double x = MathHelper.func_82716_a((Random)rand, (double)min, (double)max) + (double)pos.func_177958_n();
        double y = MathHelper.func_82716_a((Random)rand, (double)min, (double)max) + (double)pos.func_177956_o();
        double z = MathHelper.func_82716_a((Random)rand, (double)min, (double)max) + (double)pos.func_177952_p();
        return new Vector3d(x, y, z);
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Collection<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            return Collections.emptyList();
        }
        if (!src.removeAll(ret)) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static Block[] getModBlocks(Class<?> ... blockClasses) {
        Collection blocks = BlockRegistry.BLOCKS.getEntries();
        ArrayList<IForgeRegistryEntry> matchingBlocks = new ArrayList<IForgeRegistryEntry>();
        for (RegistryObject registryObject : blocks) {
            if (!Arrays.stream(blockClasses).anyMatch(b -> b.isInstance(registryObject.get()))) continue;
            matchingBlocks.add(registryObject.get());
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static boolean hasCurioEquipped(LivingEntity entity, RegistryObject<Item> curio) {
        return CuriosApi.getCuriosHelper().findEquippedCurio((Item)curio.get(), entity).isPresent();
    }

    @Nonnull
    public static Optional<ImmutableTriple<String, Integer, ItemStack>> findCosmeticCurio(Predicate<ItemStack> filter, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(handler -> {
            Map curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ItemStack stack;
                int i;
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHelper = stacksHandler.getCosmeticStacks();
                for (i = 0; i < stackHandler.getSlots(); ++i) {
                    stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
                for (i = 0; i < cosmeticStackHelper.getSlots(); ++i) {
                    stack = cosmeticStackHelper.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }
}

