/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public final class IdMapUniforms {
    private IdMapUniforms() {
    }

    public static void addIdMapUniforms(DynamicUniformHolder uniforms, IdMap idMap) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "heldItemId", new HeldItemSupplier(Hand.MAIN_HAND, idMap.getItemIdMap())).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldItemId2", new HeldItemSupplier(Hand.OFF_HAND, idMap.getItemIdMap()));
        uniforms.uniform1i("entityId", CapturedRenderingState.INSTANCE::getCurrentRenderedEntity, CapturedRenderingState.INSTANCE.getEntityIdNotifier());
        uniforms.uniform1i("blockEntityId", CapturedRenderingState.INSTANCE::getCurrentRenderedBlockEntity, CapturedRenderingState.INSTANCE.getBlockEntityIdNotifier());
    }

    private static class HeldItemSupplier
    implements IntSupplier {
        private final Hand hand;
        private final Object2IntFunction<NamespacedId> itemIdMap;

        HeldItemSupplier(Hand hand, Object2IntFunction<NamespacedId> itemIdMap) {
            this.hand = hand;
            this.itemIdMap = itemIdMap;
        }

        @Override
        public int getAsInt() {
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return -1;
            }
            ItemStack heldStack = Minecraft.func_71410_x().field_71439_g.func_184586_b(this.hand);
            ResourceLocation heldItemId = Registry.field_212630_s.func_177774_c((Object)heldStack.func_77973_b());
            return this.itemIdMap.applyAsInt((Object)new NamespacedId(heldItemId.func_110624_b(), heldItemId.func_110623_a()));
        }
    }
}

