/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.rendertarget.DepthTexture;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;

public class RenderTargets {
    private final RenderTarget[] targets;
    private int currentDepthTexture;
    private DepthBufferFormat currentDepthFormat;
    private final DepthTexture noTranslucents;
    private final DepthTexture noHand;
    private final GlFramebuffer depthSourceFb;
    private final GlFramebuffer noTranslucentsDestFb;
    private final GlFramebuffer noHandDestFb;
    private DepthCopyStrategy copyStrategy;
    private final List<GlFramebuffer> ownedFramebuffers;
    private int cachedWidth;
    private int cachedHeight;
    private boolean fullClearRequired;
    private boolean translucentDepthDirty;
    private boolean handDepthDirty;
    private int cachedDepthBufferVersion;

    public RenderTargets(int width, int height, int depthTexture, int depthBufferVersion, DepthBufferFormat depthFormat, Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> renderTargets) {
        this.targets = new RenderTarget[renderTargets.size()];
        renderTargets.forEach((index, settings) -> {
            this.targets[index.intValue()] = RenderTarget.builder().setDimensions(width, height).setInternalFormat(settings.getInternalFormat()).setPixelFormat(settings.getInternalFormat().getPixelFormat()).build();
        });
        this.currentDepthTexture = depthTexture;
        this.currentDepthFormat = depthFormat;
        this.copyStrategy = DepthCopyStrategy.fastest(this.currentDepthFormat.isCombinedStencil());
        this.cachedWidth = width;
        this.cachedHeight = height;
        this.cachedDepthBufferVersion = depthBufferVersion;
        this.ownedFramebuffers = new ArrayList<GlFramebuffer>();
        this.fullClearRequired = true;
        this.depthSourceFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucents = new DepthTexture(width, height, this.currentDepthFormat);
        this.noHand = new DepthTexture(width, height, this.currentDepthFormat);
        this.noTranslucentsDestFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucentsDestFb.addDepthAttachment(this.noTranslucents.getTextureId());
        this.noHandDestFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noHandDestFb.addDepthAttachment(this.noHand.getTextureId());
        this.translucentDepthDirty = true;
        this.handDepthDirty = true;
    }

    public void destroy() {
        for (GlFramebuffer owned : this.ownedFramebuffers) {
            owned.destroy();
        }
        for (RenderTarget target : this.targets) {
            target.destroy();
        }
        this.noTranslucents.destroy();
        this.noHand.destroy();
    }

    public int getRenderTargetCount() {
        return this.targets.length;
    }

    public RenderTarget get(int index) {
        return this.targets[index];
    }

    public int getDepthTexture() {
        return this.currentDepthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public DepthTexture getDepthTextureNoHand() {
        return this.noHand;
    }

    public void resizeIfNeeded(int newDepthBufferVersion, int newDepthTextureId, int newWidth, int newHeight, DepthBufferFormat newDepthFormat) {
        boolean depthFormatChanged;
        boolean recreateDepth = false;
        if (this.cachedDepthBufferVersion != newDepthBufferVersion) {
            recreateDepth = true;
            this.currentDepthTexture = newDepthTextureId;
            this.cachedDepthBufferVersion = newDepthBufferVersion;
        }
        boolean sizeChanged = newWidth != this.cachedWidth || newHeight != this.cachedHeight;
        boolean bl = depthFormatChanged = newDepthFormat != this.currentDepthFormat;
        if (depthFormatChanged) {
            this.currentDepthFormat = newDepthFormat;
            this.copyStrategy = DepthCopyStrategy.fastest(this.currentDepthFormat.isCombinedStencil());
        }
        if (recreateDepth) {
            for (GlFramebuffer framebuffer : this.ownedFramebuffers) {
                if (framebuffer == this.noHandDestFb || framebuffer == this.noTranslucentsDestFb) continue;
                framebuffer.addDepthAttachment(newDepthTextureId);
            }
        }
        if (depthFormatChanged || sizeChanged) {
            this.noTranslucents.resize(newWidth, newHeight, newDepthFormat);
            this.noHand.resize(newWidth, newHeight, newDepthFormat);
            this.translucentDepthDirty = true;
            this.handDepthDirty = true;
        }
        if (sizeChanged) {
            this.cachedWidth = newWidth;
            this.cachedHeight = newHeight;
            for (RenderTarget target : this.targets) {
                target.resize(newWidth, newHeight);
            }
            this.fullClearRequired = true;
        }
    }

    public void copyPreTranslucentDepth() {
        if (this.translucentDepthDirty) {
            this.translucentDepthDirty = false;
            RenderSystem.bindTexture((int)this.noTranslucents.getTextureId());
            this.depthSourceFb.bindAsReadBuffer();
            IrisRenderSystem.copyTexImage2D(3553, 0, this.currentDepthFormat.getGlInternalFormat(), 0, 0, this.cachedWidth, this.cachedHeight, 0);
        } else {
            this.copyStrategy.copy(this.depthSourceFb, this.getDepthTexture(), this.noTranslucentsDestFb, this.noTranslucents.getTextureId(), this.getCurrentWidth(), this.getCurrentHeight());
        }
    }

    public void copyPreHandDepth() {
        if (this.handDepthDirty) {
            this.handDepthDirty = false;
            RenderSystem.bindTexture((int)this.noHand.getTextureId());
            this.depthSourceFb.bindAsReadBuffer();
            IrisRenderSystem.copyTexImage2D(3553, 0, this.currentDepthFormat.getGlInternalFormat(), 0, 0, this.cachedWidth, this.cachedHeight, 0);
        } else {
            this.copyStrategy.copy(this.depthSourceFb, this.getDepthTexture(), this.noHandDestFb, this.noHand.getTextureId(), this.getCurrentWidth(), this.getCurrentHeight());
        }
    }

    public boolean isFullClearRequired() {
        return this.fullClearRequired;
    }

    public void onFullClear() {
        this.fullClearRequired = false;
    }

    public GlFramebuffer createFramebufferWritingToMain(int[] drawBuffers) {
        return this.createFullFramebuffer(false, drawBuffers);
    }

    public GlFramebuffer createFramebufferWritingToAlt(int[] drawBuffers) {
        return this.createFullFramebuffer(true, drawBuffers);
    }

    private ImmutableSet<Integer> invert(ImmutableSet<Integer> base, int[] relevant) {
        ImmutableSet.Builder inverted = ImmutableSet.builder();
        for (int i : relevant) {
            if (base.contains((Object)i)) continue;
            inverted.add((Object)i);
        }
        return inverted.build();
    }

    private GlFramebuffer createEmptyFramebuffer() {
        GlFramebuffer framebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(framebuffer);
        framebuffer.addDepthAttachment(this.currentDepthTexture);
        framebuffer.addColorAttachment(0, this.get(0).getMainTexture());
        framebuffer.noDrawBuffers();
        return framebuffer;
    }

    public GlFramebuffer createGbufferFramebuffer(ImmutableSet<Integer> stageWritesToAlt, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> stageWritesToMain = this.invert(stageWritesToAlt, drawBuffers);
        GlFramebuffer framebuffer = this.createColorFramebuffer(stageWritesToMain, drawBuffers);
        framebuffer.addDepthAttachment(this.currentDepthTexture);
        return framebuffer;
    }

    private GlFramebuffer createFullFramebuffer(boolean clearsAlt, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> stageWritesToMain = ImmutableSet.of();
        if (!clearsAlt) {
            stageWritesToMain = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), drawBuffers);
        }
        return this.createColorFramebufferWithDepth(stageWritesToMain, drawBuffers);
    }

    public GlFramebuffer createColorFramebufferWithDepth(ImmutableSet<Integer> stageWritesToMain, int[] drawBuffers) {
        GlFramebuffer framebuffer = this.createColorFramebuffer(stageWritesToMain, drawBuffers);
        framebuffer.addDepthAttachment(this.currentDepthTexture);
        return framebuffer;
    }

    public GlFramebuffer createColorFramebuffer(ImmutableSet<Integer> stageWritesToMain, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        GlFramebuffer framebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(framebuffer);
        int[] actualDrawBuffers = new int[drawBuffers.length];
        for (int i = 0; i < drawBuffers.length; ++i) {
            actualDrawBuffers[i] = i;
            if (drawBuffers[i] >= this.getRenderTargetCount()) {
                throw new IllegalStateException("Render target with index " + drawBuffers[i] + " is not supported, only " + this.getRenderTargetCount() + " render targets are supported.");
            }
            RenderTarget target = this.get(drawBuffers[i]);
            int textureId = stageWritesToMain.contains((Object)drawBuffers[i]) ? target.getMainTexture() : target.getAltTexture();
            framebuffer.addColorAttachment(i, textureId);
        }
        framebuffer.drawBuffers(actualDrawBuffers);
        framebuffer.readBuffer(0);
        if (!framebuffer.isComplete()) {
            throw new IllegalStateException("Unexpected error while creating framebuffer");
        }
        return framebuffer;
    }

    public int getCurrentWidth() {
        return this.cachedWidth;
    }

    public int getCurrentHeight() {
        return this.cachedHeight;
    }
}

