/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.pipeline.patcher.CompositeDepthTransformer;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.jetbrains.annotations.Nullable;

public class FinalPassRenderer {
    private final RenderTargets renderTargets;
    @Nullable
    private final Pass finalPass;
    private final ImmutableList<SwapPass> swapPasses;
    private final GlFramebuffer baseline;
    private final GlFramebuffer colorHolder;
    private int lastColorTextureId;
    private int lastColorTextureVersion;
    private final IntSupplier noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final Object2ObjectMap<String, IntSupplier> customTextureIds;

    public FinalPassRenderer(ProgramSet pack, RenderTargets renderTargets, IntSupplier noiseTexture, FrameUpdateNotifier updateNotifier, ImmutableSet<Integer> flippedBuffers, CenterDepthSampler centerDepthSampler, Supplier<ShadowRenderTargets> shadowTargetsSupplier, Object2ObjectMap<String, IntSupplier> customTextureIds, ImmutableSet<Integer> flippedAtLeastOnce) {
        this.updateNotifier = updateNotifier;
        this.centerDepthSampler = centerDepthSampler;
        this.customTextureIds = customTextureIds;
        PackRenderTargetDirectives renderTargetDirectives = pack.getPackDirectives().getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> renderTargetSettings = renderTargetDirectives.getRenderTargetSettings();
        this.noiseTexture = noiseTexture;
        this.renderTargets = renderTargets;
        this.finalPass = pack.getCompositeFinal().map(source -> {
            Pass pass = new Pass();
            ProgramDirectives directives = source.getDirectives();
            pass.program = this.createProgram((ProgramSource)source, flippedBuffers, flippedAtLeastOnce, shadowTargetsSupplier);
            pass.stageReadsFromAlt = flippedBuffers;
            pass.mipmappedBuffers = directives.getMipmappedBuffers();
            return pass;
        }).orElse(null);
        IntList buffersToBeCleared = pack.getPackDirectives().getRenderTargetDirectives().getBuffersToBeCleared();
        this.baseline = renderTargets.createGbufferFramebuffer(flippedBuffers, new int[]{0});
        this.colorHolder = new GlFramebuffer();
        this.lastColorTextureId = Minecraft.func_71410_x().func_147110_a().func_242996_f();
        this.lastColorTextureVersion = ((Blaze3dRenderTargetExt)Minecraft.func_71410_x().func_147110_a()).iris$getColorBufferVersion();
        this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        ImmutableList.Builder swapPasses = ImmutableList.builder();
        flippedBuffers.forEach(i -> {
            int target = i;
            if (buffersToBeCleared.contains(target)) {
                return;
            }
            SwapPass swap = new SwapPass();
            swap.from = renderTargets.createFramebufferWritingToAlt(new int[]{target});
            swap.targetTexture = renderTargets.get(target).getMainTexture();
            swapPasses.add((Object)swap);
        });
        this.swapPasses = swapPasses.build();
        GlStateManager.func_227727_h_((int)36008, (int)0);
    }

    public void renderFinalPass() {
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.depthMask((boolean)false);
        Framebuffer main = Minecraft.func_71410_x().func_147110_a();
        int baseWidth = main.field_147622_a;
        int baseHeight = main.field_147620_b;
        if (((Blaze3dRenderTargetExt)main).iris$getColorBufferVersion() != this.lastColorTextureVersion || main.func_242996_f() != this.lastColorTextureId) {
            this.lastColorTextureVersion = ((Blaze3dRenderTargetExt)main).iris$getColorBufferVersion();
            this.lastColorTextureId = main.func_242996_f();
            this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        }
        if (this.finalPass != null) {
            this.colorHolder.bind();
            FullScreenQuadRenderer.INSTANCE.begin();
            if (!this.finalPass.mipmappedBuffers.isEmpty()) {
                RenderSystem.activeTexture((int)33984);
                UnmodifiableIterator unmodifiableIterator = this.finalPass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int index = (Integer)unmodifiableIterator.next();
                    FinalPassRenderer.setupMipmapping(this.renderTargets.get(index), this.finalPass.stageReadsFromAlt.contains((Object)index));
                }
            }
            this.finalPass.program.use();
            FullScreenQuadRenderer.INSTANCE.renderQuad();
            FullScreenQuadRenderer.end();
        } else {
            this.baseline.bindAsReadBuffer();
            RenderSystem.bindTexture((int)main.func_242996_f());
            GlStateManager.func_237509_a_((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)baseWidth, (int)baseHeight);
        }
        RenderSystem.activeTexture((int)33984);
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            FinalPassRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        for (SwapPass swapPass : this.swapPasses) {
            swapPass.from.bind();
            RenderSystem.bindTexture((int)swapPass.targetTexture);
            GlStateManager.func_237509_a_((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)baseWidth, (int)baseHeight);
        }
        main.func_147610_a(true);
        ProgramUniforms.clearActiveUniforms();
        GlStateManager.func_227723_g_((int)0);
        for (int i = 0; i < SamplerLimits.get().getMaxTextureUnits(); ++i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        RenderSystem.activeTexture((int)33984);
    }

    private static void setupMipmapping(RenderTarget target, boolean readFromAlt) {
        RenderSystem.bindTexture((int)(readFromAlt ? target.getAltTexture() : target.getMainTexture()));
        IrisRenderSystem.generateMipmaps(3553);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9987);
    }

    private static void resetRenderTarget(RenderTarget target) {
        RenderSystem.bindTexture((int)target.getMainTexture());
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.bindTexture((int)target.getAltTexture());
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.bindTexture((int)0);
    }

    private Program createProgram(ProgramSource source, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, Supplier<ShadowRenderTargets> shadowTargetsSupplier) {
        ProgramBuilder builder;
        Objects.requireNonNull(source.getVertexSource());
        Objects.requireNonNull(source.getFragmentSource());
        Objects.requireNonNull(flipped);
        try {
            builder = ProgramBuilder.begin(source.getName(), CompositeDepthTransformer.patch(source.getVertexSource().orElse(null)), CompositeDepthTransformer.patch(source.getGeometrySource().orElse(null)), CompositeDepthTransformer.patch(source.getFragmentSource().orElse(null)), IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Shader compilation failed!", e);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
        CommonUniforms.addCommonUniforms(builder, source.getParent().getPack().getIdMap(), source.getParent().getPackDirectives(), this.updateNotifier);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> flipped, this.renderTargets, true);
        IrisImages.addRenderTargetImages(builder, () -> flipped, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, shadowTargetsSupplier.get());
            IrisImages.addShadowColorImages(builder, shadowTargetsSupplier.get());
        }
        builder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth");
        return builder.build();
    }

    public void destroy() {
        if (this.finalPass != null) {
            this.finalPass.destroy();
        }
    }

    private static final class Pass {
        Program program;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;

        private Pass() {
        }

        private void destroy() {
            this.program.destroy();
        }
    }

    private static final class SwapPass {
        GlFramebuffer from;
        int targetTexture;

        private SwapPass() {
        }
    }
}

