/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.patcher;

import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;

public class AttributeShaderTransformer {
    public static String patch(String source, ShaderType type, boolean hasGeometry, InputAvailability inputs) {
        if (source.contains("iris_")) {
            throw new IllegalStateException("Shader is attempting to exploit internal Iris code!");
        }
        StringTransformations transformations = new StringTransformations(source);
        if (!inputs.lightmap) {
            transformations.replaceExact("gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            transformations.replaceExact("gl_MultiTexCoord2", "vec4(240.0, 240.0, 0.0, 1.0)");
        } else {
            transformations.replaceExact("gl_MultiTexCoord1", "gl_MultiTexCoord2");
        }
        if (!inputs.texture) {
            transformations.define("gl_MultiTexCoord0", "vec4(240.0, 240.0, 0.0, 1.0)");
        }
        AttributeShaderTransformer.patchTextureMatrices(transformations, inputs.lightmap);
        if (inputs.overlay) {
            AttributeShaderTransformer.patchOverlayColor(transformations, type, hasGeometry);
        }
        if (transformations.contains("gl_MultiTexCoord3") && !transformations.contains("mc_midTexCoord") && type == ShaderType.VERTEX) {
            transformations.replaceExact("gl_MultiTexCoord3", "mc_midTexCoord");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "attribute vec4 mc_midTexCoord;");
        }
        return transformations.toString();
    }

    private static void patchOverlayColor(StringTransformations transformations, ShaderType type, boolean hasGeometry) {
        if (type == ShaderType.VERTEX) {
            transformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform sampler2D iris_overlay;");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "varying vec4 entityColor;");
            if (transformations.contains("irisMain_overlayColor")) {
                throw new IllegalStateException("Shader already contains \"irisMain_overlayColor\"???");
            }
            transformations.replaceExact("main", "irisMain_overlayColor");
            transformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n\tvec4 overlayColor = texture2D(iris_overlay, (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy);\n\tentityColor = vec4(overlayColor.rgb, 1.0 - overlayColor.a);\n\tentityColor.rgb *= float(entityColor.a != 0.0);\n\n    irisMain_overlayColor();\n}");
        } else if (type == ShaderType.GEOMETRY) {
            transformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "");
            transformations.replaceExact("entityColor", "entityColor[0]");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 entityColorGS;");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec4 entityColor[];");
            if (transformations.contains("irisMain")) {
                throw new IllegalStateException("Shader already contains \"irisMain\"???");
            }
            transformations.replaceExact("main", "irisMain");
            transformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n\t entityColorGS = entityColor[0];\n    irisMain();\n}");
        } else if (type == ShaderType.FRAGMENT) {
            transformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "varying vec4 entityColor;");
            if (hasGeometry) {
                transformations.replaceExact("entityColor", "entityColorGS");
            }
        }
    }

    private static void patchTextureMatrices(StringTransformations transformations, boolean hasLightmap) {
        transformations.replaceExact("gl_TextureMatrix", "iris_TextureMatrix");
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "const float iris_ONE_OVER_256 = 0.00390625;\n");
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "const float iris_ONE_OVER_32 = iris_ONE_OVER_256 * 8;\n");
        if (hasLightmap) {
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_LightmapTextureMatrix = gl_TextureMatrix[2];\n");
        } else {
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_LightmapTextureMatrix =mat4(iris_ONE_OVER_256, 0.0, 0.0, 0.0,     0.0, iris_ONE_OVER_256, 0.0, 0.0,     0.0, 0.0, iris_ONE_OVER_256, 0.0,     iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_256);");
        }
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_TextureMatrix[8] = mat4[8](gl_TextureMatrix[0],iris_LightmapTextureMatrix,mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0));\n");
    }
}

