/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private static final double COS_22_5 = Math.cos(Math.toRadians(22.5));
    private static final double SIN_22_5 = Math.sin(Math.toRadians(22.5));

    private void buildQuad(IVertexBuilder consumer, double x1, double z1, double x2, double z2) {
        consumer.func_225582_a_(x1, -16.0, z1);
        consumer.func_181675_d();
        consumer.func_225582_a_(x1, 16.0, z1);
        consumer.func_181675_d();
        consumer.func_225582_a_(x2, 16.0, z2);
        consumer.func_181675_d();
        consumer.func_225582_a_(x2, -16.0, z2);
        consumer.func_181675_d();
    }

    private void buildHalf(IVertexBuilder consumer, double adjacent, double opposite, boolean invert) {
        if (invert) {
            adjacent = -adjacent;
            opposite = -opposite;
        }
        this.buildQuad(consumer, adjacent, -opposite, opposite, -adjacent);
        this.buildQuad(consumer, adjacent, opposite, adjacent, -opposite);
        this.buildQuad(consumer, opposite, adjacent, adjacent, opposite);
        this.buildQuad(consumer, -opposite, adjacent, opposite, adjacent);
    }

    private void buildOctagonalPrism(IVertexBuilder consumer, double adjacent, double opposite) {
        this.buildHalf(consumer, adjacent, opposite, false);
        this.buildHalf(consumer, adjacent, opposite, true);
    }

    private void buildRegularOctagonalPrism(IVertexBuilder consumer, double radius) {
        this.buildOctagonalPrism(consumer, radius * COS_22_5, radius * SIN_22_5);
    }

    private void buildBottomPlane(IVertexBuilder consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.func_225582_a_((double)(x + 64), -16.0, (double)z);
                consumer.func_181675_d();
                consumer.func_225582_a_((double)x, -16.0, (double)z);
                consumer.func_181675_d();
                consumer.func_225582_a_((double)x, -16.0, (double)(z + 64));
                consumer.func_181675_d();
                consumer.func_225582_a_((double)(x + 64), -16.0, (double)(z + 64));
                consumer.func_181675_d();
            }
        }
    }

    private void buildTopPlane(IVertexBuilder consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.func_225582_a_((double)(x + 64), 16.0, (double)z);
                consumer.func_181675_d();
                consumer.func_225582_a_((double)(x + 64), 16.0, (double)(z + 64));
                consumer.func_181675_d();
                consumer.func_225582_a_((double)x, 16.0, (double)(z + 64));
                consumer.func_181675_d();
                consumer.func_225582_a_((double)x, 16.0, (double)z);
                consumer.func_181675_d();
            }
        }
    }

    private void buildHorizon(IVertexBuilder consumer) {
        int radius = this.getRenderDistanceInBlocks();
        if (radius > 256) {
            radius = 256;
        }
        this.buildRegularOctagonalPrism(consumer, radius);
        this.buildTopPlane(consumer, 384);
        this.buildBottomPlane(consumer, 384);
    }

    private int getRenderDistanceInBlocks() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
    }

    public void renderHorizon(Matrix4f matrix) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        this.buildHorizon((IVertexBuilder)buffer);
        buffer.func_178977_d();
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)matrix);
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
        RenderSystem.popMatrix();
    }
}

