/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.LightTextureAccessor;
import net.coderbot.iris.rendertarget.NativeImageBackedCustomTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedNoiseTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;

public class CustomTextureManager {
    private final EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> customTextureIdMap = new EnumMap(TextureStage.class);
    private final IntSupplier noise;
    private final NativeImageBackedSingleColorTexture normals;
    private final NativeImageBackedSingleColorTexture specular;
    private final List<Texture> ownedTextures = new ArrayList<Texture>();

    public CustomTextureManager(PackDirectives packDirectives, EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap, Optional<CustomTextureData> customNoiseTextureData) {
        customTextureDataMap.forEach((textureStage, customTextureStageDataMap) -> {
            Object2ObjectOpenHashMap customTextureIds = new Object2ObjectOpenHashMap();
            customTextureStageDataMap.forEach((arg_0, arg_1) -> this.lambda$new$0((Object2ObjectMap)customTextureIds, textureStage, arg_0, arg_1));
            this.customTextureIdMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, IntSupplier>)customTextureIds);
        });
        this.noise = customNoiseTextureData.flatMap(textureData -> {
            try {
                return Optional.of(this.createCustomTexture((CustomTextureData)textureData));
            }
            catch (IOException | ResourceLocationException e) {
                Iris.logger.error("Unable to parse the image data for the custom noise texture", e);
                return Optional.empty();
            }
        }).orElseGet(() -> {
            int noiseTextureResolution = packDirectives.getNoiseTextureResolution();
            NativeImageBackedNoiseTexture texture = new NativeImageBackedNoiseTexture(noiseTextureResolution);
            this.ownedTextures.add((Texture)texture);
            return () -> ((Texture)texture).func_110552_b();
        });
        this.normals = new NativeImageBackedSingleColorTexture(127, 127, 255, 255);
        this.specular = new NativeImageBackedSingleColorTexture(0, 0, 0, 0);
        this.ownedTextures.add((Texture)this.normals);
        this.ownedTextures.add((Texture)this.specular);
    }

    private IntSupplier createCustomTexture(CustomTextureData textureData) throws IOException, ResourceLocationException {
        if (textureData instanceof CustomTextureData.PngData) {
            NativeImageBackedCustomTexture texture = new NativeImageBackedCustomTexture((CustomTextureData.PngData)textureData);
            this.ownedTextures.add((Texture)texture);
            return () -> ((Texture)texture).func_110552_b();
        }
        if (textureData instanceof CustomTextureData.LightmapMarker) {
            return () -> ((LightTextureAccessor)Minecraft.func_71410_x().field_71460_t.func_228384_l_()).getLightTexture().func_110552_b();
        }
        if (textureData instanceof CustomTextureData.ResourceData) {
            CustomTextureData.ResourceData resourceData = (CustomTextureData.ResourceData)textureData;
            String namespace = resourceData.getNamespace();
            String location = resourceData.getLocation();
            ResourceLocation textureLocation = new ResourceLocation(namespace, location);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            return () -> {
                Texture texture = textureManager.func_229267_b_(textureLocation);
                return texture != null ? texture.func_110552_b() : MissingTextureSprite.func_195676_d().func_110552_b();
            };
        }
        throw new IllegalArgumentException("Unable to handle custom texture data " + textureData);
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> getCustomTextureIdMap() {
        return this.customTextureIdMap;
    }

    public Object2ObjectMap<String, IntSupplier> getCustomTextureIdMap(TextureStage stage) {
        return this.customTextureIdMap.getOrDefault((Object)stage, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap());
    }

    public IntSupplier getNoiseTexture() {
        return this.noise;
    }

    public NativeImageBackedSingleColorTexture getNormals() {
        return this.normals;
    }

    public NativeImageBackedSingleColorTexture getSpecular() {
        return this.specular;
    }

    public void destroy() {
        this.ownedTextures.forEach(Texture::close);
    }

    private /* synthetic */ void lambda$new$0(Object2ObjectMap customTextureIds, TextureStage textureStage, String samplerName, CustomTextureData textureData) {
        try {
            customTextureIds.put((Object)samplerName, (Object)this.createCustomTexture(textureData));
        }
        catch (IOException | ResourceLocationException e) {
            Iris.logger.error("Unable to parse the image data for the custom texture on stage " + (Object)((Object)textureStage) + ", sampler " + samplerName, e);
        }
    }
}

