/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.bettermipmaps;

import java.util.Objects;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={TextureAtlasSprite.class})
public class MixinTextureAtlasSprite {
    private static final float[] SRGB_TO_LINEAR = new float[256];
    @Shadow
    @Final
    private TextureAtlasSprite.Info field_229226_c_;

    @ModifyVariable(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/MipmapGenerator;generateMipLevels(Lcom/mojang/blaze3d/platform/NativeImage;I)[Lcom/mojang/blaze3d/platform/NativeImage;"), argsOnly=true)
    private NativeImage iris$beforeGenerateMipLevels(NativeImage nativeImage) {
        ResourceLocation name = Objects.requireNonNull(this.field_229226_c_).func_229248_a_();
        if (name.func_110623_a().contains("leaves")) {
            return nativeImage;
        }
        this.iris$fillInTransparentPixelColors(nativeImage);
        return nativeImage;
    }

    @Unique
    private void iris$fillInTransparentPixelColors(NativeImage nativeImage) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalAlpha = 0.0f;
        for (int y = 0; y < nativeImage.func_195714_b(); ++y) {
            for (int x = 0; x < nativeImage.func_195702_a(); ++x) {
                int color = nativeImage.func_195709_a(x, y);
                int alpha = color >> 24 & 0xFF;
                if (alpha == 0) continue;
                totalAlpha += (float)alpha;
                r += MixinTextureAtlasSprite.iris$unpackLinearComponent(color, 0) * (float)alpha;
                g += MixinTextureAtlasSprite.iris$unpackLinearComponent(color, 8) * (float)alpha;
                b += MixinTextureAtlasSprite.iris$unpackLinearComponent(color, 16) * (float)alpha;
            }
        }
        r /= totalAlpha;
        g /= totalAlpha;
        b /= totalAlpha;
        if (totalAlpha == 0.0f) {
            return;
        }
        int resultColor = MixinTextureAtlasSprite.iris$packLinearToSrgb(r, g, b);
        for (int y = 0; y < nativeImage.func_195714_b(); ++y) {
            for (int x = 0; x < nativeImage.func_195702_a(); ++x) {
                int color = nativeImage.func_195709_a(x, y);
                int alpha = color >> 24 & 0xFF;
                if (alpha > 0) continue;
                nativeImage.func_195700_a(x, y, resultColor);
            }
        }
    }

    @Unique
    private static float iris$unpackLinearComponent(int color, int shift) {
        return SRGB_TO_LINEAR[color >> shift & 0xFF];
    }

    @Unique
    private static int iris$packLinearToSrgb(float r, float g, float b) {
        int srgbR = (int)(Math.pow(r, 0.45454545454545453) * 255.0);
        int srgbG = (int)(Math.pow(g, 0.45454545454545453) * 255.0);
        int srgbB = (int)(Math.pow(b, 0.45454545454545453) * 255.0);
        return srgbB << 16 | srgbG << 8 | srgbR;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MixinTextureAtlasSprite.SRGB_TO_LINEAR[i] = (float)Math.pow((double)i / 255.0, 2.2);
        }
    }
}

