/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.option;

import java.io.IOException;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.option.ShadowDistanceOption;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class IrisVideoSettings {
    public static int shadowDistance = 32;
    private static final ITextComponent DISABLED_TOOLTIP = new TranslationTextComponent("options.iris.shadowDistance.disabled");
    private static final ITextComponent ENABLED_TOOLTIP = new TranslationTextComponent("options.iris.shadowDistance.enabled");
    public static final SliderPercentageOption RENDER_DISTANCE = new ShadowDistanceOption("options.iris.shadowDistance", 0.0, 32.0, 1.0f, gameOptions -> IrisVideoSettings.getOverriddenShadowDistance(shadowDistance), (gameOptions, viewDistance) -> {
        double outputShadowDistance = viewDistance;
        shadowDistance = (int)outputShadowDistance;
        try {
            Iris.getIrisConfig().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }, (gameOptions, option) -> {
        ITextComponent tooltip;
        int d = (int)option.func_216729_a(gameOptions);
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            d = pipeline.getForcedShadowRenderDistanceChunksForDisplay().orElse(d);
            tooltip = pipeline.getForcedShadowRenderDistanceChunksForDisplay().isPresent() ? DISABLED_TOOLTIP : ENABLED_TOOLTIP;
        } else {
            tooltip = ENABLED_TOOLTIP;
        }
        option.func_241567_a_(Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)tooltip, 200));
        if ((double)d <= 0.0) {
            return new TranslationTextComponent("options.generic_value", new Object[]{new TranslationTextComponent("options.iris.shadowDistance"), "0 (disabled)"});
        }
        return new TranslationTextComponent("options.generic_value", new Object[]{new TranslationTextComponent("options.iris.shadowDistance"), new TranslationTextComponent("options.chunks", new Object[]{d})});
    });

    public static int getOverriddenShadowDistance(int base) {
        return Iris.getPipelineManager().getPipeline().map(pipeline -> pipeline.getForcedShadowRenderDistanceChunksForDisplay().orElse(base)).orElse(base);
    }

    public static boolean isShadowDistanceSliderEnabled() {
        return Iris.getPipelineManager().getPipeline().map(pipeline -> !pipeline.getForcedShadowRenderDistanceChunksForDisplay().isPresent()).orElse(true);
    }
}

