/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.shader.GlShader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgramCreator {
    private static final Logger LOGGER = LogManager.getLogger(ProgramCreator.class);

    public static int create(String name, GlShader ... shaders) {
        int result;
        int program = GlStateManager.func_227743_n_();
        IrisRenderSystem.bindAttributeLocation(program, 11, "mc_Entity");
        IrisRenderSystem.bindAttributeLocation(program, 12, "mc_midTexCoord");
        IrisRenderSystem.bindAttributeLocation(program, 13, "at_tangent");
        IrisRenderSystem.bindAttributeLocation(program, 14, "at_midBlock");
        for (GlShader shader : shaders) {
            GlStateManager.func_227704_d_((int)program, (int)shader.getHandle());
        }
        GlStateManager.func_227729_i_((int)program);
        for (GlShader shader : shaders) {
            IrisRenderSystem.detachShader(program, shader.getHandle());
        }
        String log = IrisRenderSystem.getProgramInfoLog(program);
        if (!log.isEmpty()) {
            LOGGER.warn("Program link log for " + name + ": " + log);
        }
        if ((result = GlStateManager.func_227691_c_((int)program, (int)35714)) != 1) {
            throw new RuntimeException("Shader program linking failed, see log for details");
        }
        return program;
    }
}

