/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gbuffer_overrides.matching;

public class InputAvailability {
    public static final int NUM_VALUES = 8;
    public final boolean texture;
    public final boolean lightmap;
    public final boolean overlay;

    public InputAvailability(boolean texture, boolean lightmap, boolean overlay) {
        this.texture = texture;
        this.lightmap = lightmap;
        this.overlay = overlay;
    }

    public InputAvailability withoutOverlay() {
        return new InputAvailability(this.texture, this.lightmap, false);
    }

    public static InputAvailability unpack(int packed) {
        return new InputAvailability((packed & 1) == 1, (packed & 2) == 2, (packed & 4) == 4);
    }

    public int pack() {
        int packed = 0;
        if (this.overlay) {
            packed |= 4;
        }
        if (this.lightmap) {
            packed |= 2;
        }
        if (this.texture) {
            packed |= 1;
        }
        return packed;
    }

    public String toString() {
        return "InputAvailability{texture=" + this.texture + ", lightmap=" + this.lightmap + ", overlay=" + this.overlay + '}';
    }
}

