/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexUtil;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;

public class XHFPModelVertexBufferWriterNio
extends VertexBufferWriterNio
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainNio quad = new QuadViewTerrain.QuadViewTerrainNio();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterNio(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    public void writeQuad(float x, float y, float z, int color, float u, float v, int light) {
        this.uSum += u;
        this.vSum += v;
        this.writeQuadInternal(ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)x), ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)y), ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)z), color, ModelVertexUtil.denormalizeVertexTextureFloatAsShort((float)u), ModelVertexUtil.denormalizeVertexTextureFloatAsShort((float)v), ModelVertexUtil.encodeLightMapTexCoord((int)light), this.contextHolder.blockId, this.contextHolder.renderType, ExtendedDataHelper.computeMidBlock(x, y, z, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(short x, short y, short z, int color, short u, short v, int light, short materialId, short renderType, int packedMidBlock) {
        int i = this.writeOffset;
        ++this.vertexCount;
        ByteBuffer buffer = this.byteBuffer;
        buffer.putShort(i, x);
        buffer.putShort(i + 2, y);
        buffer.putShort(i + 4, z);
        buffer.putInt(i + 8, color);
        buffer.putShort(i + 12, u);
        buffer.putShort(i + 14, v);
        buffer.putInt(i + 16, light);
        buffer.putShort(i + 36, materialId);
        buffer.putShort(i + 38, renderType);
        buffer.putInt(i + 40, packedMidBlock);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            buffer.putFloat(i + 20, this.uSum);
            buffer.putFloat(i + 20 - 44, this.uSum);
            buffer.putFloat(i + 20 - 88, this.uSum);
            buffer.putFloat(i + 20 - 132, this.uSum);
            buffer.putFloat(i + 24, this.vSum);
            buffer.putFloat(i + 24 - 44, this.vSum);
            buffer.putFloat(i + 24 - 88, this.vSum);
            buffer.putFloat(i + 24 - 132, this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(buffer, i, 44);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            buffer.putInt(i + 32, packedNormal);
            buffer.putInt(i + 32 - 44, packedNormal);
            buffer.putInt(i + 32 - 88, packedNormal);
            buffer.putInt(i + 32 - 132, packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            buffer.putInt(i + 28, tangent);
            buffer.putInt(i + 28 - 44, tangent);
            buffer.putInt(i + 28 - 88, tangent);
            buffer.putInt(i + 28 - 132, tangent);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }
}

