/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.formats.glyph.GlyphVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.ExtendedQuadVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewEntity;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class EntityVertexBufferWriterNio
extends VertexBufferWriterNio
implements QuadVertexSink,
GlyphVertexSink {
    private static final int STRIDE = IrisVertexFormats.ENTITY.func_177338_f();
    private final QuadViewEntity.QuadViewEntityNio quad = new QuadViewEntity.QuadViewEntityNio();
    private final Vector3f saveNormal = new Vector3f();
    private int vertexCount;
    private float uSum;
    private float vSum;

    public EntityVertexBufferWriterNio(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)ExtendedQuadVertexType.INSTANCE);
    }

    public void writeQuad(float x, float y, float z, int color, float u, float v, int light, int overlay, int normal) {
        int i = this.writeOffset;
        ByteBuffer buffer = this.byteBuffer;
        ++this.vertexCount;
        this.uSum += u;
        this.vSum += v;
        buffer.putFloat(i, x);
        buffer.putFloat(i + 4, y);
        buffer.putFloat(i + 8, z);
        buffer.putInt(i + 12, color);
        buffer.putFloat(i + 16, u);
        buffer.putFloat(i + 20, v);
        buffer.putInt(i + 24, overlay);
        buffer.putInt(i + 28, light);
        if (this.vertexCount == 4) {
            this.endQuad(normal);
        }
        this.advance();
    }

    public void writeGlyph(float x, float y, float z, int color, float u, float v, int light) {
        this.writeQuad(x, y, z, color, u, v, light, OverlayTexture.field_229196_a_, 0);
    }

    private void endQuad(int normal) {
        float normalZ;
        float normalY;
        float normalX;
        this.vertexCount = 0;
        int i = this.writeOffset;
        ByteBuffer buffer = this.byteBuffer;
        this.uSum = (float)((double)this.uSum * 0.25);
        this.vSum = (float)((double)this.vSum * 0.25);
        this.quad.setup(buffer, i, STRIDE);
        if (normal == 0) {
            NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
            normalX = this.saveNormal.x;
            normalY = this.saveNormal.y;
            normalZ = this.saveNormal.z;
            normal = NormalHelper.packNormal(this.saveNormal, 0.0f);
        } else {
            normalX = Norm3b.unpackX((int)normal);
            normalY = Norm3b.unpackY((int)normal);
            normalZ = Norm3b.unpackZ((int)normal);
        }
        int tangent = NormalHelper.computeTangent(normalX, normalY, normalZ, this.quad);
        for (int vertex = 0; vertex < 4; ++vertex) {
            buffer.putFloat(i + 36 - STRIDE * vertex, this.uSum);
            buffer.putFloat(i + 40 - STRIDE * vertex, this.vSum);
            buffer.putInt(i + 32 - STRIDE * vertex, normal);
            buffer.putInt(i + 44 - STRIDE * vertex, tangent);
        }
        this.uSum = 0.0f;
        this.vSum = 0.0f;
    }
}

