/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.coderbot.iris.compat.sodium.AllowedSodiumVersion;

public class SodiumVersionCheck {
    private static final ImmutableList<AllowedSodiumVersion> ALLOWED_SODIUM_VERSIONS = ImmutableList.of((Object)AllowedSodiumVersion.exact("0.2.0+build.4", "https://www.curseforge.com/minecraft/mc-mods/sodium/files/3488820"), (Object)AllowedSodiumVersion.prefix("0.2.0+rev.f42b4ca"), (Object)AllowedSodiumVersion.prefix("0.2.0+replaymod"));

    public static String getDownloadLink() {
        return (String)ALLOWED_SODIUM_VERSIONS.stream().map(AllowedSodiumVersion::getDownloadLink).filter(Optional::isPresent).findFirst().get().get();
    }

    public static boolean isAllowedVersion(String sodiumVersion) {
        for (AllowedSodiumVersion allowed : ALLOWED_SODIUM_VERSIONS) {
            if (!allowed.matches(sodiumVersion)) continue;
            return true;
        }
        return false;
    }
}

