/*
 * Decompiled with CFR 0.152.
 */
package com.umpaz.nethers_delight.common.blocks;

import com.umpaz.nethers_delight.core.util.NDTextUtils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.utils.TextUtils;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class RoastHoglinBlock
extends HorizontalBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final IntegerProperty SERVINGS = IntegerProperty.func_177719_a((String)"servings", (int)0, (int)11);
    public final Supplier<Item> sliceItem;
    public final Supplier<Item> snoutItem;
    public final Supplier<Item> hamItem;
    public final Supplier<Item> servingItem;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0)};

    public RoastHoglinBlock(AbstractBlock.Properties properties, Supplier<Item> sliceItem, Supplier<Item> snoutItem, Supplier<Item> hamItem, Supplier<Item> servingItem) {
        super(properties);
        this.sliceItem = sliceItem;
        this.snoutItem = snoutItem;
        this.hamItem = hamItem;
        this.servingItem = servingItem;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.SOUTH)).func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(11))).func_206870_a(PART, (Comparable)BedPart.HEAD));
    }

    public ItemStack getKnifeSliceItem() {
        return new ItemStack((IItemProvider)this.sliceItem.get());
    }

    public ItemStack getSnoutItem() {
        return new ItemStack((IItemProvider)this.snoutItem.get());
    }

    public ItemStack getHamItem() {
        return new ItemStack((IItemProvider)this.hamItem.get());
    }

    public ItemStack getServingItem() {
        return new ItemStack((IItemProvider)this.servingItem.get());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int servings = (Integer)state.func_177229_b((Property)SERVINGS);
        ItemStack serving = this.getSnoutItem();
        ItemStack heldItem = player.func_184586_b(handIn);
        if (servings == 0) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187881_gQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            worldIn.func_175655_b(pos, true);
            return ActionResultType.SUCCESS;
        }
        if (servings > 9) {
            if (ModTags.KNIVES.func_230235_a_((Object)heldItem.func_77973_b())) {
                return this.cutEar(worldIn, pos, state, heldItem, player);
            }
            player.func_146105_b((ITextComponent)NDTextUtils.getTranslation("block.feast.use_knife", serving.getContainerItem().func_200301_q()), true);
        }
        if (servings == 9) {
            if (heldItem.func_77969_a(serving.getContainerItem())) {
                return this.takeSnout(worldIn, pos, state, player, handIn);
            }
            player.func_146105_b((ITextComponent)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{serving.getContainerItem().func_200301_q()}), true);
        }
        if (servings > 4 && servings < 9) {
            if (heldItem.func_77969_a(serving.getContainerItem())) {
                return this.takeHam(worldIn, pos, state, player, handIn);
            }
            player.func_146105_b((ITextComponent)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{serving.getContainerItem().func_200301_q()}), true);
        }
        if (servings < 5) {
            if (heldItem.func_77969_a(serving.getContainerItem())) {
                return this.takeServing(worldIn, pos, state, player, handIn);
            }
            player.func_146105_b((ITextComponent)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{serving.getContainerItem().func_200301_q()}), true);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType cutEar(World worldIn, BlockPos pos, BlockState state, ItemStack tool, @Nullable PlayerEntity player) {
        int servings = (Integer)state.func_177229_b((Property)SERVINGS);
        BedPart part = (BedPart)state.func_177229_b(PART);
        BlockPos pairPos = pos.func_177972_a(RoastHoglinBlock.getDirectionToOtherPart(part, (Direction)state.func_177229_b((Property)field_185512_D)));
        BlockState pairState = worldIn.func_180495_p(pairPos);
        worldIn.func_180501_a(pairPos, (BlockState)pairState.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.getKnifeSliceItem());
        worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), SoundCategory.PLAYERS, 0.8f, 0.8f);
        if (player != null) {
            tool.func_222118_a(1, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        } else if (tool.func_96631_a(1, worldIn.field_73012_v, null)) {
            tool.func_190920_e(0);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType takeSnout(World worldIn, BlockPos pos, BlockState state, PlayerEntity player, Hand handIn) {
        int servings = (Integer)state.func_177229_b((Property)SERVINGS);
        BedPart part = (BedPart)state.func_177229_b(PART);
        BlockPos pairPos = pos.func_177972_a(RoastHoglinBlock.getDirectionToOtherPart(part, (Direction)state.func_177229_b((Property)field_185512_D)));
        BlockState pairState = worldIn.func_180495_p(pairPos);
        ItemStack serving = this.getSnoutItem();
        ItemStack heldItem = player.func_184586_b(handIn);
        worldIn.func_180501_a(pairPos, (BlockState)pairState.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        if (!player.field_71075_bZ.field_75098_d) {
            heldItem.func_190918_g(1);
        }
        if (!player.field_71071_by.func_70441_a(serving)) {
            player.func_71019_a(serving, false);
        }
        worldIn.func_184133_a(null, pos, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType takeHam(World worldIn, BlockPos pos, BlockState state, PlayerEntity player, Hand handIn) {
        int servings = (Integer)state.func_177229_b((Property)SERVINGS);
        BedPart part = (BedPart)state.func_177229_b(PART);
        BlockPos pairPos = pos.func_177972_a(RoastHoglinBlock.getDirectionToOtherPart(part, (Direction)state.func_177229_b((Property)field_185512_D)));
        BlockState pairState = worldIn.func_180495_p(pairPos);
        ItemStack serving = this.getHamItem();
        ItemStack heldItem = player.func_184586_b(handIn);
        worldIn.func_180501_a(pairPos, (BlockState)pairState.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        if (!player.field_71075_bZ.field_75098_d) {
            heldItem.func_190918_g(1);
        }
        if (!player.field_71071_by.func_70441_a(serving)) {
            player.func_71019_a(serving, false);
        }
        worldIn.func_184133_a(null, pos, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType takeServing(World worldIn, BlockPos pos, BlockState state, PlayerEntity player, Hand handIn) {
        int servings = (Integer)state.func_177229_b((Property)SERVINGS);
        BedPart part = (BedPart)state.func_177229_b(PART);
        BlockPos pairPos = pos.func_177972_a(RoastHoglinBlock.getDirectionToOtherPart(part, (Direction)state.func_177229_b((Property)field_185512_D)));
        BlockState pairState = worldIn.func_180495_p(pairPos);
        ItemStack serving = this.getServingItem();
        ItemStack heldItem = player.func_184586_b(handIn);
        worldIn.func_180501_a(pairPos, (BlockState)pairState.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        if (!player.field_71075_bZ.field_75098_d) {
            heldItem.func_190918_g(1);
        }
        if (!player.field_71071_by.func_70441_a(serving)) {
            player.func_71019_a(serving, false);
        }
        worldIn.func_184133_a(null, pos, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public static Direction getDirectionToOtherPart(BedPart part, Direction direction) {
        return part == BedPart.HEAD ? direction : direction.func_176734_d();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, SERVINGS, PART});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)SERVINGS)];
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == RoastHoglinBlock.getDirectionToOtherPart((BedPart)stateIn.func_177229_b(PART), (Direction)stateIn.func_177229_b((Property)field_185512_D))) {
            return stateIn.func_196955_c((IWorldReader)worldIn, currentPos) && facingState.func_203425_a((Block)this) && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? stateIn : Blocks.field_150350_a.func_176223_P();
        }
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos pairPos;
        BlockState pairState;
        BedPart part;
        if (!worldIn.field_72995_K && player.func_184812_l_() && (part = (BedPart)state.func_177229_b(PART)) == BedPart.FOOT && (pairState = worldIn.func_180495_p(pairPos = pos.func_177972_a(RoastHoglinBlock.getDirectionToOtherPart(part, (Direction)state.func_177229_b((Property)field_185512_D))))).func_177230_c() == this && pairState.func_177229_b(PART) == BedPart.HEAD) {
            worldIn.func_180501_a(pairPos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, pairPos, Block.func_196246_j((BlockState)pairState));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos facingPos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D));
            worldIn.func_180501_a(facingPos, (BlockState)state.func_206870_a(PART, (Comparable)BedPart.FOOT), 3);
            worldIn.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f();
        BlockPos pos = context.func_195995_a();
        BlockPos pairPos = pos.func_177972_a(facing);
        return context.func_195991_k().func_180495_p(pairPos).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)facing) : null;
    }
}

