/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.item;

import com.minecraftabnormals.neapolitan.common.entity.BananaPeelEntity;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEntities;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanSounds;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class BananaBunchItem
extends Item {
    public BananaBunchItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_196000_l() == Direction.UP) {
            World world = context.func_195991_k();
            this.placeBanana(world, context.func_221532_j().func_82615_a(), context.func_221532_j().func_82617_b(), context.func_221532_j().func_82616_c(), context.func_195990_h());
            this.handleOpening(world, context.func_195999_j(), context.func_221531_n(), context.func_195996_i());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (!NeapolitanTags.EntityTypes.UNAFFECTED_BY_SLIPPING.func_230235_a_((Object)target.func_200600_R())) {
            World world = player.field_70170_p;
            this.placeBanana(world, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), player.func_195046_g(1.0f));
            this.handleOpening(world, player, hand, stack);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        this.throwBanana(world, player, player.func_195050_f(1.0f), player.func_195046_g(1.0f));
        this.handleOpening(world, player, hand, player.func_184586_b(hand));
        return ActionResult.func_233538_a_((Object)player.func_184586_b(hand), (boolean)world.func_201670_d());
    }

    private void placeBanana(World world, double posX, double posY, double posZ, float yaw) {
        if (!world.field_72995_K) {
            BananaPeelEntity bananapeel = (BananaPeelEntity)((EntityType)NeapolitanEntities.BANANA_PEEL.get()).func_200721_a(world);
            bananapeel.func_70012_b(posX, posY, posZ, yaw, 0.0f);
            world.func_217376_c((Entity)bananapeel);
        }
    }

    private void throwBanana(World world, PlayerEntity player, float pitch, float yaw) {
        if (!world.field_72995_K) {
            BananaPeelEntity bananapeel = (BananaPeelEntity)((EntityType)NeapolitanEntities.BANANA_PEEL.get()).func_200721_a(world);
            bananapeel.func_70012_b(player.func_226277_ct_(), player.func_226280_cw_() - (double)0.1f, player.func_226281_cx_(), yaw, 0.0f);
            float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180))) * 0.6f;
            float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180))) * 0.6f;
            float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180))) * 0.6f;
            Vector3d vector3d = player.func_213322_ci();
            bananapeel.func_213317_d(new Vector3d((double)f, (double)f1, (double)f2).func_72441_c(vector3d.field_72450_a, player.func_233570_aj_() ? 0.0 : vector3d.field_72448_b, vector3d.field_72449_c));
            world.func_217376_c((Entity)bananapeel);
        }
    }

    private void handleOpening(World world, PlayerEntity player, Hand hand, ItemStack stack) {
        if (!world.field_72995_K) {
            player.func_184811_cZ().func_185145_a((Item)this, 5);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
                CriteriaTriggers.field_193138_y.func_193148_a(serverplayerentity, stack);
                serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)NeapolitanItems.BANANA.get(), 1 + world.field_73012_v.nextInt(3)));
            } else {
                ItemStack itemstack = new ItemStack((IItemProvider)NeapolitanItems.BANANA.get(), 1 + world.field_73012_v.nextInt(3));
                if (!player.field_71071_by.func_70441_a(itemstack)) {
                    player.func_71019_a(itemstack, false);
                }
            }
        }
        world.func_184133_a(player, player.func_233580_cy_(), (SoundEvent)NeapolitanSounds.ITEM_BANANA_BUNCH_OPEN.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
    }
}

