/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity.goals;

import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;

public class ChimpTemptBananaGoal
extends Goal {
    private static final EntityPredicate ENTITY_PREDICATE = new EntityPredicate().func_221013_a(10.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    protected final ChimpanzeeEntity chimpanzee;
    private final double speed;
    protected PlayerEntity closestPlayer;
    private int delayTemptCounter;
    private int forgetTimer;
    private int patience;
    private double playerDistance;

    public ChimpTemptBananaGoal(ChimpanzeeEntity chimpanzeeIn, double speedIn) {
        this.chimpanzee = chimpanzeeIn;
        this.speed = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        if (!this.chimpanzee.needsSnack()) {
            return false;
        }
        this.closestPlayer = this.chimpanzee.field_70170_p.func_217370_a(ENTITY_PREDICATE, (LivingEntity)this.chimpanzee);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.func_184614_ca()) || this.isTempting(this.closestPlayer.func_184592_cb());
    }

    protected boolean isTempting(ItemStack stack) {
        return this.chimpanzee.isSnack(stack);
    }

    public boolean func_75253_b() {
        if (this.forgetTimer <= 0) {
            return false;
        }
        if (this.closestPlayer == null || !ENTITY_PREDICATE.func_221015_a((LivingEntity)this.chimpanzee, (LivingEntity)this.closestPlayer)) {
            return false;
        }
        return this.chimpanzee.needsSnack() && ENTITY_PREDICATE.func_221015_a((LivingEntity)this.chimpanzee, (LivingEntity)this.closestPlayer);
    }

    public void func_75249_e() {
        this.forgetTimer = 100;
        this.patience = 60;
        this.playerDistance = this.chimpanzee.func_70068_e((Entity)this.closestPlayer);
    }

    public void func_75251_c() {
        this.closestPlayer = null;
        this.chimpanzee.func_70661_as().func_75499_g();
        this.delayTemptCounter = 100;
    }

    public void func_75246_d() {
        this.chimpanzee.func_70671_ap().func_75651_a((Entity)this.closestPlayer, (float)(this.chimpanzee.func_184649_cE() + 20), (float)this.chimpanzee.func_70646_bf());
        if (this.chimpanzee.func_70068_e((Entity)this.closestPlayer) < 6.25) {
            this.chimpanzee.func_70661_as().func_75499_g();
        } else {
            this.chimpanzee.func_70661_as().func_75497_a((Entity)this.closestPlayer, this.speed);
        }
        double d0 = this.chimpanzee.func_70068_e((Entity)this.closestPlayer);
        if (this.playerDistance < d0 && this.closestPlayer.func_213322_ci() != Vector3d.field_186680_a) {
            --this.patience;
        }
        this.playerDistance = d0;
        if (!this.chimpanzee.func_70631_g_() && this.patience <= 0 && !this.closestPlayer.field_71075_bZ.field_75098_d) {
            this.chimpanzee.func_70624_b((LivingEntity)this.closestPlayer);
        }
        this.forgetTimer = !this.isTempting(this.closestPlayer.func_184614_ca()) && !this.isTempting(this.closestPlayer.func_184592_cb()) ? --this.forgetTimer : 160;
    }
}

