/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity.goals;

import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ChimpJumpOnBouncyGoal
extends MoveToBlockGoal {
    private final ChimpanzeeEntity chimpanzee;
    private int jumps;

    public ChimpJumpOnBouncyGoal(ChimpanzeeEntity chimpanzeeIn, double speed, int length) {
        super((CreatureEntity)chimpanzeeIn, speed, length, 6);
        this.chimpanzee = chimpanzeeIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.chimpanzee.func_184218_aH()) {
            return false;
        }
        if (!this.chimpanzee.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING)) {
            return false;
        }
        if (this.chimpanzee.func_70631_g_() && this.chimpanzee.func_70681_au().nextInt(400) != 0) {
            return false;
        }
        if (!this.chimpanzee.func_70631_g_() && this.chimpanzee.func_70681_au().nextInt(1200) != 0) {
            return false;
        }
        return this.func_179489_g();
    }

    public boolean func_75253_b() {
        if (this.jumps > 10) {
            return false;
        }
        if (this.chimpanzee.func_184218_aH()) {
            return false;
        }
        return super.func_75253_b();
    }

    public void func_75249_e() {
        super.func_75249_e();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.jumps = 0;
        this.chimpanzee.setDefaultAction();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.func_179487_f() && this.chimpanzee.getAction().canBeInterrupted()) {
            this.chimpanzee.setAction(ChimpanzeeAction.JUMPING);
            if (this.chimpanzee.func_233570_aj_()) {
                this.chimpanzee.func_70683_ar().func_75660_a();
                Vector3d vector3d = this.chimpanzee.func_213322_ci();
                this.chimpanzee.func_213317_d(new Vector3d(vector3d.field_72450_a * 0.1, vector3d.field_72448_b, vector3d.field_72449_c * 0.1));
                ++this.jumps;
            }
        } else {
            this.chimpanzee.setDefaultAction();
        }
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_175623_d(pos.func_177984_a().func_177984_a()) && worldIn.func_180495_p(pos).func_177230_c().func_203417_a(NeapolitanTags.Blocks.CHIMPANZEE_JUMPING_BLOCKS) && !this.isBlockBeingJumpedOn((World)worldIn, pos);
    }

    private boolean isBlockBeingJumpedOn(World worldIn, BlockPos pos) {
        return !worldIn.func_175647_a(ChimpanzeeEntity.class, new AxisAlignedBB(pos.func_177984_a()), chimpanzee -> chimpanzee != this.chimpanzee && chimpanzee.isDoingAction(ChimpanzeeAction.JUMPING)).isEmpty();
    }
}

