/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity;

import com.minecraftabnormals.neapolitan.common.entity.BananaPeelEntity;
import com.minecraftabnormals.neapolitan.common.entity.PlantainSpiderEntity;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpApeModeGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpAttackGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpAvoidEntityGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpBeGroomedGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpCryGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpEatBananaGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpFollowOthersGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpFollowParentGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpGetScaredGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpGrabBananaGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpGroomGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpHurtByTargetGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpJumpOnBouncyGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpLookAtItemGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpOpenBunchGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpPanicGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpPlayNoteBlockGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpPlayWithHelmetGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpRandomWalkingGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpShakeBundleGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpShakeHeadGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpShareBananaGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpSitGoal;
import com.minecraftabnormals.neapolitan.common.entity.goals.ChimpTemptBananaGoal;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeTypes;
import com.minecraftabnormals.neapolitan.common.item.MilkshakeItem;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanConstants;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEntities;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanParticles;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanSounds;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ChimpanzeeEntity
extends AnimalEntity
implements IAngerable {
    private static final DataParameter<Integer> CHIMPANZEE_TYPE = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> APE_MODE_TIME = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DIRTINESS = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PALENESS = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEFT_HAND_DYE_COLOR = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RIGHT_HAND_DYE_COLOR = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_LEFT_HAND_DYED = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_RIGHT_HAND_DYED = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> ACTION = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Direction> FACING = EntityDataManager.func_187226_a(ChimpanzeeEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final UUID SPEED_MODIFIER_SITTING_UUID = UUID.fromString("2EF64346-9E56-44E9-9574-1BF9FD6443CF");
    private static final AttributeModifier SPEED_MODIFIER_SITTING = new AttributeModifier(SPEED_MODIFIER_SITTING_UUID, "Sitting speed reduction", -0.75, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final EntitySize SITTING_DIMENSIONS = EntitySize.func_220314_b((float)0.6f, (float)1.0f);
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID lastHurtBy;
    private int attackTimer;
    private int climbingStamina;
    private boolean isLeader;
    private boolean lookingForBundle;
    @Nullable
    private ChimpanzeeEntity groomingTarget;
    @Nullable
    private ChimpanzeeEntity groomer;
    private float climbAnim;
    private float climbAnim0;
    private float sitAnim;
    private float sitAnim0;
    private int headShakeAnim;
    private int headShakeAnim0;
    public boolean isPartying;
    BlockPos jukeboxPosition;

    public ChimpanzeeEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.climbingStamina = 20 + this.field_70146_Z.nextInt(40);
        this.isPartying = false;
        this.field_70749_g = new LookHelperController();
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ChimpSitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ChimpGetScaredGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new ChimpGrabBananaGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new ChimpAttackGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new ChimpPanicGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(6, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, new ChimpAvoidEntityGoal<PlantainSpiderEntity>(this, PlantainSpiderEntity.class, 4.0f, 1.0, 1.25));
        this.field_70714_bg.func_75776_a(8, (Goal)new ChimpOpenBunchGoal(this));
        this.field_70714_bg.func_75776_a(9, (Goal)new ChimpEatBananaGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new ChimpTemptBananaGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(11, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199805_a(NeapolitanTags.Items.CHIMPANZEE_FOOD), false));
        this.field_70714_bg.func_75776_a(12, (Goal)new ChimpFollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(13, (Goal)new ChimpShareBananaGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(14, (Goal)new ChimpBeGroomedGoal(this));
        this.field_70714_bg.func_75776_a(15, (Goal)new ChimpGroomGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(16, (Goal)new ChimpFollowOthersGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(17, (Goal)new ChimpShakeBundleGoal(this, 1.0, 48, 16));
        this.field_70714_bg.func_75776_a(18, (Goal)new ChimpPlayWithHelmetGoal(this));
        this.field_70714_bg.func_75776_a(19, (Goal)new ChimpCryGoal(this));
        this.field_70714_bg.func_75776_a(20, (Goal)new ChimpShakeHeadGoal(this));
        this.field_70714_bg.func_75776_a(21, (Goal)new ChimpLookAtItemGoal(this));
        this.field_70714_bg.func_75776_a(22, (Goal)new ChimpJumpOnBouncyGoal(this, 1.0, 16));
        this.field_70714_bg.func_75776_a(23, (Goal)new ChimpPlayNoteBlockGoal(this, 1.0, 16));
        this.field_70714_bg.func_75776_a(24, (Goal)new ChimpApeModeGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(25, (Goal)new ChimpRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(26, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(27, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(28, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((ChimpanzeeEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(1, (Goal)new ChimpHurtByTargetGoal(this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHIMPANZEE_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(APE_MODE_TIME, (Object)0);
        this.field_70180_af.func_187214_a(HUNGER, (Object)0);
        this.field_70180_af.func_187214_a(DIRTINESS, (Object)0);
        this.field_70180_af.func_187214_a(PALENESS, (Object)0);
        this.field_70180_af.func_187214_a(LEFT_HAND_DYE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(RIGHT_HAND_DYE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(IS_LEFT_HAND_DYED, (Object)false);
        this.field_70180_af.func_187214_a(IS_RIGHT_HAND_DYED, (Object)false);
        this.field_70180_af.func_187214_a(ACTION, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(FACING, (Object)Direction.DOWN);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
        compound.func_74768_a("ChimpanzeeType", this.getChimpanzeeType());
        compound.func_74768_a("ApeModeTime", this.getApeModeTime());
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74768_a("Dirtiness", this.getDirtiness());
        compound.func_74768_a("Paleness", this.getPaleness());
        compound.func_74774_a("LeftHandDyeColor", (byte)this.getHandDyeColor(HandSide.LEFT).func_196059_a());
        compound.func_74774_a("RightHandDyeColor", (byte)this.getHandDyeColor(HandSide.RIGHT).func_196059_a());
        compound.func_74757_a("Sitting", this.isSitting());
        compound.func_74757_a("IsLeftHandDyed", this.getHandDyed(HandSide.LEFT));
        compound.func_74757_a("IsRightHandDyed", this.getHandDyed(HandSide.RIGHT));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        this.setChimpanzeeType(compound.func_74762_e("ChimpanzeeType"));
        this.setApeModeTime(compound.func_74762_e("ApeModeTime"));
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setDirtiness(compound.func_74762_e("Dirtiness"));
        this.setPaleness(compound.func_74762_e("Paleness"));
        this.setHandDyeColor(DyeColor.func_196056_a((int)compound.func_74762_e("LeftHandDyeColor")), HandSide.LEFT);
        this.setHandDyeColor(DyeColor.func_196056_a((int)compound.func_74762_e("RightHandDyeColor")), HandSide.RIGHT);
        this.setSitting(compound.func_74767_n("Sitting"));
        this.setHandDyed(compound.func_74767_n("IsLeftHandDyed"), HandSide.LEFT);
        this.setHandDyed(compound.func_74767_n("IsRightHandDyed"), HandSide.RIGHT);
    }

    protected BodyController func_184650_s() {
        return new BodyHelperController();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    public int func_70627_aG() {
        return this.getApeModeTime() > 0 ? 20 : 120;
    }

    protected SoundEvent func_184639_G() {
        return this.func_233678_J__() || this.getApeModeTime() > 0 ? (SoundEvent)NeapolitanSounds.ENTITY_CHIMPANZEE_SCREAM.get() : (SoundEvent)NeapolitanSounds.ENTITY_CHIMPANZEE_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)NeapolitanSounds.ENTITY_CHIMPANZEE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)NeapolitanSounds.ENTITY_CHIMPANZEE_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)NeapolitanSounds.ENTITY_CHIMPANZEE_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return null;
    }

    public void playScreamSound() {
        this.func_184185_a((SoundEvent)NeapolitanSounds.ENTITY_CHIMPANZEE_SCREAM.get(), this.func_70599_aP(), this.func_70647_i());
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected void func_70619_bc() {
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        if (this.func_233678_J__()) {
            this.field_70718_bc = this.field_70173_aa;
        }
        if (this.getApeModeTime() > 0 && this.func_70605_aq().func_75640_a() && !this.isSitting()) {
            double d0 = this.func_70605_aq().func_75638_b();
            this.func_70031_b(d0 >= 1.0);
        } else {
            this.func_70031_b(false);
        }
        super.func_70619_bc();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.swingArms();
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        float f2 = this.isChimpanzeeWeapon(this.func_184614_ca()) || this.isChimpanzeeWeapon(this.func_184592_cb()) ? f1 + 1.0f : f1;
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f2);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean isChimpanzeeWeapon(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151055_y || item == Items.field_222068_kQ;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.canStandUp()) {
            this.setSitting(false);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING)) {
            this.setDefaultAction();
        }
        super.func_70071_h_();
        if (this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                this.handleClimbing();
                if (this.field_70146_Z.nextInt(60) == 0) {
                    this.setLeader(this.shouldBeLeader());
                }
                if (this.field_70146_Z.nextInt(100) == 0 && (this.func_203008_ap() || this.field_70170_p.func_175727_C(this.func_233580_cy_()))) {
                    this.setHandDyed(false, this.field_70146_Z.nextBoolean() ? HandSide.LEFT : HandSide.RIGHT);
                }
            }
            this.spawnParticles();
        }
        this.climbAnim0 = this.climbAnim;
        this.climbAnim = this.isDoingAction(ChimpanzeeAction.CLIMBING) ? Math.min(this.climbAnim + 0.125f, 0.75f) : (this.isDoingAction(ChimpanzeeAction.HANGING, ChimpanzeeAction.SHAKING) ? Math.min(this.climbAnim + 0.125f, 1.0f) : Math.max(this.climbAnim - 0.125f, 0.0f));
        this.sitAnim0 = this.sitAnim;
        this.sitAnim = this.isSitting() ? Math.min(this.sitAnim + 0.167f, 1.0f) : Math.max(this.sitAnim - 0.167f, 0.0f);
        this.headShakeAnim0 = this.headShakeAnim;
        if (this.headShakeAnim > 0) {
            --this.headShakeAnim;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.jukeboxPosition == null || !this.jukeboxPosition.func_218137_a((IPosition)this.func_213303_ch(), 3.46) || this.field_70170_p.func_180495_p(this.jukeboxPosition).func_177230_c() != Blocks.field_150421_aI) {
            this.isPartying = false;
            this.jukeboxPosition = null;
        }
        this.func_213323_x_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getApeModeTime() > 0) {
                this.setApeModeTime(this.getApeModeTime() - 1);
            }
            if (!this.isHungry() && this.getHunger() >= 0) {
                this.setHunger(this.getHunger() + 1);
                if (this.isHungry()) {
                    this.setLeader(this.shouldBeLeader());
                }
            }
            if (!this.isDirty() && this.getDirtiness() >= 0) {
                this.setDirtiness(this.getDirtiness() + 1);
            }
            if (this.getPaleness() >= 0) {
                if (this.isInSunlight()) {
                    this.setPaleness(this.getPaleness() - 1);
                } else if (!this.needsSunlight()) {
                    this.setPaleness(this.getPaleness() + 1);
                }
            }
            if (this.shouldClimb() && this.field_70124_G) {
                if (--this.climbingStamina <= 0) {
                    this.climbingStamina = -20;
                }
            } else if (this.field_70122_E) {
                this.climbingStamina = this.climbingStamina < 0 ? ++this.climbingStamina : 20 + this.field_70146_Z.nextInt(40);
            }
        }
    }

    private void spawnParticles() {
        if (this.isDirty() && this.field_70173_aa % 6 == 0) {
            double d0 = ((double)this.field_70146_Z.nextFloat() + 1.0) * 0.06;
            double d1 = (double)this.field_70146_Z.nextInt(360) - 360.0;
            double d2 = ((double)this.field_70146_Z.nextFloat() + 1.0) * 14.0;
            this.field_70170_p.func_195594_a((IParticleData)NeapolitanParticles.FLY.get(), this.func_226282_d_(0.5), this.func_226280_cw_() + this.field_70146_Z.nextDouble() * 0.2 + 0.3, this.func_226287_g_(0.5), d0, d1, d2 *= this.field_70146_Z.nextBoolean() ? 1.0 : -1.0);
        }
        if (this.isDoingAction(ChimpanzeeAction.EATING)) {
            ItemStack food = this.getSnack();
            if (this.field_70173_aa % 10 == 0 && !food.func_190926_b()) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 6; ++i) {
                        Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1);
                        vector3d = vector3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                        vector3d = vector3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                        double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.2;
                        Vector3d vector3d1 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.2, d0, 0.6 * (double)this.func_213355_cm() + ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.2);
                        vector3d1 = vector3d1.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
                        vector3d1 = vector3d1.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
                        this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184586_b(this.getSnackHand())), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
                    }
                }
                this.func_184185_a((SoundEvent)NeapolitanSounds.ENTITY_CHIMPANZEE_EAT.get(), 0.25f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        } else if (this.isDoingAction(ChimpanzeeAction.CRYING) && this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0 && this.field_70146_Z.nextInt(4) > 0) {
            for (int i = 0; i < 2; ++i) {
                double d0 = i == 0 ? (double)this.field_70146_Z.nextFloat() * 0.15 + 0.1 : (double)(-this.field_70146_Z.nextFloat()) * 0.15 - 0.1;
                double d1 = (double)this.field_70146_Z.nextFloat() * 0.1 + 0.15;
                double d2 = i == 0 ? 0.15 : -0.15;
                Vector3d vector3d = new Vector3d(d0, Math.random() * 0.2 + 0.1, (double)this.field_70146_Z.nextFloat() * 0.2 + 0.1);
                vector3d = vector3d.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
                Vector3d vector3d1 = new Vector3d(d2, d1, 0.35);
                vector3d1 = vector3d1.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
                vector3d1 = vector3d1.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
                this.field_70170_p.func_195594_a((IParticleData)NeapolitanParticles.TEAR.get(), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
            }
        }
    }

    private void handleClimbing() {
        this.setBesideClimbableBlock(this.field_70123_F);
        if (this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
            Direction newfacing = Direction.DOWN;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3d vector3d = this.func_213306_e(Vector3d.func_237491_b_((Vector3i)direction.func_176730_m()));
                if (!(Math.abs(vector3d.func_216370_a(direction.func_176740_k())) <= 0.2)) continue;
                newfacing = direction;
                if (direction != this.field_70180_af.func_187225_a(FACING)) continue;
                break;
            }
            this.setFacing(newfacing);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b()) {
            ActionResultType actionresulttype;
            if (itemstack.func_77973_b() instanceof MilkshakeItem && (actionresulttype = itemstack.func_111282_a_(player, (LivingEntity)this, hand)).func_226246_a_()) {
                return actionresulttype;
            }
            if (!this.func_70877_b(itemstack) || this.isHungry()) {
                if (this.func_184614_ca().func_190926_b() || this.isHungry() && this.isSnack(itemstack) && !this.isSnack(this.func_184614_ca())) {
                    if (!this.func_184614_ca().func_190926_b()) {
                        this.dropItem(this.func_184614_ca());
                    }
                    if (this.isSnack(itemstack)) {
                        this.func_241356_K__();
                    }
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    itemstack1.func_190920_e(1);
                    this.func_184611_a(Hand.MAIN_HAND, itemstack1);
                    this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
                    this.func_175505_a(player, itemstack);
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                }
                return ActionResultType.PASS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void openBunch(Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            BananaPeelEntity bananapeel = (BananaPeelEntity)((EntityType)NeapolitanEntities.BANANA_PEEL.get()).func_200721_a(this.field_70170_p);
            bananapeel.func_70012_b(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            bananapeel.func_213293_j(this.field_70146_Z.nextDouble() * 0.4 - 0.2, 0.4, this.field_70146_Z.nextDouble() * 0.4 - 0.2);
            this.field_70170_p.func_217376_c((Entity)bananapeel);
            this.func_184611_a(hand, new ItemStack((IItemProvider)NeapolitanItems.BANANA.get()));
        }
    }

    public void eatSnack() {
        if (!this.getSnack().func_190926_b()) {
            if (this.getSnack().func_77973_b() == NeapolitanItems.BANANARROW.get()) {
                this.func_70691_i(((Item)NeapolitanItems.BANANA.get()).func_219967_s().func_221466_a());
                this.func_70097_a(DamageSource.field_76377_j, 0.0f);
                this.func_184611_a(this.getSnackHand(), new ItemStack((IItemProvider)Items.field_151032_g));
            } else {
                if (this.getSnack().func_222117_E()) {
                    this.func_70691_i(this.getSnack().func_77973_b().func_219967_s().func_221466_a());
                }
                this.func_184611_a(this.getSnackHand(), this.getSnack().func_77950_b(this.field_70170_p, (LivingEntity)this));
            }
        }
        this.setHunger(0);
    }

    public void func_233629_a_(LivingEntity entity, boolean isFlying) {
        double d2;
        double d1;
        this.field_184618_aE = this.field_70721_aZ;
        double d0 = this.func_226277_ct_() - this.field_70169_q;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = this.isDoingAction(ChimpanzeeAction.CLIMBING) ? this.func_226278_cu_() - this.field_70167_r : 0.0) * d1 + (d2 = this.func_226281_cx_() - this.field_70166_s) * d2)) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.field_70721_aZ += (f - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return this.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING) && this.isBesideClimbableBlock() && !this.isSitting() && this.climbingStamina > 0;
    }

    public boolean shouldClimb() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public EntitySize func_213305_a(Pose pose) {
        if (this.isSitting()) {
            return SITTING_DIMENSIONS.func_220313_a(this.func_213355_cm());
        }
        return super.func_213305_a(pose);
    }

    public boolean canStandUp() {
        EntitySize entitysize = this.func_200600_R().func_220334_j();
        float f = entitysize.field_220315_a / 2.0f;
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - (double)f, this.func_226278_cu_(), this.func_226281_cx_() - (double)f);
        Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() + (double)f, this.func_226278_cu_() + (double)entitysize.field_220316_b, this.func_226281_cx_() + (double)f);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(vector3d, vector3d1);
        return this.field_70170_p.func_226665_a__((Entity)this, axisalignedbb.func_186664_h(1.0E-7));
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? -0.05 : -0.3;
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)itemstackIn);
        if (!this.func_184582_a(equipmentslottype).func_190926_b()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.func_213365_e(itemstackIn);
    }

    public int getApeModeTime() {
        return (Integer)this.field_70180_af.func_187225_a(APE_MODE_TIME);
    }

    public void setApeModeTime(int time) {
        this.field_70180_af.func_187227_b(APE_MODE_TIME, (Object)time);
    }

    public boolean func_175448_a(ItemStack stack) {
        ItemStack heldstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return heldstack.func_190926_b() || this.getItemValue(stack) > this.getItemValue(heldstack);
    }

    private int getItemValue(ItemStack stack) {
        if (this.isSnack(stack)) {
            return this.isHungry() ? 2 : 1;
        }
        if (this.isFavoriteItem(stack)) {
            return 1;
        }
        return 0;
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (!this.isDoingAction(ChimpanzeeAction.LOOKING_AT_ITEM, ChimpanzeeAction.PLAYING_WITH_ITEM) && this.func_175448_a(itemstack)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), itemstack.func_77979_a(i - 1));
                this.field_70170_p.func_217376_c((Entity)itementity);
            }
            this.dropItem(this.func_184614_ca());
            this.func_233630_a_(itemEntity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            if (this.isSnack(itemstack)) {
                this.func_241356_K__();
            }
        }
    }

    public boolean isFavoriteItem(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(NeapolitanTags.Items.CHIMPANZEE_FAVORITES);
    }

    public void throwHeldItem(Hand hand) {
        ItemStack stack = this.func_184586_b(hand);
        if (!stack.func_190926_b() && !this.field_70170_p.field_72995_K) {
            Item item = stack.func_77973_b();
            if (item instanceof ArrowItem) {
                ArrowItem arrowItem = (ArrowItem)item;
                List list = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0), entity -> NeapolitanTags.EntityTypes.CHIMPANZEE_DART_TARGETS.func_230235_a_((Object)entity.func_200600_R()));
                Entity target = null;
                double maxValue = Double.MAX_VALUE;
                for (Entity entity2 : list) {
                    double distance = this.func_70068_e(entity2);
                    if (distance > maxValue) continue;
                    maxValue = distance;
                    target = entity2;
                }
                if (target != null) {
                    AbstractArrowEntity arrow = arrowItem.func_200887_a(this.field_70170_p, stack, (LivingEntity)this);
                    double d0 = target.func_226280_cw_() - (double)1.1f;
                    double d1 = target.func_226277_ct_() - this.func_226277_ct_();
                    double d2 = d0 - arrow.func_226278_cu_();
                    double d3 = target.func_226281_cx_() - this.func_226281_cx_();
                    float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
                    this.func_70625_a(target, 90.0f, 90.0f);
                    arrow.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 6.0f);
                    this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 0.4f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_217376_c((Entity)arrow);
                    this.func_184611_a(hand, ItemStack.field_190927_a);
                    this.swingArms();
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                }
            } else {
                if (item instanceof DyeItem || ModList.get().isLoaded("environmental") && item == ForgeRegistries.ITEMS.getValue(NeapolitanConstants.MUD_BALL)) {
                    HandSide handside = hand == Hand.MAIN_HAND ? this.func_184591_cq() : this.func_184591_cq().func_188468_a();
                    this.setHandDyed(true, handside);
                    this.setHandDyeColor(item instanceof DyeItem ? ((DyeItem)item).func_195962_g() : DyeColor.BROWN, handside);
                }
                ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a * 0.2, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.625f), this.func_226281_cx_() + this.func_70040_Z().field_72449_c * 0.2, stack);
                Vector3d vector3d = new Vector3d(this.func_70040_Z().field_72450_a * 0.25, 0.0, this.func_70040_Z().field_72449_c * 0.25);
                itemEntity.func_213317_d(vector3d);
                itemEntity.func_174867_a(40);
                itemEntity.func_200216_c(this.func_110124_au());
                this.field_70170_p.func_217376_c((Entity)itemEntity);
                this.func_184611_a(hand, ItemStack.field_190927_a);
                this.swingArms();
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            }
        }
    }

    public void dropItem(ItemStack itemStack) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226280_cw_() - (double)0.3f, this.func_226281_cx_(), itemStack);
        itementity.func_174867_a(40);
        itementity.func_200216_c(this.func_110124_au());
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    public void spawnItemFromBucket(ItemStack itemStack, HandSide hand) {
        Vector3d vector3d = new Vector3d(hand == HandSide.LEFT ? 0.35 : -0.35, 0.0, 0.5);
        vector3d = vector3d.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + vector3d.field_72450_a * (double)this.func_213355_cm(), this.func_226280_cw_() - (double)0.15f, this.func_226281_cx_() + vector3d.field_72449_c * (double)this.func_213355_cm(), itemStack);
        itementity.func_213293_j(0.0, 0.25, 0.0);
        itementity.func_174867_a(40);
        itementity.func_200216_c(this.func_110124_au());
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    public void setOffFirework(ItemStack itemStack, HandSide hand) {
        Vector3d vector3d = new Vector3d(hand == HandSide.LEFT ? 0.35 : -0.35, 0.0, 0.5);
        vector3d = vector3d.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.field_70170_p, (Entity)this, this.func_226277_ct_() + vector3d.field_72450_a * (double)this.func_213355_cm(), this.func_226280_cw_(), this.func_226281_cx_() + vector3d.field_72449_c * (double)this.func_213355_cm(), itemStack);
        this.field_70170_p.func_217376_c((Entity)fireworkrocketentity);
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void setLeader(boolean isLeaderIn) {
        this.isLeader = isLeaderIn;
    }

    public boolean isLookingForBundle() {
        return this.lookingForBundle;
    }

    public void setLookingForBundle(boolean lookingForBundleIn) {
        this.lookingForBundle = lookingForBundleIn;
        if (lookingForBundleIn) {
            this.setLeader(this.shouldBeLeader());
            Predicate<ChimpanzeeEntity> predicate = chimpanzeeentity -> chimpanzeeentity != this && chimpanzeeentity.func_70874_b() >= 0;
            List list = this.field_70170_p.func_175647_a(ChimpanzeeEntity.class, this.func_174813_aQ().func_72314_b(12.0, 8.0, 12.0), predicate);
            for (ChimpanzeeEntity chimpanzeeentity2 : list) {
                chimpanzeeentity2.setLeader(chimpanzeeentity2.shouldBeLeader());
            }
        }
    }

    private boolean shouldBeLeader() {
        Predicate<ChimpanzeeEntity> predicate = chimpanzeeentity -> chimpanzeeentity != this && chimpanzeeentity.func_70874_b() >= 0;
        List list = this.field_70170_p.func_175647_a(ChimpanzeeEntity.class, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), predicate);
        if (list.isEmpty()) {
            return false;
        }
        int chimpamount = list.size() + 1;
        int leaderamount = 0;
        for (ChimpanzeeEntity chimpanzeeentity2 : list) {
            if (chimpanzeeentity2.isLeader()) {
                ++leaderamount;
            }
            if (leaderamount * 4 < chimpamount || this.isLookingForBundle() && !chimpanzeeentity2.isLookingForBundle()) continue;
            return false;
        }
        return true;
    }

    public static boolean canChimpanzeeSpawn(EntityType<ChimpanzeeEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_226659_b_(pos, 0) > 8;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setTypeForPosition(this, (IWorld)worldIn);
        this.setHunger(this.field_70146_Z.nextInt(4800));
        this.setDirtiness(this.field_70146_Z.nextInt(4800));
        this.func_180481_a(difficultyIn);
        return spawnDataIn;
    }

    public void setTypeForPosition(ChimpanzeeEntity entity, IWorld worldIn) {
        if (worldIn.func_226691_t_(this.func_233580_cy_()).getRegistryName().func_110623_a().contains("rainforest")) {
            entity.setChimpanzeeType(ChimpanzeeTypes.RAINFOREST.getId());
        } else if (worldIn.func_226691_t_(this.func_233580_cy_()).getRegistryName().func_110623_a().contains("bamboo")) {
            entity.setChimpanzeeType(ChimpanzeeTypes.BAMBOO.getId());
        } else {
            entity.setChimpanzeeType(ChimpanzeeTypes.JUNGLE.getId());
        }
    }

    protected void func_180481_a(DifficultyInstance difficultyIn) {
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            float f = this.field_70146_Z.nextFloat();
            ItemStack itemstack = f < 0.6f ? (this.field_70170_p.func_226691_t_(this.func_233580_cy_()).getRegistryName().func_110623_a().contains("bamboo") ? new ItemStack((IItemProvider)Items.field_222068_kQ) : new ItemStack((IItemProvider)Items.field_151055_y)) : new ItemStack((IItemProvider)NeapolitanBlocks.BANANA_FROND.get());
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
        }
    }

    public ChimpanzeeEntity getBreedOffspring(ServerWorld world, AgeableEntity ageableEntity) {
        ChimpanzeeEntity baby = (ChimpanzeeEntity)((EntityType)NeapolitanEntities.CHIMPANZEE.get()).func_200721_a((World)world);
        baby.setChimpanzeeType(this.field_70146_Z.nextBoolean() ? this.getChimpanzeeType() : ((ChimpanzeeEntity)ageableEntity).getChimpanzeeType());
        return baby;
    }

    public int getChimpanzeeType() {
        return (Integer)this.field_70180_af.func_187225_a(CHIMPANZEE_TYPE);
    }

    public void setChimpanzeeType(int type) {
        this.field_70180_af.func_187227_b(CHIMPANZEE_TYPE, (Object)type);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public ChimpanzeeEntity getGroomingTarget() {
        return this.groomingTarget;
    }

    public void setGroomingTarget(ChimpanzeeEntity target) {
        this.groomingTarget = target;
    }

    public ChimpanzeeEntity getGroomer() {
        return this.groomer;
    }

    public void setGroomer(ChimpanzeeEntity groomerIn) {
        this.groomer = groomerIn;
    }

    public Direction getFacing() {
        return (Direction)this.field_70180_af.func_187225_a(FACING);
    }

    public void setFacing(Direction direction) {
        this.field_70180_af.func_187227_b(FACING, (Object)direction);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sitting);
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (modifiableattributeinstance.func_111127_a(SPEED_MODIFIER_SITTING_UUID) != null) {
            modifiableattributeinstance.func_111124_b(SPEED_MODIFIER_SITTING);
        }
        if (sitting) {
            modifiableattributeinstance.func_233767_b_(SPEED_MODIFIER_SITTING);
        }
    }

    public DyeColor getHandDyeColor(HandSide handSide) {
        return DyeColor.func_196056_a((int)(handSide == HandSide.LEFT ? ((Integer)this.field_70180_af.func_187225_a(LEFT_HAND_DYE_COLOR)).intValue() : ((Integer)this.field_70180_af.func_187225_a(RIGHT_HAND_DYE_COLOR)).intValue()));
    }

    public void setHandDyeColor(DyeColor dyeColor, HandSide handSide) {
        this.field_70180_af.func_187227_b(handSide == HandSide.LEFT ? LEFT_HAND_DYE_COLOR : RIGHT_HAND_DYE_COLOR, (Object)dyeColor.func_196059_a());
    }

    public boolean getHandDyed(HandSide handSide) {
        return handSide == HandSide.LEFT ? ((Boolean)this.field_70180_af.func_187225_a(IS_LEFT_HAND_DYED)).booleanValue() : ((Boolean)this.field_70180_af.func_187225_a(IS_RIGHT_HAND_DYED)).booleanValue();
    }

    public void setHandDyed(boolean dyed, HandSide handSide) {
        this.field_70180_af.func_187227_b(handSide == HandSide.LEFT ? IS_LEFT_HAND_DYED : IS_RIGHT_HAND_DYED, (Object)dyed);
    }

    public UUID func_230257_G__() {
        return this.lastHurtBy;
    }

    public void func_230259_a_(UUID target) {
        this.lastHurtBy = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setHunger(int amount) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)amount);
    }

    public boolean isHungry() {
        return this.getHunger() >= 9600;
    }

    public boolean needsSnack() {
        return this.isHungry() && this.getSnack().func_190926_b();
    }

    public Hand getSnackHand() {
        if (!this.getSnack(Hand.MAIN_HAND).func_190926_b()) {
            return Hand.MAIN_HAND;
        }
        return Hand.OFF_HAND;
    }

    public ItemStack getSnack() {
        if (!this.getSnack(Hand.MAIN_HAND).func_190926_b()) {
            return this.getSnack(Hand.MAIN_HAND);
        }
        if (!this.getSnack(Hand.OFF_HAND).func_190926_b()) {
            return this.getSnack(Hand.OFF_HAND);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getSnack(Hand hand) {
        ItemStack snack = this.func_184586_b(hand);
        if (this.isSnack(snack)) {
            return snack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(NeapolitanTags.Items.CHIMPANZEE_FOOD);
    }

    public boolean isSnack(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(NeapolitanTags.Items.CHIMPANZEE_SNACKS);
    }

    public int getDirtiness() {
        return (Integer)this.field_70180_af.func_187225_a(DIRTINESS);
    }

    public void setDirtiness(int amount) {
        this.field_70180_af.func_187227_b(DIRTINESS, (Object)amount);
    }

    public boolean isDirty() {
        return this.getDirtiness() >= 12000;
    }

    public void getCleaned() {
        this.setDirtiness(0);
        this.setHandDyed(false, HandSide.LEFT);
        this.setHandDyed(false, HandSide.RIGHT);
    }

    public int getPaleness() {
        return (Integer)this.field_70180_af.func_187225_a(PALENESS);
    }

    public void setPaleness(int amount) {
        this.field_70180_af.func_187227_b(PALENESS, (Object)amount);
    }

    public boolean needsSunlight() {
        return this.getPaleness() >= 6000;
    }

    public float getVisiblePaleness() {
        return MathHelper.func_76131_a((float)(((float)this.getPaleness() - 4800.0f) / 1200.0f), (float)0.0f, (float)1.0f);
    }

    public boolean isInSunlight() {
        BlockPos blockpos = this.func_184187_bx() instanceof BoatEntity ? new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_()).func_177984_a() : new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_());
        return this.field_70170_p.func_226658_a_(LightType.SKY, blockpos) > 8;
    }

    public ChimpanzeeAction getAction() {
        return ChimpanzeeAction.byId(((Byte)this.field_70180_af.func_187225_a(ACTION)).byteValue());
    }

    public boolean isDoingAction(ChimpanzeeAction ... actions) {
        for (ChimpanzeeAction action : actions) {
            if (this.getAction() != action) continue;
            return true;
        }
        return false;
    }

    public void setAction(ChimpanzeeAction action) {
        this.field_70180_af.func_187227_b(ACTION, (Object)((byte)action.getId()));
    }

    public void setDefaultAction() {
        boolean flag;
        boolean bl = flag = !this.func_184218_aH() && this.shouldClimb();
        if (flag) {
            this.setAction(ChimpanzeeAction.CLIMBING);
        } else {
            this.setAction(ChimpanzeeAction.DEFAULT);
        }
    }

    public boolean isPartying() {
        return this.isPartying;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isPartying = isPartying;
    }

    public boolean isMouthOpen() {
        if (this.isDoingAction(ChimpanzeeAction.EATING)) {
            return Math.sin(Math.PI * (double)this.field_70173_aa * 0.2) > 0.0;
        }
        if (this.isDoingAction(ChimpanzeeAction.CRYING, ChimpanzeeAction.PLAYING_WITH_ITEM, ChimpanzeeAction.PLAYING_WITH_HELMET, ChimpanzeeAction.JUMPING, ChimpanzeeAction.DRUMMING)) {
            return true;
        }
        return this.getApeModeTime() > 0 || this.func_233678_J__() || this.isHungry() || this.isPartying();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getClimbingAnim(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.climbAnim0, (float)this.climbAnim);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSitAnim(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.sitAnim0, (float)this.sitAnim);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadShakeAnim(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.headShakeAnim0, (float)this.headShakeAnim);
    }

    public void swingArms() {
        this.attackTimer = 10;
    }

    public void shakeHead() {
        this.headShakeAnim = 40;
        this.headShakeAnim0 = 40;
    }

    public void shakeHead(IParticleData particleData) {
        this.shakeHead();
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_195594_a(particleData, this.func_226277_ct_(), this.func_226283_e_(1.0), this.func_226281_cx_(), d0, d1, d2);
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            this.swingArms();
        } else if (id == 6) {
            this.shakeHead((IParticleData)NeapolitanParticles.CHIMPANZEE_NEEDS_FRIEND.get());
        } else if (id == 7) {
            this.shakeHead((IParticleData)NeapolitanParticles.CHIMPANZEE_NEEDS_SUN.get());
        } else if (id == 8) {
            this.shakeHead((IParticleData)NeapolitanParticles.CHIMPANZEE_NEEDS_FOOD.get());
        } else {
            super.func_70103_a(id);
        }
    }

    class BodyHelperController
    extends BodyController {
        private int bodyRotationTickCounter;
        private Direction prevFacing;

        public BodyHelperController() {
            super((MobEntity)ChimpanzeeEntity.this);
        }

        public void func_75664_a() {
            super.func_75664_a();
            Direction facing = ChimpanzeeEntity.this.getFacing();
            if (facing != this.prevFacing || !ChimpanzeeEntity.this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
                this.bodyRotationTickCounter = 10;
            }
            this.prevFacing = facing;
            if (facing != Direction.DOWN && ChimpanzeeEntity.this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
                int i = this.bodyRotationTickCounter;
                float f = MathHelper.func_76131_a((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
                float f1 = 90.0f * f;
                ChimpanzeeEntity.this.field_70761_aq = MathHelper.func_219800_b((float)ChimpanzeeEntity.this.field_70761_aq, (float)facing.func_185119_l(), (float)f1);
                if (this.bodyRotationTickCounter > 0) {
                    --this.bodyRotationTickCounter;
                }
            } else if (facing != Direction.DOWN && ChimpanzeeEntity.this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
                int i = this.bodyRotationTickCounter;
                float f = MathHelper.func_76131_a((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
                float f1 = 90.0f * f;
                ChimpanzeeEntity.this.field_70761_aq = MathHelper.func_219800_b((float)ChimpanzeeEntity.this.field_70761_aq, (float)facing.func_185119_l(), (float)f1);
                if (this.bodyRotationTickCounter > 0) {
                    --this.bodyRotationTickCounter;
                }
            }
        }
    }

    class LookHelperController
    extends LookController {
        public LookHelperController() {
            super((MobEntity)ChimpanzeeEntity.this);
        }

        public void func_75649_a() {
            if (this.func_220680_b()) {
                ChimpanzeeEntity.this.field_70125_A = 0.0f;
            }
            if (this.field_75655_d) {
                this.field_75655_d = false;
                ChimpanzeeEntity.this.field_70759_as = this.func_220675_a(ChimpanzeeEntity.this.field_70759_as, this.func_220678_h(), this.field_75657_b);
                ChimpanzeeEntity.this.field_70125_A = this.func_220675_a(ChimpanzeeEntity.this.field_70125_A, this.func_220677_g(), this.field_75658_c);
            } else {
                ChimpanzeeEntity.this.field_70759_as = this.func_220675_a(ChimpanzeeEntity.this.field_70759_as, ChimpanzeeEntity.this.field_70761_aq, 10.0f);
            }
            Direction facing = ChimpanzeeEntity.this.getFacing();
            if (ChimpanzeeEntity.this.isDoingAction(ChimpanzeeAction.CLIMBING) && facing != Direction.DOWN) {
                ChimpanzeeEntity.this.field_70759_as = MathHelper.func_219800_b((float)ChimpanzeeEntity.this.field_70759_as, (float)facing.func_185119_l(), (float)ChimpanzeeEntity.this.func_184649_cE());
            } else if (!ChimpanzeeEntity.this.func_70661_as().func_75500_f()) {
                ChimpanzeeEntity.this.field_70759_as = MathHelper.func_219800_b((float)ChimpanzeeEntity.this.field_70759_as, (float)ChimpanzeeEntity.this.field_70761_aq, (float)ChimpanzeeEntity.this.func_184649_cE());
            }
        }
    }
}

