/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class MintBlock
extends BushBlock
implements IPlantable,
IGrowable {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)4);
    public static final IntegerProperty SPROUTS = IntegerProperty.func_177719_a((String)"sprouts", (int)1, (int)4);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)};

    public MintBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SPROUTS, (Comparable)Integer.valueOf(1)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!this.isMaxAge(state) && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (this.isMaxAge(state)) {
            MintBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)NeapolitanItems.MINT_LEAVES.get(), ((Integer)state.func_177229_b((Property)SPROUTS)).intValue()));
            worldIn.func_184133_a(null, pos, SoundEvents.field_219625_by, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)SPROUTS) < 4 || super.func_196253_a(state, useContext);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)NeapolitanItems.MINT_SPROUT.get());
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (worldIn.func_226659_b_(pos, 0) >= 9 && !this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(9) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        } else if (this.isMaxAge(state) && random.nextInt(3) != 0) {
            MintBlock.spawnGrowthParticles(worldIn, pos, random);
            Direction.Plane.HORIZONTAL.func_239636_a_().forEach(direction -> {
                BlockPos offsetPos = pos.func_177972_a(direction);
                BlockState offsetState = worldIn.func_180495_p(offsetPos);
                if (!offsetState.func_235714_a_(NeapolitanTags.Blocks.UNAFFECTED_BY_MINT)) {
                    offsetState.func_227034_b_(worldIn, offsetPos, random);
                }
            });
        }
    }

    private static void spawnGrowthParticles(ServerWorld worldIn, BlockPos posIn, Random random) {
        BlockState blockstate = worldIn.func_180495_p(posIn);
        if (!blockstate.isAir((IBlockReader)worldIn, posIn)) {
            double d1 = blockstate.func_196954_c((IBlockReader)worldIn, posIn).func_197758_c(Direction.Axis.Y);
            for (int i = 0; i < 8; ++i) {
                double d8;
                double d7;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                double d4 = random.nextGaussian() * 0.02;
                double d6 = (double)posIn.func_177958_n() + random.nextDouble();
                if (worldIn.func_180495_p(new BlockPos(d6, d7 = (double)posIn.func_177956_o() + random.nextDouble() * d1, d8 = (double)posIn.func_177952_p() + random.nextDouble()).func_177977_b()).func_196958_f()) continue;
                NetworkUtil.spawnParticle((String)"neapolitan:mint_boost", (double)d6, (double)d7, (double)d8, (double)d2, (double)d3, (double)d4);
            }
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_203425_a((Block)this)) {
            return (BlockState)blockstate.func_206870_a((Property)SPROUTS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((Property)SPROUTS) + 1)));
        }
        return super.func_196258_a(context);
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) >= 4;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, SPROUTS});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)AGE)];
    }

    public boolean func_176473_a(IBlockReader block, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.func_177229_b((Property)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

