/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.minecraftabnormals.neapolitan.common.item.MilkBottleItem;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MilkCauldronBlock
extends Block {
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208130_ae;
    private static final VoxelShape INSIDE = MilkCauldronBlock.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)MilkCauldronBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{MilkCauldronBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), MilkCauldronBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public MilkCauldronBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return INSIDE;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity living;
        int i = (Integer)state.func_177229_b((Property)LEVEL);
        float f = (float)pos.func_177956_o() + (6.0f + (float)(3 * i)) / 16.0f;
        if (!worldIn.field_72995_K && entityIn instanceof LivingEntity && i > 0 && entityIn.func_226278_cu_() <= (double)f && !(living = (LivingEntity)entityIn).func_70651_bq().isEmpty()) {
            MilkBottleItem.clearRandomEffect(worldIn, living);
            this.setMilkLevel(worldIn, pos, i - 1);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (itemstack.func_190926_b()) {
            return ActionResultType.PASS;
        }
        int i = (Integer)state.func_177229_b((Property)LEVEL);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151117_aB) {
            if (i < 3 && !worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                player.func_195066_a(Stats.field_188077_K);
                this.setMilkLevel(worldIn, pos, 3);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (item == Items.field_151133_ar) {
            if (i == 3 && !worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151117_aB));
                    } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151117_aB))) {
                        player.func_71019_a(new ItemStack((IItemProvider)Items.field_151117_aB), false);
                    }
                }
                player.func_195066_a(Stats.field_188078_L);
                this.setMilkLevel(worldIn, pos, 0);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (item == Items.field_151069_bo) {
            if (i > 0 && !worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack stack = new ItemStack((IItemProvider)NeapolitanItems.MILK_BOTTLE.get());
                    player.func_195066_a(Stats.field_188078_L);
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(handIn, stack);
                    } else if (!player.field_71071_by.func_70441_a(stack)) {
                        player.func_71019_a(stack, false);
                    } else if (player instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                    }
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.setMilkLevel(worldIn, pos, i - 1);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (item == NeapolitanItems.MILK_BOTTLE.get()) {
            if (i < 3 && !worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                    ItemStack returnStack = new ItemStack((IItemProvider)Items.field_151069_bo);
                    if (!player.field_71071_by.func_70441_a(returnStack)) {
                        player.func_71019_a(returnStack, false);
                    }
                    player.func_195066_a(Stats.field_188078_L);
                    if (player instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                    }
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.setMilkLevel(worldIn, pos, i + 1);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public void setMilkLevel(World worldIn, BlockPos pos, int level) {
        int newLevel = MathHelper.func_76125_a((int)level, (int)0, (int)3);
        BlockState state = newLevel != 0 ? ((Block)NeapolitanBlocks.MILK_CAULDRON.get()).func_176223_P() : Blocks.field_150383_bp.func_176223_P();
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)), 2);
        worldIn.func_175666_e(pos, (Block)this);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((Property)LEVEL);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LEVEL});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)Items.field_222089_ms);
    }
}

