/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.client.renderer;

import com.minecraftabnormals.neapolitan.client.model.ChimpanzeeModel;
import com.minecraftabnormals.neapolitan.client.renderer.layers.ChimpanzeeDirtLayer;
import com.minecraftabnormals.neapolitan.client.renderer.layers.ChimpanzeeDyeLayer;
import com.minecraftabnormals.neapolitan.client.renderer.layers.ChimpanzeeItemLayer;
import com.minecraftabnormals.neapolitan.client.renderer.layers.ChimpanzeePaleSkinLayer;
import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Locale;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChimpanzeeRenderer
extends MobRenderer<ChimpanzeeEntity, ChimpanzeeModel<ChimpanzeeEntity>> {
    public ChimpanzeeRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new ChimpanzeeModel(), 0.4f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new ChimpanzeeModel(0.5f, true, true), new ChimpanzeeModel(1.0f, true, false)));
        this.func_177094_a(new ChimpanzeePaleSkinLayer(this));
        this.func_177094_a(new ChimpanzeeDirtLayer(this));
        this.func_177094_a(new ChimpanzeeDyeLayer(this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a(new ChimpanzeeItemLayer(this));
    }

    public ResourceLocation getTextureLocation(ChimpanzeeEntity entity) {
        ChimpanzeeTypes type = ChimpanzeeTypes.byId(entity.getChimpanzeeType());
        String textureend = entity.isMouthOpen() ? "_chimpanzee_mouth_open.png" : "_chimpanzee.png";
        return new ResourceLocation("neapolitan", "textures/entity/chimpanzee/" + type.name().toLowerCase(Locale.ROOT) + textureend);
    }

    public void render(ChimpanzeeEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean isShaking(ChimpanzeeEntity entityIn) {
        return entityIn.getApeModeTime() > 0;
    }
}

