/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.client.model;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelHelper;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChimpanzeeModel<T extends ChimpanzeeEntity>
extends BipedModel<T> {
    public ModelRenderer leftEar;
    public ModelRenderer rightEar;
    protected ModelRenderer bodyDefault;
    protected ModelRenderer headDefault;
    protected ModelRenderer leftEarDefault;
    protected ModelRenderer rightEarDefault;
    protected ModelRenderer leftArmDefault;
    protected ModelRenderer rightArmDefault;
    protected ModelRenderer leftLegDefault;
    protected ModelRenderer rightLegDefault;

    public ChimpanzeeModel() {
        this(0.0f, false, false);
    }

    public ChimpanzeeModel(float modelSize, boolean isArmor, boolean isInner) {
        super(modelSize);
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        if (isArmor) {
            this.field_78116_c = new ModelRenderer((Model)this);
            this.field_78116_c.func_78793_a(0.0f, 1.0f, 0.5f);
            this.field_78116_c.func_78784_a(0, 0).func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSize);
            this.field_78115_e = new ModelRenderer((Model)this);
            this.field_78115_e.func_78793_a(0.0f, 5.0f, 0.5f);
            this.field_78115_e.func_78784_a(16, 16).func_228301_a_(-4.0f, -0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelSize);
            if (isInner) {
                this.field_178722_k = new ModelRenderer((Model)this);
                this.field_178722_k.func_78793_a(2.5f, 13.0f, 0.5f);
                this.field_178722_k.func_78784_a(0, 16).func_228303_a_(-2.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize, true);
                this.field_178721_j = new ModelRenderer((Model)this);
                this.field_178721_j.func_78793_a(-2.5f, 13.0f, 0.5f);
                this.field_178721_j.func_78784_a(0, 16).func_228301_a_(-1.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
            } else {
                this.field_178722_k = new ModelRenderer((Model)this);
                this.field_178722_k.func_78793_a(2.5f, 13.0f, 0.5f);
                this.field_178722_k.func_78784_a(0, 16).func_228303_a_(-2.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize, true);
                this.field_178721_j = new ModelRenderer((Model)this);
                this.field_178721_j.func_78793_a(-2.5f, 13.0f, 0.5f);
                this.field_178721_j.func_78784_a(0, 16).func_228301_a_(-1.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
            }
            this.leftEar = new ModelRenderer((Model)this);
            this.rightEar = new ModelRenderer((Model)this);
            this.field_178724_i = new ModelRenderer((Model)this);
            this.field_178724_i.func_78793_a(5.0f, 6.5f, 0.5f);
            this.field_178724_i.func_78784_a(40, 16).func_228303_a_(-1.0f, -1.5f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize, true);
            this.field_178723_h = new ModelRenderer((Model)this);
            this.field_178723_h.func_78793_a(-5.0f, 6.5f, 0.5f);
            this.field_178723_h.func_78784_a(40, 16).func_228301_a_(-3.0f, -1.5f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        } else {
            this.field_78116_c = new ModelRenderer((Model)this);
            this.field_78116_c.func_78793_a(0.0f, 5.0f, 0.5f);
            this.field_78116_c.func_78784_a(1, 1).func_228301_a_(-4.0f, -8.0f, -3.0f, 8.0f, 8.0f, 6.0f, modelSize);
            this.field_78116_c.func_78784_a(30, 11).func_228301_a_(-2.0f, -5.0f, -4.0f, 4.0f, 5.0f, 1.0f, modelSize);
            this.field_78115_e = new ModelRenderer((Model)this);
            this.field_78115_e.func_78793_a(0.0f, 5.0f, 0.5f);
            this.field_78115_e.func_78784_a(37, 0).func_228301_a_(-5.0f, -0.0f, -1.5f, 10.0f, 8.0f, 3.0f, modelSize);
            this.leftEar = new ModelRenderer((Model)this);
            this.leftEar.func_78793_a(4.0f, -5.0f, 0.0f);
            this.field_78116_c.func_78792_a(this.leftEar);
            this.leftEar.func_78784_a(25, 1).func_228303_a_(0.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, modelSize, true);
            this.rightEar = new ModelRenderer((Model)this);
            this.rightEar.func_78793_a(-4.0f, -3.0f, 0.0f);
            this.field_78116_c.func_78792_a(this.rightEar);
            this.rightEar.func_78784_a(25, 1).func_228301_a_(-2.0f, -4.0f, -1.0f, 2.0f, 3.0f, 1.0f, modelSize);
            this.field_178724_i = new ModelRenderer((Model)this);
            this.field_178724_i.func_78793_a(5.0f, 6.5f, 0.5f);
            this.field_178724_i.func_78784_a(14, 17).func_228303_a_(0.0f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f, modelSize, true);
            this.field_178723_h = new ModelRenderer((Model)this);
            this.field_178723_h.func_78793_a(-5.0f, 6.5f, 0.5f);
            this.field_178723_h.func_78784_a(1, 17).func_228301_a_(-3.0f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f, modelSize);
            this.field_178722_k = new ModelRenderer((Model)this);
            this.field_178722_k.func_78793_a(2.5f, 13.0f, 0.5f);
            this.field_178722_k.func_78784_a(40, 17).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f, modelSize, true);
            this.field_178721_j = new ModelRenderer((Model)this);
            this.field_178721_j.func_78793_a(-2.5f, 13.0f, 0.5f);
            this.field_178721_j.func_78784_a(27, 17).func_228301_a_(-1.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f, modelSize);
        }
        this.field_178720_f = new ModelRenderer((Model)this);
        this.bodyDefault = this.field_78115_e.func_241662_a_();
        this.headDefault = this.field_78116_c.func_241662_a_();
        this.leftEarDefault = this.leftEar.func_241662_a_();
        this.rightEarDefault = this.rightEar.func_241662_a_();
        this.leftArmDefault = this.field_178724_i.func_241662_a_();
        this.rightArmDefault = this.field_178723_h.func_241662_a_();
        this.leftLegDefault = this.field_178722_k.func_241662_a_();
        this.rightLegDefault = this.field_178721_j.func_241662_a_();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f1;
        float f;
        float partialtick = ageInTicks - (float)((ChimpanzeeEntity)((Object)entity)).field_70173_aa;
        float fullclimbanim = ((ChimpanzeeEntity)((Object)entity)).getClimbingAnim(partialtick);
        float climbanim = Math.min(fullclimbanim * 5.0f / 3.0f, 1.0f);
        int attacktimer = ((ChimpanzeeEntity)((Object)entity)).getAttackTimer();
        int earstate = this.getEarState(entity);
        boolean apemode = ((ChimpanzeeEntity)((Object)entity)).getApeModeTime() > 0;
        HandSide mainhand = entity.func_184591_cq();
        this.field_78115_e.func_217177_a(this.bodyDefault);
        this.field_78116_c.func_217177_a(this.headDefault);
        this.leftEar.func_217177_a(this.leftEarDefault);
        this.rightEar.func_217177_a(this.rightEarDefault);
        this.field_178724_i.func_217177_a(this.leftArmDefault);
        this.field_178723_h.func_217177_a(this.rightArmDefault);
        this.field_178722_k.func_217177_a(this.leftLegDefault);
        this.field_178721_j.func_217177_a(this.rightLegDefault);
        if (earstate == 2) {
            this.leftEar.field_78806_j = false;
            this.rightEar.field_78806_j = false;
        } else {
            if (earstate == 1) {
                this.leftEar.field_78796_g = -1.5707964f;
                this.leftEar.field_78800_c -= 0.1f;
                this.rightEar.field_78796_g = 1.5707964f;
                this.rightEar.field_78800_c += 0.1f;
            }
            this.leftEar.field_78806_j = true;
            this.rightEar.field_78806_j = true;
        }
        if (this.field_217114_e) {
            this.field_78116_c.field_78797_d -= 1.6f;
        }
        this.field_78116_c.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.field_78116_c.field_78795_f = headPitch * ((float)Math.PI / 180);
        if (((ChimpanzeeEntity)((Object)entity)).isPartying()) {
            this.field_178723_h.field_78795_f = (1.0f - climbanim) * (float)(-Math.PI);
            this.field_178724_i.field_78795_f = (1.0f - climbanim) * (float)(-Math.PI);
        } else {
            f = apemode ? 1.4f : 1.0f;
            this.field_178723_h.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f * f;
            this.field_178724_i.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f * f;
            if (!entity.func_184614_ca().func_190926_b()) {
                this.func_187074_a((HandSide)mainhand).field_78795_f -= 0.31415927f;
            }
            if (!entity.func_184592_cb().func_190926_b()) {
                this.func_187074_a((HandSide)mainhand.func_188468_a()).field_78795_f -= 0.31415927f;
            }
        }
        if (this.field_217113_d) {
            if (!((ChimpanzeeEntity)((Object)entity)).isPartying()) {
                this.field_178723_h.field_78795_f += -0.62831855f;
                this.field_178724_i.field_78795_f += -0.62831855f;
            }
            this.field_178721_j.field_78795_f = -1.4137167f;
            this.field_178721_j.field_78796_g = 0.31415927f;
            this.field_178721_j.field_78808_h = 0.07853982f;
            this.field_178722_k.field_78795_f = -1.4137167f;
            this.field_178722_k.field_78796_g = -0.31415927f;
            this.field_178722_k.field_78808_h = -0.07853982f;
        } else {
            f = ((ChimpanzeeEntity)((Object)entity)).getSitAnim(partialtick);
            if (f > 0.0f) {
                if (!((ChimpanzeeEntity)((Object)entity)).isPartying()) {
                    this.field_178723_h.field_78795_f += f * -0.62831855f;
                    this.field_178724_i.field_78795_f += f * -0.62831855f;
                }
                this.field_78115_e.field_78797_d += f * 10.0f;
                this.field_78116_c.field_78797_d = this.field_78116_c.field_78797_d + f * (this.field_217114_e ? 6.5f : 10.0f);
                this.field_178723_h.field_78797_d += f * 10.0f;
                this.field_178724_i.field_78797_d += f * 10.0f;
                this.field_178721_j.field_78797_d += f * 10.0f;
                this.field_178721_j.field_78798_e += f;
                this.field_178722_k.field_78797_d += f * 10.0f;
                this.field_178722_k.field_78798_e += f;
                this.field_178721_j.field_78795_f = f * -1.5707964f;
                this.field_178721_j.field_78796_g = f * 0.31415927f;
                this.field_178722_k.field_78795_f = f * -1.5707964f;
                this.field_178722_k.field_78796_g = f * -0.31415927f;
            }
            if (!((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.SHAKING)) {
                this.field_178721_j.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                this.field_178722_k.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            }
        }
        if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.EATING)) {
            f = MathHelper.func_76126_a((float)(ageInTicks * 0.7f));
            this.field_78116_c.field_78795_f = -f * 0.2f;
            this.field_78116_c.field_78796_g = 0.0f;
            this.field_178723_h.field_78795_f = f * 0.4f - 1.7f;
            this.field_178724_i.field_78795_f = f * 0.4f - 1.7f;
            this.field_178723_h.field_78796_g = -0.6f;
            this.field_178724_i.field_78796_g = 0.6f;
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.GROOMING)) {
            f = MathHelper.func_76126_a((float)(ageInTicks * 0.5f));
            this.field_178723_h.field_78795_f = f * 0.4f - 1.5707964f;
            this.field_178724_i.field_78795_f = -f * 0.4f - 1.5707964f;
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.SHAKING)) {
            f = MathHelper.func_76126_a((float)(ageInTicks * 0.82f)) * 1.4f;
            f1 = MathHelper.func_76134_b((float)(ageInTicks * 0.82f)) * 1.8f;
            this.field_78116_c.field_78797_d += f1 + 1.5f;
            this.field_78116_c.field_78798_e += f;
            this.field_78115_e.field_78797_d += f1 + 1.5f;
            this.field_78115_e.field_78798_e += f;
            this.field_178723_h.field_78797_d += 1.5f;
            this.field_178723_h.field_78798_e += f * 0.5f;
            this.field_178724_i.field_78797_d += 1.5f;
            this.field_178724_i.field_78798_e += f * 0.5f;
            this.field_178721_j.field_78797_d += f1 + 1.5f;
            this.field_178721_j.field_78798_e += f;
            this.field_178722_k.field_78797_d += f1 + 1.5f;
            this.field_178722_k.field_78798_e += f;
            this.field_178721_j.field_78795_f = f * 0.35f - 0.31415927f;
            this.field_178722_k.field_78795_f = f * 0.35f - 0.31415927f;
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.CRYING)) {
            f = MathHelper.func_76126_a((float)(ageInTicks * 0.7f));
            this.field_78116_c.field_78795_f = 0.3f - f * 0.2f;
            this.field_78116_c.field_78796_g = 0.0f;
            this.field_178724_i.field_78795_f = f * 0.4f - 1.7f;
            this.field_178724_i.field_78796_g = 0.5f;
            this.field_178723_h.field_78795_f = f * 0.4f - 1.7f;
            this.field_178723_h.field_78796_g = -0.5f;
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.LOOKING_AT_ITEM)) {
            this.field_78116_c.field_78795_f = 0.5f;
            this.field_78116_c.field_78796_g = 0.0f;
            if (entity.func_184638_cS()) {
                this.field_178724_i.field_78796_g = 0.5f;
                this.field_178724_i.field_78795_f = -0.9f;
            } else {
                this.field_178723_h.field_78796_g = -0.5f;
                this.field_178723_h.field_78795_f = -0.9f;
            }
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.PLAYING_WITH_ITEM)) {
            f = MathHelper.func_76126_a((float)(ageInTicks * 0.6f));
            this.field_78116_c.field_78795_f = -0.1f + MathHelper.func_76126_a((float)(ageInTicks * 0.6f - 0.5f)) * 0.1f;
            if (entity.func_184638_cS()) {
                this.field_178724_i.field_78795_f = f * 0.5f - 1.8f;
                this.field_78116_c.field_78796_g = -0.5f;
            } else {
                this.field_178723_h.field_78795_f = f * 0.5f - 1.8f;
                this.field_78116_c.field_78796_g = 0.5f;
            }
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.PLAYING_WITH_HELMET)) {
            this.field_78116_c.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.55f)) * 0.5f;
            this.field_78116_c.field_78796_g = 0.0f;
            this.field_78116_c.field_78808_h = MathHelper.func_76126_a((float)(ageInTicks * 0.55f)) * 0.3f;
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.JUMPING)) {
            f = -Math.abs(MathHelper.func_76126_a((float)(ageInTicks * 0.2f)));
            this.field_178723_h.field_78800_c += 1.0f;
            this.field_178724_i.field_78800_c += -1.0f;
            this.field_178723_h.field_78795_f = (float)(-Math.PI);
            this.field_178724_i.field_78795_f = (float)(-Math.PI);
            this.field_178723_h.field_78808_h = f * 0.4f - 0.4f;
            this.field_178724_i.field_78808_h = -f * 0.4f + 0.4f;
        } else if (((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.DRUMMING)) {
            f = -Math.abs(MathHelper.func_76126_a((float)(ageInTicks * 0.3f)));
            f1 = -Math.abs(MathHelper.func_76126_a((float)(ageInTicks * 0.3f + 1.5707964f)));
            this.field_178723_h.field_78795_f = f - 0.9f;
            this.field_178724_i.field_78795_f = f1 - 0.9f;
            this.field_178723_h.field_78796_g = -0.5f;
            this.field_178724_i.field_78796_g = 0.5f;
        } else {
            f = ((ChimpanzeeEntity)((Object)entity)).getHeadShakeAnim(partialtick);
            if (f > 0.0f) {
                this.field_78116_c.field_78796_g = MathHelper.func_76126_a((float)(f * (float)Math.PI / 8.0f)) * 0.3f;
                this.field_78116_c.field_78795_f = 0.6f;
            }
        }
        this.field_178723_h.field_78795_f += -fullclimbanim * (float)Math.PI;
        this.field_178724_i.field_78795_f += -fullclimbanim * (float)Math.PI;
        this.field_178723_h.field_78796_g += climbanim * 0.6f;
        this.field_178724_i.field_78796_g += -climbanim * 0.6f;
        this.field_178721_j.field_78795_f += -climbanim * (float)Math.PI * 0.2f;
        this.field_178722_k.field_78795_f += -climbanim * (float)Math.PI * 0.2f;
        if (!((ChimpanzeeEntity)((Object)entity)).isDoingAction(ChimpanzeeAction.CLIMBING, ChimpanzeeAction.HANGING, ChimpanzeeAction.SHAKING)) {
            ModelHelper.func_239101_a_((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178724_i, (float)ageInTicks);
        }
        if (((ChimpanzeeEntity)((Object)entity)).isPartying()) {
            f = MathHelper.func_76134_b((float)(ageInTicks * 0.75f)) * 0.5f;
            f1 = MathHelper.func_76126_a((float)(ageInTicks * 0.75f)) * 0.5f;
            this.field_78116_c.field_78800_c += f;
            this.field_78115_e.field_78800_c += f;
            this.field_178723_h.field_78800_c += f;
            this.field_178724_i.field_78800_c += f;
            this.field_78116_c.field_78798_e += f1;
            this.field_78115_e.field_78798_e += f1;
            this.field_178723_h.field_78798_e += f1;
            this.field_178724_i.field_78798_e += f1;
            this.field_178723_h.field_78795_f += f * 0.1f;
            this.field_178724_i.field_78795_f += f * 0.1f;
            this.field_178723_h.field_78808_h += f1 * 0.2f - 0.1f;
            this.field_178724_i.field_78808_h += f1 * 0.2f + 0.1f;
        }
        if (attacktimer > 0) {
            this.field_178723_h.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)attacktimer - partialtick), (float)10.0f);
            this.field_178724_i.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)attacktimer - partialtick), (float)10.0f);
            this.field_178723_h.field_78796_g = 0.0f;
            this.field_178724_i.field_78796_g = 0.0f;
        }
    }

    protected HandSide getMainHand(T entityIn) {
        HandSide handside = entityIn.func_184591_cq();
        return ((ChimpanzeeEntity)((Object)entityIn)).field_184622_au == Hand.MAIN_HAND ? handside : handside.func_188468_a();
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.field_78116_c);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.field_78115_e, (Object)this.field_178724_i, (Object)this.field_178723_h, (Object)this.field_178722_k, (Object)this.field_178721_j);
    }

    public ModelRenderer func_205072_a() {
        return this.field_78116_c;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        this.func_187074_a(sideIn).func_228307_a_(matrixStackIn);
    }

    private int getEarState(T entity) {
        ItemStack itemstack = entity.func_184582_a(EquipmentSlotType.HEAD);
        if (itemstack != null) {
            Item item = itemstack.func_77973_b();
            if (item.func_206844_a(NeapolitanTags.Items.HIDES_CHIMPANZEE_EARS)) {
                return 2;
            }
            if (item instanceof BlockItem) {
                return 1;
            }
            if (item instanceof ArmorItem && ((ArmorItem)item).func_185083_B_() == EquipmentSlotType.HEAD) {
                return 1;
            }
        }
        return 0;
    }
}

