/*
 * Decompiled with CFR 0.152.
 */
package com.chicken.muchmoremodcompat.setup;

import com.chicken.muchmoremodcompat.blocks.AlphaBeamBlock;
import com.chicken.muchmoremodcompat.blocks.AlphaPalisadeBlock;
import com.chicken.muchmoremodcompat.blocks.AlphaSeatBlock;
import com.chicken.muchmoremodcompat.blocks.AlphaSupportBlock;
import com.chicken.muchmoremodcompat.blocks.GlowBrazierBlock;
import com.chicken.muchmoremodcompat.blocks.GlowChandelierBlock;
import com.chicken.muchmoremodcompat.datagen.types.BambooBlocksWoodTypes;
import com.chicken.muchmoremodcompat.datagen.types.CompatWoodTypes;
import com.chicken.muchmoremodcompat.setup.ModSetup;
import com.google.common.collect.ImmutableMap;
import com.lilypuree.decorative_blocks.blocks.BeamBlock;
import com.lilypuree.decorative_blocks.blocks.BrazierBlock;
import com.lilypuree.decorative_blocks.blocks.ChainBlock;
import com.lilypuree.decorative_blocks.blocks.ChandelierBlock;
import com.lilypuree.decorative_blocks.blocks.PalisadeBlock;
import com.lilypuree.decorative_blocks.blocks.SeatBlock;
import com.lilypuree.decorative_blocks.blocks.SupportBlock;
import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.items.BurnableBlockItem;
import com.minecraftabnormals.abnormals_core.core.util.registry.BlockSubRegistryHelper;
import com.minecraftabnormals.autumnity.common.block.AutumnityJackOLanternBlock;
import com.minecraftabnormals.autumnity.common.block.CarvedLargePumpkinSliceBlock;
import com.minecraftabnormals.autumnity.core.Autumnity;
import com.minecraftabnormals.autumnity.core.other.AutumnityProperties;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Registration {
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final AbstractBlock.Properties goldChainProperties;
    public static final RegistryObject<ChainBlock> GOLD_CHAIN;
    public static final AbstractBlock.Properties iceChainProperties;
    public static final RegistryObject<ChainBlock> ICE_CHAIN;
    public static final RegistryObject<ChandelierBlock> GLOW_CHANDELIER;
    public static final RegistryObject<BrazierBlock> GLOW_BRAZIER;
    public static final RegistryObject<PalisadeBlock> GLOWSHROOM_PALISADE;
    public static final RegistryObject<BeamBlock> GLOWSHROOM_BEAM;
    public static final RegistryObject<SupportBlock> GLOWSHROOM_SUPPORT;
    public static final RegistryObject<SeatBlock> GLOWSHROOM_SEAT;
    public static final AbstractBlock.Properties bambooBlockProperties;
    public static final RegistryObject<SupportBlock> BAMBOO_SUPPORT;
    public static final RegistryObject<SeatBlock> BAMBOO_SEAT;
    public static final BlockSubRegistryHelper HELPER;
    public static final RegistryObject<Block> GLOW_JACK_O_LANTERN;
    public static final RegistryObject<Block> LARGE_GLOW_JACK_O_LANTERN_SLICE;
    public static final Item.Properties modItemProperties;
    public static final Item.Properties dummyProperty;
    public static final RegistryObject<Item> BAMBOO_SEAT_ITEM;
    public static final RegistryObject<Item> BAMBOO_SUPPORT_ITEM;
    public static final RegistryObject<Item> GLOWSHROOM_SEAT_ITEM;
    public static final RegistryObject<Item> GLOWSHROOM_SUPPORT_ITEM;
    public static final RegistryObject<Item> GLOWSHROOM_BEAM_ITEM;
    public static final RegistryObject<Item> GLOWSHROOM_PALISADE_ITEM;
    public static final RegistryObject<Item> GLOW_CHANDELIER_ITEM;
    public static final RegistryObject<Item> GLOW_BRAZIER_ITEM;
    public static final RegistryObject<Item> GOLD_CHAIN_ITEM;
    public static final RegistryObject<Item> ICE_CHAIN_ITEM;
    public static final ImmutableMap<String, RegistryObject<Block>> muchmoremodcompat;
    public static final ImmutableMap<String, RegistryObject<Item>> DECORATIVE_ITEMBLOCKS;

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
    }

    public static Block getWoodDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes decorativeBlockType) {
        String name = wood + "_" + decorativeBlockType;
        return (Block)((RegistryObject)muchmoremodcompat.get((Object)name)).get();
    }

    public static RotatedPillarBlock getBeamBlock(IWoodType wood) {
        return (RotatedPillarBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.BEAM);
    }

    public static PalisadeBlock getPalisadeBlock(IWoodType wood) {
        return (PalisadeBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.PALISADE);
    }

    public static SeatBlock getSeatBlock(IWoodType wood) {
        return (SeatBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SEAT);
    }

    public static SupportBlock getSupportBlock(IWoodType wood) {
        return (SupportBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SUPPORT);
    }

    private static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        AbstractBlock.Properties woodProperty = AbstractBlock.Properties.func_200949_a((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).func_200943_b(1.2f).func_200947_a(wood.getSoundType());
        AbstractBlock.Properties palisadeProperty = AbstractBlock.Properties.func_200949_a((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).func_200948_a(2.0f, 4.0f).func_200947_a(wood.getSoundType());
        switch (woodDecorativeBlockType) {
            default: {
                return new BeamBlock(woodProperty, wood);
            }
            case SUPPORT: {
                return new SupportBlock(woodProperty, wood);
            }
            case PALISADE: {
                return new PalisadeBlock(palisadeProperty, wood);
            }
            case SEAT: 
        }
        return new SeatBlock(woodProperty, wood);
    }

    static {
        String name;
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"muchmoremodcompat");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"muchmoremodcompat");
        goldChainProperties = AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151647_F).func_200943_b(4.3f).func_200947_a(SoundType.field_185852_e).func_226896_b_();
        GOLD_CHAIN = BLOCKS.register("gold_chain", () -> new ChainBlock(goldChainProperties));
        iceChainProperties = AbstractBlock.Properties.func_200949_a((Material)Material.field_151588_w, (MaterialColor)MaterialColor.field_151649_A).func_200943_b(0.99f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185853_f).func_226896_b_();
        ICE_CHAIN = BLOCKS.register("ice_chain", () -> new ChainBlock(iceChainProperties));
        GLOW_CHANDELIER = BLOCKS.register("glow_chandelier", () -> new GlowChandelierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.3f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235838_a_(state -> 11)));
        GLOW_BRAZIER = BLOCKS.register("glow_brazier", () -> new GlowBrazierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 10 : 0).func_226896_b_()));
        GLOWSHROOM_PALISADE = BLOCKS.register("glowshroom_palisade", () -> new AlphaPalisadeBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 4.0f).func_226896_b_().func_200947_a(SoundType.field_185848_a).func_235838_a_(state -> 14)));
        GLOWSHROOM_BEAM = BLOCKS.register("glowshroom_beam", () -> new AlphaBeamBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235838_a_(state -> 14)));
        GLOWSHROOM_SUPPORT = BLOCKS.register("glowshroom_support", () -> new AlphaSupportBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235838_a_(state -> 14)));
        GLOWSHROOM_SEAT = BLOCKS.register("glowshroom_seat", () -> new AlphaSeatBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235838_a_(state -> 14)));
        bambooBlockProperties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a).func_226896_b_();
        BAMBOO_SUPPORT = BLOCKS.register("bamboo_support", () -> new SupportBlock(bambooBlockProperties, (IWoodType)BambooBlocksWoodTypes.BAMBOO));
        BAMBOO_SEAT = BLOCKS.register("bamboo_seat", () -> new SeatBlock(bambooBlockProperties, (IWoodType)BambooBlocksWoodTypes.BAMBOO));
        HELPER = (BlockSubRegistryHelper)Autumnity.REGISTRY_HELPER.getBlockSubHelper();
        GLOW_JACK_O_LANTERN = HELPER.createCompatBlock("infernalexp", "glow_jack_o_lantern", () -> new AutumnityJackOLanternBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150423_aK).func_235838_a_(AutumnityProperties.getMaxLightValue())), ItemGroup.field_78030_b);
        LARGE_GLOW_JACK_O_LANTERN_SLICE = HELPER.createCompatBlock("infernalexp", "large_glow_jack_o_lantern_slice", () -> new CarvedLargePumpkinSliceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150423_aK).func_235838_a_(AutumnityProperties.getMaxLightValue())), ItemGroup.field_78030_b);
        modItemProperties = new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP);
        dummyProperty = new Item.Properties();
        BAMBOO_SEAT_ITEM = ITEMS.register("bamboo_seat", () -> new BlockItem((Block)BAMBOO_SEAT.get(), modItemProperties));
        BAMBOO_SUPPORT_ITEM = ITEMS.register("bamboo_support", () -> new BlockItem((Block)BAMBOO_SUPPORT.get(), modItemProperties));
        GLOWSHROOM_SEAT_ITEM = ITEMS.register("glowshroom_seat", () -> new BlockItem((Block)GLOWSHROOM_SEAT.get(), modItemProperties));
        GLOWSHROOM_SUPPORT_ITEM = ITEMS.register("glowshroom_support", () -> new BlockItem((Block)GLOWSHROOM_SUPPORT.get(), modItemProperties));
        GLOWSHROOM_BEAM_ITEM = ITEMS.register("glowshroom_beam", () -> new BlockItem((Block)GLOWSHROOM_BEAM.get(), modItemProperties));
        GLOWSHROOM_PALISADE_ITEM = ITEMS.register("glowshroom_palisade", () -> new BlockItem((Block)GLOWSHROOM_PALISADE.get(), modItemProperties));
        GLOW_CHANDELIER_ITEM = ITEMS.register("glow_chandelier", () -> new BurnableBlockItem((Block)GLOW_CHANDELIER.get(), modItemProperties, 1600));
        GLOW_BRAZIER_ITEM = ITEMS.register("glow_brazier", () -> new BlockItem((Block)GLOW_BRAZIER.get(), modItemProperties));
        GOLD_CHAIN_ITEM = ITEMS.register("gold_chain", () -> new BlockItem((Block)GOLD_CHAIN.get(), modItemProperties));
        ICE_CHAIN_ITEM = ITEMS.register("ice_chain", () -> new BlockItem((Block)ICE_CHAIN.get(), modItemProperties));
        ImmutableMap.Builder decorativeBlockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : CompatWoodTypes.allWoodTypes()) {
                name = wood + "_" + type;
                decorativeBlockBuilder.put((Object)name, (Object)BLOCKS.register(name, () -> Registration.createDecorativeBlock(wood, type)));
            }
        }
        muchmoremodcompat = decorativeBlockBuilder.build();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : CompatWoodTypes.allWoodTypes()) {
                name = wood + "_" + type;
                itemBuilder.put((Object)name, (Object)ITEMS.register(name, () -> {
                    if (wood.isFlammable()) {
                        return new BurnableBlockItem((Block)((RegistryObject)muchmoremodcompat.get((Object)name)).get(), wood.isAvailable() ? modItemProperties : dummyProperty, 300);
                    }
                    return new BlockItem((Block)((RegistryObject)muchmoremodcompat.get((Object)name)).get(), wood.isAvailable() ? modItemProperties : dummyProperty);
                }));
            }
        }
        DECORATIVE_ITEMBLOCKS = itemBuilder.build();
    }
}

