/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai;

import com.bobmowzie.mowziesmobs.server.ai.MMPathFinder;
import com.bobmowzie.mowziesmobs.server.ai.MMWalkNodeProcessor;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MMPathNavigateGround
extends GroundPathNavigator {
    static final float EPSILON = 1.0E-8f;

    public MMPathNavigateGround(MowzieEntity entity, World world) {
        super((MobEntity)entity, world);
    }

    protected PathFinder func_179679_a(int maxVisitedNodes) {
        this.field_179695_a = new MMWalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        return new MMPathFinder(this.field_179695_a, maxVisitedNodes);
    }

    protected void func_75508_h() {
        Path path = Objects.requireNonNull(this.field_75514_c);
        Vector3d entityPos = this.func_75502_i();
        int pathLength = path.func_75874_d();
        for (int i = path.func_75873_e(); i < path.func_75874_d(); ++i) {
            if ((double)path.func_75877_a((int)i).field_75837_b == Math.floor(entityPos.field_72448_b)) continue;
            pathLength = i;
            break;
        }
        Vector3d base = entityPos.func_72441_c((double)(-this.field_75515_a.func_213311_cf() * 0.5f), 0.0, (double)(-this.field_75515_a.func_213311_cf() * 0.5f));
        Vector3d max = base.func_72441_c((double)this.field_75515_a.func_213311_cf(), (double)this.field_75515_a.func_213302_cg(), (double)this.field_75515_a.func_213311_cf());
        if (this.tryShortcut(path, new Vector3d(this.field_75515_a.func_226277_ct_(), this.field_75515_a.func_226278_cu_(), this.field_75515_a.func_226281_cx_()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.field_75515_a.func_213311_cf() * 0.5f))) {
            path.func_75872_c(path.func_75873_e() + 1);
        }
        this.func_179677_a(entityPos);
    }

    private boolean isAt(Path path, float threshold) {
        Vector3d pathPos = path.func_75878_a((Entity)this.field_75515_a);
        return MathHelper.func_76135_e((float)((float)(this.field_75515_a.func_226277_ct_() - pathPos.field_72450_a))) < threshold && MathHelper.func_76135_e((float)((float)(this.field_75515_a.func_226281_cx_() - pathPos.field_72449_c))) < threshold && Math.abs(this.field_75515_a.func_226278_cu_() - pathPos.field_72448_b) < 1.0;
    }

    private boolean atElevationChange(Path path) {
        int curr = path.func_75873_e();
        int end = Math.min(path.func_75874_d(), curr + MathHelper.func_76123_f((float)(this.field_75515_a.func_213311_cf() * 0.5f)) + 1);
        int currY = path.func_75877_a((int)curr).field_75837_b;
        for (int i = curr + 1; i < end; ++i) {
            if (path.func_75877_a((int)i).field_75837_b == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(Path path, Vector3d entityPos, int pathLength, Vector3d base, Vector3d max) {
        int i = pathLength;
        while (--i > path.func_75873_e()) {
            Vector3d vec = path.func_75881_a((Entity)this.field_75515_a, i).func_178788_d(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.func_75872_c(i);
            return false;
        }
        return true;
    }

    protected boolean func_75493_a(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ) {
        return true;
    }

    private boolean sweep(Vector3d vec, Vector3d base, Vector3d max) {
        float t = 0.0f;
        float max_t = (float)vec.func_72433_c();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] tr = new float[3];
        int[] ldi = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (int i = 0; i < 3; ++i) {
            float value = MMPathNavigateGround.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = MMPathNavigateGround.element(dir ? max : base, i);
            tr[i] = MMPathNavigateGround.element(dir ? base : max, i);
            ldi[i] = MMPathNavigateGround.leadEdgeToInt(lead, step[i]);
            tri[i] = MMPathNavigateGround.trailEdgeToInt(tr[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = MathHelper.func_76135_e((float)(max_t / value));
            float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        BlockPos.Mutable pos = new BlockPos.Mutable();
        do {
            int axis = tNext[0] < tNext[1] ? (tNext[0] < tNext[2] ? 0 : 2) : (tNext[1] < tNext[2] ? 1 : 2);
            float dt = tNext[axis] - t;
            t = tNext[axis];
            int n = axis;
            ldi[n] = ldi[n] + step[axis];
            int n2 = axis;
            tNext[n2] = tNext[n2] + tDelta[axis];
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                tr[n3] = tr[n3] + dt * normed[i];
                tri[i] = MMPathNavigateGround.trailEdgeToInt(tr[i], step[i]);
            }
            int stepx = step[0];
            int x0 = axis == 0 ? ldi[0] : tri[0];
            int x1 = ldi[0] + stepx;
            int stepy = step[1];
            int y0 = axis == 1 ? ldi[1] : tri[1];
            int y1 = ldi[1] + stepy;
            int stepz = step[2];
            int z0 = axis == 2 ? ldi[2] : tri[2];
            int z1 = ldi[2] + stepz;
            for (int x = x0; x != x1; x += stepx) {
                for (int z = z0; z != z1; z += stepz) {
                    for (int y = y0; y != y1; y += stepy) {
                        BlockState block = this.field_75513_b.func_180495_p((BlockPos)pos.func_181079_c(x, y, z));
                        if (block.func_196957_g((IBlockReader)this.field_75513_b, (BlockPos)pos, PathType.LAND)) continue;
                        return false;
                    }
                    PathNodeType below = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, x, y0 - 1, z, this.field_75515_a, 1, 1, 1, true, true);
                    if (below == PathNodeType.WATER || below == PathNodeType.LAVA || below == PathNodeType.OPEN) {
                        return false;
                    }
                    PathNodeType in = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, x, y0, z, this.field_75515_a, 1, y1 - y0, 1, true, true);
                    float priority = this.field_75515_a.func_184643_a(in);
                    if (priority < 0.0f || priority >= 8.0f) {
                        return false;
                    }
                    if (in != PathNodeType.DAMAGE_FIRE && in != PathNodeType.DANGER_FIRE && in != PathNodeType.DAMAGE_OTHER) continue;
                    return false;
                }
            }
        } while (t <= max_t);
        return true;
    }

    static int leadEdgeToInt(float coord, int step) {
        return MathHelper.func_76141_d((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return MathHelper.func_76141_d((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(Vector3d v, int i) {
        switch (i) {
            case 0: {
                return (float)v.field_72450_a;
            }
            case 1: {
                return (float)v.field_72448_b;
            }
            case 2: {
                return (float)v.field_72449_c;
            }
        }
        return 0.0f;
    }
}

