/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.tools.geckolib;

import com.bobmowzie.mowziesmobs.server.entity.IAnimationTickable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;

public class MowzieAnimationController<T extends IAnimatable & IAnimationTickable>
extends AnimationController<T> {
    private double tickOffset = 0.0;

    public MowzieAnimationController(T animatable, String name, float transitionLengthTicks, AnimationController.IAnimationPredicate<T> animationPredicate) {
        super(animatable, name, transitionLengthTicks, animationPredicate);
    }

    public void playAnimation(T animatable, AnimationBuilder animationBuilder) {
        this.markNeedsReload();
        this.setAnimation(animationBuilder);
        this.currentAnimation = (Animation)this.animationQueue.poll();
        this.isJustStarting = true;
        this.adjustTick(((IAnimationTickable)animatable).tickTimer());
        this.transitionLengthTicks = 0.0;
    }

    protected double adjustTick(double tick) {
        if (this.shouldResetTick) {
            if (this.getAnimationState() == AnimationState.Transitioning) {
                this.tickOffset = tick;
            } else if (this.getAnimationState() == AnimationState.Running) {
                this.tickOffset += this.transitionLengthTicks;
            }
            this.shouldResetTick = false;
        }
        return Math.max(tick - this.tickOffset, 0.0);
    }
}

