/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.tools.dynamics;

import com.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class DynamicChain {
    private Vector3d[] p;
    private Vector3d[] v;
    private Vector3d[] a;
    private Vector3d[] F;
    private float[] m;
    private float[] d;
    private Vector3d[] T;
    private Vector3d[] r;
    private Vector3d[] rv;
    private Vector3d[] ra;
    private final Entity entity;
    private Vector3d prevP;
    private Vector3d prevV;
    private Vector3d[] pOrig;
    private int prevUpdateTick;

    public DynamicChain(Entity entity) {
        this.entity = entity;
        this.p = new Vector3d[0];
        this.v = new Vector3d[0];
        this.a = new Vector3d[0];
        this.F = new Vector3d[0];
        this.m = new float[0];
        this.d = new float[0];
        this.T = new Vector3d[0];
        this.ra = new Vector3d[0];
        this.rv = new Vector3d[0];
        this.r = new Vector3d[0];
        this.pOrig = new Vector3d[0];
        this.prevUpdateTick = -1;
    }

    public void updateBendConstraint(float gravityAmount, float stiffness, float stiffnessFalloff, float damping, int numUpdates, boolean useFloor) {
        Vector3d[] prevPos = new Vector3d[this.p.length];
        Vector3d[] prevVel = new Vector3d[this.v.length];
        for (int i = 0; i < this.p.length; ++i) {
            prevPos[i] = this.p[i];
            prevVel[i] = this.v[i];
        }
        for (int j = 0; j < numUpdates; ++j) {
            for (int i = 0; i < this.p.length - 1; ++i) {
                if (i == 0) {
                    Vector3d root;
                    this.p[i] = root = this.pOrig[i];
                    this.v[i] = this.p[i].func_178788_d(prevPos[i]);
                    this.a[i] = this.v[i].func_178788_d(prevVel[i]);
                }
                Vector3d target = DynamicChain.angleBetween(this.pOrig[i], this.pOrig[i + 1]);
                this.r[i] = DynamicChain.angleBetween(this.p[i], this.p[i + 1]);
                this.T[i] = DynamicChain.wrapAngles(this.r[i].func_178788_d(target)).func_186678_a((double)(-stiffness) / Math.pow(i + 1, stiffnessFalloff));
                double down = 1.5707963267948966;
                Vector3d gravityVec = DynamicChain.wrapAngles(new Vector3d(0.0, (double)(gravityAmount * this.d[i + 1] * this.m[i + 1]) * Math.sin(down - this.r[i].field_72448_b + down), 0.0));
                Vector3d floorVec = new Vector3d(0.0, (double)(1.0f * this.d[i + 1] * this.m[i + 1]) * Math.sin(1.5707963267948966 - this.r[i].field_72448_b + 1.5707963267948966), 0.0);
                if (useFloor && this.entity.func_233570_aj_() && this.p[i + 1].field_72448_b < this.entity.func_226278_cu_()) {
                    this.T[i] = this.T[i].func_178788_d(floorVec);
                }
                this.T[i] = DynamicChain.wrapAngles(this.T[i].func_178787_e(gravityVec));
                this.ra[i] = this.T[i].func_186678_a((double)(1.0f / (this.m[i + 1] * this.d[i + 1] * this.d[i + 1])));
                this.rv[i] = this.rv[i].func_178787_e(this.ra[i].func_186678_a((double)(1.0f / (float)numUpdates))).func_186678_a((double)damping);
                this.rv[i] = DynamicChain.wrapAngles(this.rv[i]);
                this.r[i] = this.r[i].func_178787_e(this.rv[i].func_186678_a((double)(1.0f / (float)numUpdates)));
                this.r[i] = DynamicChain.wrapAngles(this.r[i]);
                this.p[i + 1] = DynamicChain.fromPitchYaw((float)(this.r[i].field_72448_b - 1.5707963267948966), (float)(this.r[i].field_72450_a - 1.5707963267948966)).func_186678_a((double)this.d[i + 1]).func_178787_e(this.p[i]);
                this.v[i + 1] = this.p[i + 1].func_178788_d(prevPos[i + 1]);
                this.a[i + 1] = this.v[i + 1].func_178788_d(prevVel[i + 1]);
            }
        }
    }

    public void updateSpringConstraint(float gravityAmount, float dampAmount, float stiffness, float maxForce, boolean doAttract, float attractFalloff, int numUpdates) {
        for (int j = 0; j < numUpdates; ++j) {
            for (int i = 0; i < this.p.length; ++i) {
                Vector3d disp;
                this.a[i] = this.F[i].func_186678_a((double)(1.0f / this.m[i]));
                this.v[i] = this.v[i].func_178787_e(this.a[i].func_186678_a((double)(1.0f / (float)numUpdates)));
                this.p[i] = this.p[i].func_178787_e(this.v[i].func_186678_a((double)(1.0f / (float)numUpdates)));
                if (i == 0) {
                    Vector3d root = this.pOrig[i];
                    disp = this.p[i].func_178788_d(root);
                } else {
                    disp = this.p[i].func_178788_d(this.p[i - 1]);
                }
                disp = disp.func_72432_b().func_186678_a(disp.func_72433_c() - (double)this.d[i]);
                Vector3d damp = this.v[i].func_186678_a((double)dampAmount);
                Vector3d gravity = new Vector3d(0.0, (double)(-gravityAmount), 0.0);
                Vector3d attract = this.pOrig[0].func_178788_d(this.p[i]);
                this.F[i] = disp.func_186678_a((double)(-stiffness) * disp.func_72433_c()).func_178787_e(gravity.func_186678_a((double)this.m[i])).func_178788_d(damp);
                if (i == 0 || doAttract) {
                    this.F[i] = this.F[i].func_178787_e(attract.func_186678_a((double)(1.0f / (1.0f + (float)(i * i) * attractFalloff))));
                }
                if (!(this.F[i].func_72433_c() > (double)maxForce)) continue;
                this.F[i].func_72432_b().func_186678_a((double)maxForce);
            }
        }
    }

    public void setChain(AdvancedModelRenderer[] chainOrig, AdvancedModelRenderer[] chainDynamic) {
        int i;
        this.p = new Vector3d[chainOrig.length];
        this.v = new Vector3d[chainOrig.length];
        this.a = new Vector3d[chainOrig.length];
        this.F = new Vector3d[chainOrig.length];
        this.m = new float[chainOrig.length];
        this.d = new float[chainOrig.length];
        this.T = new Vector3d[chainOrig.length];
        this.r = new Vector3d[chainOrig.length];
        this.rv = new Vector3d[chainOrig.length];
        this.ra = new Vector3d[chainOrig.length];
        this.pOrig = new Vector3d[chainOrig.length];
        for (i = 0; i < chainOrig.length; ++i) {
            this.pOrig[i] = chainOrig[i].getWorldPos(this.entity, 0.0f);
            this.p[i] = this.pOrig[i];
            this.v[i] = new Vector3d(0.0, 0.0, 0.0);
            this.a[i] = new Vector3d(0.0, 0.0, 0.0);
            this.F[i] = new Vector3d(0.0, 0.0, 0.0);
            this.T[i] = new Vector3d(0.0, 0.0, 0.0);
            this.r[i] = new Vector3d(0.0, 0.0, 0.0);
            this.rv[i] = new Vector3d(0.0, 0.0, 0.0);
            this.ra[i] = new Vector3d(0.0, 0.0, 0.0);
            this.m[i] = 0.5f + 0.5f / (float)(i + 1);
            this.d[i] = i > 0 ? (float)this.p[i].func_72438_d(this.p[i - 1]) : 1.0f;
            chainOrig[i].field_78806_j = false;
        }
        for (i = 0; i < chainOrig.length - 1; ++i) {
            this.r[i] = DynamicChain.angleBetween(this.p[i], this.p[i + 1]);
        }
        this.prevP = this.p[0];
        this.prevV = this.v[0];
        for (i = 0; i < chainOrig.length; ++i) {
            if (chainDynamic[i] != null) continue;
            chainDynamic[i] = new AdvancedModelRenderer(chainOrig[i]);
        }
    }

    public void updateChain(float delta, AdvancedModelRenderer[] chainOrig, AdvancedModelRenderer[] chainDynamic, float gravityAmount, float stiffness, float stiffnessFalloff, float damping, int numUpdates, boolean useFloor) {
        int i;
        if (this.p.length != chainOrig.length || Double.isNaN(this.p[1].field_72450_a)) {
            this.setChain(chainOrig, chainDynamic);
        }
        if (this.prevUpdateTick != this.entity.field_70173_aa) {
            for (i = 0; i < chainOrig.length; ++i) {
                this.pOrig[i] = chainOrig[i].getWorldPos(this.entity, delta);
            }
            this.updateBendConstraint(gravityAmount, stiffness, stiffnessFalloff, damping, numUpdates, useFloor);
            this.prevUpdateTick = this.entity.field_70173_aa;
        }
        if (chainDynamic == null) {
            return;
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            delta = 0.5f;
        }
        for (i = chainDynamic.length - 1; i >= 0; --i) {
            if (chainDynamic[i] == null) {
                return;
            }
            Vector3d renderPos = this.p[i].func_178787_e(this.v[i].func_186678_a((double)delta)).func_178787_e(this.a[i].func_186678_a(0.5 * (double)delta * (double)delta));
            chainDynamic[i].setWorldPos(this.entity, renderPos, delta);
            if (i >= chainDynamic.length - 1) continue;
            Vector3d p1 = new Vector3d((double)chainDynamic[i].field_78800_c, (double)chainDynamic[i].field_78797_d, (double)chainDynamic[i].field_78798_e);
            Vector3d p2 = new Vector3d((double)chainDynamic[i + 1].field_78800_c, (double)chainDynamic[i + 1].field_78797_d, (double)chainDynamic[i + 1].field_78798_e);
            Vector3d diff = p2.func_178788_d(p1);
            float yaw = (float)Math.atan2(diff.field_72450_a, diff.field_72449_c);
            float pitch = -((float)Math.asin(diff.field_72448_b / diff.func_72433_c()));
            chainDynamic[i].field_78796_g = chainDynamic[i].defaultRotationY + yaw;
            chainDynamic[i].field_78795_f = chainDynamic[i].defaultRotationZ + pitch;
            chainDynamic[i].field_78808_h = (float)this.r[i].field_72449_c;
            Vector3d diffRotated = diff;
            diffRotated = diffRotated.func_178785_b(yaw);
            diffRotated = diffRotated.func_178789_a(pitch);
        }
    }

    public void render(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, AdvancedModelRenderer[] dynModelRenderers) {
        if (dynModelRenderers == null) {
            return;
        }
        for (int i = 0; i < dynModelRenderers.length - 1; ++i) {
            if (dynModelRenderers[i] == null) {
                return;
            }
            dynModelRenderers[i].func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    private static Vector3d fromPitchYaw(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch));
        float f3 = MathHelper.func_76126_a((float)(-pitch));
        return new Vector3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    private static Vector3d angleBetween(Vector3d p1, Vector3d p2) {
        float dz = (float)(p2.field_72449_c - p1.field_72449_c);
        float dx = (float)(p2.field_72450_a - p1.field_72450_a);
        float dy = (float)(p2.field_72448_b - p1.field_72448_b);
        float yaw = (float)MathHelper.func_181159_b((double)dz, (double)dx);
        float pitch = (float)MathHelper.func_181159_b((double)Math.sqrt(dz * dz + dx * dx), (double)dy);
        return DynamicChain.wrapAngles(new Vector3d((double)yaw, (double)pitch, 0.0));
    }

    public static Vector3d toPitchYaw(Vector3d vector) {
        double f3 = vector.field_72448_b;
        double pitch = -Math.asin(f3);
        double f2 = -Math.cos(pitch);
        double f1 = vector.field_72450_a / f2;
        double yaw = -Math.asin(f1) + 1.5707963267948966;
        return DynamicChain.wrapAngles(new Vector3d(yaw, pitch, 0.0));
    }

    private static Vector3d toEuler(Vector3d axis, double angle) {
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        double t = 1.0 - c;
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        double x = axis.field_72450_a;
        double y = axis.field_72448_b;
        double z = axis.field_72449_c;
        if (x * y * t + z * s > 0.998) {
            yaw = 2.0 * Math.atan2(x * Math.sin(angle / 2.0), Math.cos(angle / 2.0));
            pitch = 1.5707963267948966;
            roll = 0.0;
        } else if (x * y * t + z * s < -0.998) {
            yaw = -2.0 * Math.atan2(x * Math.sin(angle / 2.0), Math.cos(angle / 2.0));
            pitch = -1.5707963267948966;
            roll = 0.0;
        } else {
            yaw = Math.atan2(y * s - x * z * t, 1.0 - (y * y + z * z) * t);
            pitch = Math.asin(x * y * t + z * s);
            roll = Math.atan2(x * s - y * z * t, 1.0 - (x * x + z * z) * t);
        }
        return new Vector3d(yaw, pitch, roll);
    }

    private static Vector3d wrapAngles(Vector3d r) {
        double x;
        double y = r.field_72448_b;
        double z = r.field_72449_c;
        for (x = r.field_72450_a; x > Math.PI; x -= Math.PI * 2) {
        }
        while (x < -Math.PI) {
            x += Math.PI * 2;
        }
        while (y > Math.PI) {
            y -= Math.PI * 2;
        }
        while (y < -Math.PI) {
            y += Math.PI * 2;
        }
        while (z > Math.PI) {
            z -= Math.PI * 2;
        }
        while (z < -Math.PI) {
            z += Math.PI * 2;
        }
        return new Vector3d(x, y, z);
    }

    private static Vector3d multiply(Vector3d u, Vector3d v, boolean preserveDir) {
        if (preserveDir) {
            return new Vector3d(u.field_72450_a * Math.abs(v.field_72450_a), u.field_72448_b * Math.abs(v.field_72448_b), u.field_72449_c * Math.abs(v.field_72449_c));
        }
        return new Vector3d(u.field_72450_a * v.field_72450_a, u.field_72448_b * v.field_72448_b, u.field_72449_c * v.field_72449_c);
    }
}

