/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.network.shared.misc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.steinborn.krypton.mod.shared.network.util.VarIntUtil;
import net.minecraft.network.PacketBuffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PacketBuffer.class})
public abstract class PacketByteBufMixin
extends ByteBuf {
    @Shadow
    @Final
    private ByteBuf field_150794_a;

    @Override
    @Shadow
    public abstract int writeCharSequence(CharSequence var1, Charset var2);

    @Overwrite
    public static int func_150790_a(int value) {
        return VarIntUtil.getVarIntLength(value);
    }

    @Overwrite
    public PacketBuffer func_211400_a(String string, int i) {
        int utf8Bytes = ByteBufUtil.utf8Bytes(string);
        if (utf8Bytes > i) {
            throw new EncoderException("String too big (was " + utf8Bytes + " bytes encoded, max " + i + ")");
        }
        this.func_150787_b(utf8Bytes);
        this.writeCharSequence(string, StandardCharsets.UTF_8);
        return new PacketBuffer(this.field_150794_a);
    }

    @Overwrite
    public PacketBuffer func_150787_b(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.field_150794_a.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            this.field_150794_a.writeShort(w);
        } else {
            PacketByteBufMixin.writeVarIntFull(this.field_150794_a, value);
        }
        return new PacketBuffer(this.field_150794_a);
    }

    private static void writeVarIntFull(ByteBuf buf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            buf.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            buf.writeMedium(w);
        } else if ((value & 0xF0000000) == 0) {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21;
            buf.writeInt(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            buf.writeInt(w);
            buf.writeByte(value >>> 28);
        }
    }
}

