/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens.popup;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TextInputPopup
extends Popup {
    protected Consumer<String> callback;
    protected String input = null;
    protected AdvancedTextField textField;
    protected AdvancedButton doneButton;
    protected Color color;
    protected int width = 250;
    protected String title = "";

    public TextInputPopup(Color color, String title, CharacterFilter filter, int alpha) {
        super(alpha);
        this.init(color, title, filter, null);
    }

    public TextInputPopup(Color color, String title, CharacterFilter filter, int backgroundAlpha, Consumer<String> callback) {
        super(backgroundAlpha);
        this.init(color, title, filter, callback);
    }

    protected void init(Color color, String title, CharacterFilter filter, Consumer<String> callback) {
        this.textField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, filter);
        this.textField.func_146205_d(true);
        this.textField.func_146195_b(false);
        this.textField.func_146203_f(1000);
        this.doneButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.done", new String[0]), true, press -> {
            this.input = this.textField.func_146179_b();
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(this.input);
            }
        });
        this.addButton(this.doneButton);
        if (title != null) {
            this.title = title;
        }
        this.color = color;
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    @Override
    public void render(MatrixStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        if (this.isDisplayed()) {
            int height = 100;
            RenderSystem.enableBlend();
            IngameGui.func_238467_a_((MatrixStack)matrix, (int)(renderIn.field_230708_k_ / 2 - this.width / 2), (int)(renderIn.field_230709_l_ / 2 - height / 2), (int)(renderIn.field_230708_k_ / 2 + this.width / 2), (int)(renderIn.field_230709_l_ / 2 + height / 2), (int)this.color.getRGB());
            RenderSystem.disableBlend();
            AbstractGui.func_238472_a_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)new StringTextComponent(this.title), (int)(renderIn.field_230708_k_ / 2), (int)(renderIn.field_230709_l_ / 2 - height / 2 + 10), (int)Color.WHITE.getRGB());
            this.textField.func_212952_l(renderIn.field_230708_k_ / 2 - this.textField.func_230998_h_() / 2);
            this.textField.setY(renderIn.field_230709_l_ / 2 - this.textField.func_238483_d_() / 2);
            this.textField.func_230431_b_(matrix, mouseX, mouseY, Minecraft.func_71410_x().func_184121_ak());
            this.doneButton.setX(renderIn.field_230708_k_ / 2 - this.doneButton.func_230998_h_() / 2);
            this.doneButton.setY(renderIn.field_230709_l_ / 2 + height / 2 - this.doneButton.func_238483_d_() - 5);
            this.renderButtons(matrix, mouseX, mouseY);
        }
    }

    public void setText(String text) {
        this.textField.func_146180_a("");
        this.textField.func_146191_b(text);
    }

    public String getInput() {
        return this.input;
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 257 && this.isDisplayed()) {
            this.input = this.textField.func_146179_b();
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(this.input);
            }
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(null);
            }
        }
    }
}

