/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import org.infernalstudios.infernalexp.init.IEBlocks;

public class GlowstoneCanyonSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    public GlowstoneCanyonSurfaceBuilder(Codec<SurfaceBuilderConfig> p_i232136_1_) {
        super(p_i232136_1_);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int terrainHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunk, biome, x, z, terrainHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int terrainHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState underwaterBlock, int seaLevel) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int depth = -1;
        int middleBlockExtraDepth = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        for (int y = terrainHeight; y >= 0; --y) {
            mutable.func_181079_c(x, y, z);
            BlockState currentBlockInWorld = chunk.func_180495_p((BlockPos)mutable);
            if (currentBlockInWorld.func_196958_f()) {
                depth = -1;
                continue;
            }
            if (!currentBlockInWorld.func_204520_s().func_206888_e() || currentBlockInWorld.func_177230_c() == Blocks.field_150357_h) continue;
            if (depth == -1) {
                depth = 0;
                if (y >= seaLevel) {
                    BlockState blockBelow = chunk.func_180495_p(mutable.func_177977_b());
                    if (blockBelow.func_196958_f()) {
                        chunk.func_177436_a((BlockPos)mutable, ((Block)IEBlocks.TRAPPED_GLOWDUST_SAND.get()).func_176223_P(), false);
                    } else {
                        chunk.func_177436_a((BlockPos)mutable, topBlock, false);
                    }
                } else if (random.nextInt(70) == 1) {
                    chunk.func_177436_a((BlockPos)mutable, ((Block)IEBlocks.DIMSTONE.get()).func_176223_P(), false);
                } else {
                    chunk.func_177436_a((BlockPos)mutable, ((Block)IEBlocks.DULLSTONE.get()).func_176223_P(), false);
                }
            } else if (depth <= 2 + middleBlockExtraDepth) {
                chunk.func_177436_a((BlockPos)mutable, middleBlock, false);
            } else if (random.nextInt(50) == 1) {
                chunk.func_177436_a((BlockPos)mutable, ((Block)IEBlocks.DIMSTONE.get()).func_176223_P(), false);
            } else {
                chunk.func_177436_a((BlockPos)mutable, ((Block)IEBlocks.DULLSTONE.get()).func_176223_P(), false);
            }
            ++depth;
        }
    }
}

