/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.processors;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import org.infernalstudios.infernalexp.init.IEProcessors;

public class LootChestProcessor
extends StructureProcessor {
    public static final LootChestProcessor INSTANCE = new LootChestProcessor();
    public static final Codec<LootChestProcessor> CODEC = Codec.unit(() -> INSTANCE);

    @ParametersAreNonnullByDefault
    @Nullable
    public Template.BlockInfo process(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoRelative, Template.BlockInfo structureBlockInfoGlobal, PlacementSettings placementSettings, @Nullable Template template) {
        String[] nbtData;
        BlockState blockState = structureBlockInfoGlobal.field_186243_b;
        if (blockState.func_203425_a(Blocks.field_185779_df) && (nbtData = structureBlockInfoGlobal.field_186244_c.func_74779_i("metadata").split("-"))[0].equals("chest")) {
            ChestTileEntity tileEntity = new ChestTileEntity();
            tileEntity.func_189404_a(new ResourceLocation(nbtData[2]), new Random().nextLong());
            return new Template.BlockInfo(structureBlockInfoGlobal.field_186242_a, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Objects.requireNonNull(Direction.func_176739_a((String)nbtData[1]))), tileEntity.serializeNBT());
        }
        return structureBlockInfoGlobal;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return IEProcessors.LOOT_CHEST_PROCESSOR;
    }
}

