/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class ShapeUtil {
    public static List<BlockPos> generateCircle(float radius) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        float thetaIncrement = 1.0f / radius;
        float theta = 0.0f;
        while ((double)theta < Math.PI * 2) {
            posList.add(new BlockPos((double)(MathHelper.func_76134_b((float)theta) * radius), 0.0, (double)(MathHelper.func_76126_a((float)theta) * radius)));
            theta += thetaIncrement;
        }
        return posList;
    }

    public static List<BlockPos> generateSolidCircle(float radius) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int x = (int)(-radius);
        while ((float)x < radius) {
            int z = (int)(-radius);
            while ((float)z < radius) {
                if ((float)(x * x + z * z) <= radius * radius) {
                    posList.add(new BlockPos(x, 0, z));
                }
                ++z;
            }
            ++x;
        }
        return posList;
    }

    public static List<BlockPos> generateSolidSphere(float radius) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int x = (int)(-radius);
        while ((float)x < radius) {
            int y = (int)(-radius);
            while ((float)y < radius) {
                int z = (int)(-radius);
                while ((float)z < radius) {
                    if ((float)(x * x + y * y + z * z) <= radius * radius) {
                        posList.add(new BlockPos(x, y, z));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return posList;
    }

    public static List<BlockPos> generateLine(BlockPos startPos, BlockPos endPos) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        Vector3d vec1 = new Vector3d((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p());
        Vector3d vec2 = new Vector3d((double)endPos.func_177958_n(), (double)endPos.func_177956_o(), (double)endPos.func_177952_p());
        Vector3d diffVec = vec2.func_178788_d(vec1);
        Vector3d incVec = new Vector3d((double)((int)diffVec.field_72450_a) / diffVec.func_72433_c(), (double)((int)diffVec.field_72448_b) / diffVec.func_72433_c(), (double)((int)diffVec.field_72449_c) / diffVec.func_72433_c());
        for (int i = 0; i <= (int)diffVec.func_72433_c(); ++i) {
            posList.add(new BlockPos(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c));
            vec1 = vec1.func_178787_e(incVec);
        }
        return posList;
    }
}

